-- MariaDB dump 10.19  Distrib 10.6.17-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: ferrecon_posinv
-- ------------------------------------------------------
-- Server version	10.6.17-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `ferrecon_posinv`
--


--
-- Table structure for table `back_order_list`
--

DROP TABLE IF EXISTS `back_order_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_order_list` (
  `id` int(30) NOT NULL AUTO_INCREMENT,
  `receiving_id` int(30) NOT NULL,
  `po_id` int(30) NOT NULL,
  `bo_code` varchar(50) NOT NULL,
  `supplier_id` int(30) NOT NULL,
  `amount` float NOT NULL,
  `discount_perc` float NOT NULL DEFAULT 0,
  `discount` float NOT NULL DEFAULT 0,
  `tax_perc` float NOT NULL DEFAULT 0,
  `tax` float NOT NULL DEFAULT 0,
  `remarks` text DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '0 = pending, 1 = partially received, 2 =received',
  `date_created` datetime NOT NULL DEFAULT current_timestamp(),
  `date_updated` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `po_id` (`po_id`),
  KEY `receiving_id` (`receiving_id`),
  CONSTRAINT `back_order_list_ibfk_1` FOREIGN KEY (`supplier_id`) REFERENCES `supplier_list` (`id`) ON DELETE CASCADE,
  CONSTRAINT `back_order_list_ibfk_2` FOREIGN KEY (`po_id`) REFERENCES `purchase_order_list` (`id`) ON DELETE CASCADE,
  CONSTRAINT `back_order_list_ibfk_3` FOREIGN KEY (`receiving_id`) REFERENCES `receiving_list` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_order_list`
--

LOCK TABLES `back_order_list` WRITE;
/*!40000 ALTER TABLE `back_order_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_order_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bo_items`
--

DROP TABLE IF EXISTS `bo_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bo_items` (
  `bo_id` int(30) NOT NULL,
  `item_id` int(30) NOT NULL,
  `quantity` int(30) NOT NULL,
  `price` float NOT NULL DEFAULT 0,
  `unit` varchar(50) NOT NULL,
  `total` float NOT NULL DEFAULT 0,
  KEY `item_id` (`item_id`),
  KEY `bo_id` (`bo_id`),
  CONSTRAINT `bo_items_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item_list` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bo_items_ibfk_2` FOREIGN KEY (`bo_id`) REFERENCES `back_order_list` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bo_items`
--

LOCK TABLES `bo_items` WRITE;
/*!40000 ALTER TABLE `bo_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `bo_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bo_sales_items`
--

DROP TABLE IF EXISTS `bo_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bo_sales_items` (
  `bo_id` int(30) NOT NULL,
  `item_id` int(30) NOT NULL,
  `quantity` int(30) NOT NULL,
  `price` float NOT NULL DEFAULT 0,
  `unit` varchar(50) NOT NULL,
  `total` float NOT NULL DEFAULT 0,
  KEY `item_id` (`item_id`),
  KEY `bo_id` (`bo_id`),
  CONSTRAINT `bo_sales_items_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item_list` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bo_sales_items_ibfk_2` FOREIGN KEY (`bo_id`) REFERENCES `sales_back_order_list` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bo_sales_items`
--

LOCK TABLES `bo_sales_items` WRITE;
/*!40000 ALTER TABLE `bo_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `bo_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Category` text NOT NULL,
  `Date_Created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` (`id`, `Category`, `Date_Created`) VALUES (12,'Aceros','2024-03-06 18:17:48'),(13,'PVC','2024-03-07 20:09:28'),(14,'Herramienta manual','2024-03-08 19:37:07'),(15,'Herramienta electrica','2024-03-08 19:37:19'),(16,'Accesorios','2024-03-08 19:37:28'),(17,'Herramienta inalambrica','2024-03-08 19:37:39'),(18,'Cemento','2024-03-08 19:37:51'),(19,'Morteros','2024-03-08 19:38:00'),(20,'Block','2024-03-08 19:38:08'),(21,'Alquileres','2024-03-08 19:38:20'),(22,'Lijas','2024-03-08 23:37:34'),(23,'Tornillos','2024-03-13 19:20:34'),(24,'CarpinterÃ­a ','2024-03-16 16:42:40'),(25,'Herrajes','2024-03-16 17:45:16'),(26,'CerrajerÃ­a','2024-03-16 17:49:53'),(27,'Cedazos y Mallas MetÃ¡licas ','2024-03-18 14:26:17'),(28,'PlomerÃ­a','2024-03-18 14:41:37'),(29,'Electricidad e IluminaciÃ³n ','2024-03-18 16:33:08'),(30,'Pintura','2024-03-18 16:33:47'),(31,'Adhesivos ','2024-03-19 17:38:31'),(32,'Solventes','2024-04-03 17:01:54'),(33,'CARPINTERIA','2024-03-26 15:40:55'),(34,'Flete','2024-04-03 17:01:08'),(35,'Otros','2024-04-03 17:01:39'),(36,'Cadenas','2024-04-03 17:03:05');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customer_list`
--

DROP TABLE IF EXISTS `customer_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_list` (
  `id` int(30) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `address` text NOT NULL,
  `nit` text NOT NULL,
  `contact` text NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `date_created` datetime NOT NULL DEFAULT current_timestamp(),
  `date_updated` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customer_list`
--

LOCK TABLES `customer_list` WRITE;
/*!40000 ALTER TABLE `customer_list` DISABLE KEYS */;
INSERT INTO `customer_list` (`id`, `name`, `address`, `nit`, `contact`, `status`, `date_created`, `date_updated`) VALUES (1,'Juan Pablo Funes Hernandez','Ciudades','2526907-0','32511989',1,'2023-11-29 22:11:17','2024-04-02 10:09:10'),(2,'Esteban Funes','Ciudad','5874652-0','45789621',1,'2023-12-05 07:02:40','2023-12-05 07:02:40'),(3,'Consumidor Final','Ciudad','CF','',1,'2024-02-10 08:29:26','2024-02-10 08:29:26'),(4,'Luis Recinos','Chimusinique zona 12','12345682-8','54585652',1,'2024-02-10 08:57:04','2024-02-10 08:57:04'),(5,'Juan PÃ©rez ','Ciudad ','2356847','77658596',1,'2024-02-10 10:00:48','2024-02-10 10:00:48'),(6,'Angela de Leon','huehuetenango','56556622','59208236',1,'2024-02-10 10:00:51','2024-02-10 10:00:51'),(7,'Marbin Recinos','Ciudad','CF','47016851',1,'2024-02-10 10:00:51','2024-02-10 10:00:51'),(8,'Arturo Rivas','Ciudad ','4568973','75896324',1,'2024-02-10 11:00:55','2024-02-10 11:00:55'),(9,'Fernando Gomez Palacios','Ciudad ','5863475','74251234',1,'2024-02-10 11:32:57','2024-04-02 10:09:20'),(10,'LORENZO JUAREZ','','CF','54747582',1,'2024-03-26 17:27:24','2024-03-26 17:27:24'),(11,'EQUIPO TYD ','','89473140','',1,'2024-04-03 13:01:13','2024-04-03 13:01:13');
/*!40000 ALTER TABLE `customer_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `item_list`
--

DROP TABLE IF EXISTS `item_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `item_list` (
  `id` int(30) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `description` text NOT NULL,
  `um` varchar(50) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `supplier_id` int(30) NOT NULL,
  `cost` float NOT NULL DEFAULT 0,
  `sale` float DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `stock_minimum` int(11) DEFAULT NULL,
  `barcode` varchar(250) DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT current_timestamp(),
  `date_updated` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  CONSTRAINT `item_list_ibfk_1` FOREIGN KEY (`supplier_id`) REFERENCES `supplier_list` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=787 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `item_list`
--

LOCK TABLES `item_list` WRITE;
/*!40000 ALTER TABLE `item_list` DISABLE KEYS */;
INSERT INTO `item_list` (`id`, `name`, `description`, `um`, `category_id`, `supplier_id`, `cost`, `sale`, `status`, `stock_minimum`, `barcode`, `date_created`, `date_updated`) VALUES (17,'VARILLA G40 3/8 COMERCIAL 8MM MULTI','','Varilla',12,6,19.06,22.25,1,650,NULL,'2024-03-06 15:23:58','2024-04-02 15:26:49'),(18,'50000348 VARILLA 1/4 LISA G40 ORIGINAL','','Varilla',12,6,10,10.8,1,300,NULL,'2024-03-06 15:25:32','2024-04-02 15:28:04'),(19,'50000151-R. ALAMB. DE AMARRE CAL.16-MULTI','50000151-R. ALAMB. DE AMARRE CAL.16-MULTI','LIBRA',12,6,4.5,6.25,1,100,NULL,'2024-03-06 15:27:41','2024-03-06 15:27:41'),(20,'50013761-R. ALAMB. GALV. CAL.14-MULTI','50013761-R. ALAMB. GALV. CAL.14-MULTI','Libra',12,6,5.8,8,1,100,NULL,'2024-03-06 15:29:13','2024-04-02 09:52:40'),(21,'50000484-TUBO GALV. P/CERCA 2','50000484-TUBO GALV. P/CERCA 2 CH16-MULTI','Unidad',12,6,151.8,189,1,25,NULL,'2024-03-06 15:30:32','2024-03-11 14:11:04'),(22,'50002393-ROLLO ALAMB. PUA FINQUERO 400 GALV. CAL.16, 334 METROS- MULTI','50002393-ROLLO ALAMB. PUA FINQUERO 400 GALV. CAL.16, 334 METROS- MULTI','Unidad',12,6,283.57,375,1,10,NULL,'2024-03-06 15:33:29','2024-03-06 15:33:29'),(23,'50000146-CLAVO CON CABEZA PULIDO 2 1/2 MULTI','','LIBRA',12,6,4.9,6.5,1,300,NULL,'2024-03-06 15:35:19','2024-03-26 10:37:04'),(24,'50000148-CLAVO CON CABEZA PULIDO 3- MULTI','','LIBRA',12,6,4.9,6.5,1,300,NULL,'2024-03-06 15:36:31','2024-03-26 10:37:23'),(25,'50000149-CLAVO CON CABEZA PULIDO 4','50000149-CLAVO CON CABEZA PULIDO 4- MULTI','LIBRA',12,6,4.9,7,1,300,NULL,'2024-03-06 15:37:51','2024-03-07 06:09:31'),(26,'50000345 VARILLA G40 5/8 ORIGINAL','','Varilla',12,6,75.96,83,1,100,NULL,'2024-03-06 15:43:59','2024-04-01 10:57:01'),(28,'50000343 VARILLA G40 1/2 ORIGINAL-MULTI','','Varilla',12,6,48.66,52.95,1,40,NULL,'2024-03-07 08:58:20','2024-04-02 15:24:45'),(29,'50010837-LAMINA ALUZINC ACANALADA C28 LEGITIMA X 10 PIES-MULTI','50010837-LAMINA ALUZINC ACANALADA C28 LEGITIMA X 10 PIES-MULTI','Unidad',12,6,105,131.25,1,25,NULL,'2024-03-07 09:01:06','2024-03-07 09:01:06'),(30,'50003062-LAMINA ALUZINC ACANALADA C28 MM X 10 PIES-MULTI','50003062-LAMINA ALUZINC ACANALADA C28 MM X 10 PIES-MULTI','Unidad',12,6,80,100,1,25,NULL,'2024-03-07 09:03:00','2024-03-07 09:03:00'),(31,'50010838-LAMINA ALUZINC ACANALADA C28 LEGITIMA X 12 PIES- MULTI','50010838-LAMINA ALUZINC ACANALADA C28 LEGITIMA X 12PIES- MULTI','Unidad',12,6,126.22,157.75,1,25,NULL,'2024-03-07 10:04:24','2024-03-07 10:04:24'),(32,'50003063-LAMINA ALUZINC ACANALADA C28 MM X 12 PIES- MULTI','50003063-LAMINA ALUZINC ACANALADA C28 MM X 12 PIES- MULTI','Unidad',12,6,90,112.5,1,25,NULL,'2024-03-07 10:06:02','2024-03-07 10:06:02'),(33,'50003065-LAMINA ALUZINC ACANALADA C28 MM X 8 PIES- MULTI','50003065-LAMINA ALUZINC ACANALADA C28 MM X 8 PIES- MULTI','Unidad',12,6,60,75,1,25,NULL,'2024-03-07 10:11:59','2024-03-07 10:11:59'),(34,'50010921-LAMINA ALUZINC ACANALADA C28 LEGITIMA X 08 PIES-MULTI','50010921-LAMINA ALUZINC ACANALADA C28 LEGITIMA X 08 PIES-MULTI','Unidad',12,6,84.2,105,1,25,NULL,'2024-03-07 10:24:13','2024-03-07 10:25:50'),(35,'50012309-LAMINA ALUZINC ACANALADA C28 MM X 9 PIES- MULTI','50012309-LAMINA ALUZINC ACANALADA C28 MM X 9 PIES- MULTI','Unidad',12,6,67.6,85,1,25,NULL,'2024-03-07 10:25:29','2024-03-07 10:25:29'),(36,'50011040-LAMINA ALUZINC ACANALADA C28 LEGITIMA X 09 PIES- MULTI','50011040-LAMINA ALUZINC ACANALADA C28 LEGITIMA X 09 PIES- MULTI','Unidad',12,6,94.63,120,1,25,NULL,'2024-03-07 10:27:23','2024-03-07 10:27:23'),(37,'102058 TUBO PRESION 315 PSI SDR13.5 1/2','','Unidad',13,5,13.28,20.5,1,50,NULL,'2024-03-07 14:14:05','2024-04-02 10:43:35'),(38,'102059 TUBO PRESION 250PSI SDR17 3/4 ','','Unidad',13,5,17.14,23,1,50,NULL,'2024-03-07 14:15:31','2024-04-02 10:43:53'),(39,'102082 TUBO PRESION 125PSI SDR32.5 DE 1','','Unidad',13,5,17.14,23,1,50,NULL,'2024-03-07 14:32:09','2024-04-02 10:45:44'),(40,'100541 CODO 90 1/2','','Unidad',13,5,0.7,1.5,1,20,NULL,'2024-03-07 14:34:52','2024-04-02 10:15:46'),(41,'100542 CODO 90 3/4','','Unidad',13,5,1.02,2,1,25,NULL,'2024-03-07 16:18:21','2024-04-02 10:18:05'),(42,'100543 CODO 90 DE 1 ','','Unidad',13,5,2.2,3.5,1,25,NULL,'2024-03-07 16:20:42','2024-04-02 10:16:08'),(43,'100628 CODO 45 1/2','','Unidad',13,5,2.75,4,1,25,NULL,'2024-03-07 16:22:20','2024-04-02 10:18:55'),(44,'100629 CODO 45 3/4','','Unidad',13,5,2.75,3.75,1,25,NULL,'2024-03-07 16:23:35','2024-04-02 10:19:21'),(45,'100630 CODO 45 1','','Unidad',13,5,3.7,5,1,25,NULL,'2024-03-07 16:25:33','2024-04-02 10:19:52'),(46,'100550 TAPON 1/2','','Unidad',13,5,0.73,1,1,25,NULL,'2024-03-07 16:26:45','2024-04-02 10:16:24'),(47,'100551 TAPON 3/4','','Unidad',13,5,1.3,2.5,1,25,NULL,'2024-03-07 16:28:15','2024-04-02 10:16:42'),(48,'100552 TAPON 1 1/2','','Unidad',13,5,2.85,4,1,25,NULL,'2024-03-07 16:29:28','2024-04-02 10:17:04'),(49,'100556 TEE 1/2','','Unidad',13,5,0.8,1.15,1,25,NULL,'2024-03-07 16:30:41','2024-04-02 10:17:49'),(50,'100557 TEE 3/4','','Unidad',13,5,1.18,1.75,1,25,NULL,'2024-03-07 16:37:58','2024-04-02 10:18:22'),(51,'100558 TEE PRESION 1','','Unidad',13,5,2.23,3.5,1,25,NULL,'2024-03-07 16:48:12','2024-04-02 10:17:27'),(52,'102981 SOLDADURA 25 ML (PEGAMENTO PARA PVC)','','Unidad',13,5,6.44,9,1,10,NULL,'2024-03-07 16:51:38','2024-04-02 10:57:04'),(53,'101031 SOLDADURA (PEGAMENTO) PVC 1/32 GALON','','Unidad',13,5,19.31,28,1,10,NULL,'2024-03-07 16:52:47','2024-04-02 10:21:37'),(54,'102006 TUBO BAJADA PLUVIAL 2 PLG 6M JC NARANJA ','','Unidad',13,5,25.53,38.5,1,25,NULL,'2024-03-07 16:54:52','2024-04-02 10:30:28'),(55,'102056 TUBO BAJADA PLUVIAL 3 PLG 6M JC NARANJA','','Unidad',13,5,40.7,56.5,1,25,NULL,'2024-03-07 16:56:18','2024-04-02 10:38:18'),(56,'102057 TUBO BAJADA PLUVIAL 4 PLG 6M JC NARANJA','','Unidad',13,5,66.23,97,1,25,NULL,'2024-03-07 16:57:23','2024-04-02 10:38:36'),(57,'102657 CODO 45 SANIT 3 PLG','','Unidad',13,5,7.68,10.75,1,25,NULL,'2024-03-07 16:59:37','2024-04-02 10:54:29'),(58,'101874 CODO 45 SANIT 4 PLG GRIS','','Unidad',13,5,13.95,20,1,25,NULL,'2024-03-07 17:03:41','2024-04-02 10:29:16'),(59,'102581 CODO 90 SANIT 3 PLG GRIS','','Unidad',13,5,9.18,13,1,25,NULL,'2024-03-07 17:04:52','2024-04-02 10:55:31'),(60,'100687 CODO 90 SANIT 4 PLG GRIS','','Unidad',13,5,16.86,25,1,25,NULL,'2024-03-07 17:06:42','2024-04-02 10:21:08'),(61,'102583 TEE SANIT 3 GRIS','','Unidad',13,5,12.21,17,1,25,NULL,'2024-03-07 17:07:40','2024-04-02 10:51:25'),(62,'102573 TEE SANIT 4 PLG GRIS ','','Unidad',13,5,19.91,27.75,1,25,NULL,'2024-03-07 17:13:35','2024-04-02 10:46:38'),(63,'102064 TUBO CONDUIT 3/4 PLG 3M SC NARANJA (DUCTO ELECTRICO PVC)','','Unidad',13,5,7.12,10,1,25,NULL,'2024-03-07 17:15:46','2024-04-02 10:44:53'),(64,'102640 CURVA CONDUIT 90X3/4 PLG JC NARANJA','','Unidad',13,5,1.29,2,1,25,NULL,'2024-03-07 17:16:56','2024-04-02 10:51:58'),(65,'101691 BROCA PARA MADERA DE 1/4 PLG, TRUPER ','','Unidad',16,7,6.2,8.75,1,10,NULL,'2024-03-08 13:45:40','2024-03-26 10:21:02'),(66,'101696 BROCA PARA MADERA 1/2 PLG, TRUPER','','Unidad',16,7,17.47,25,1,10,NULL,'2024-03-08 13:47:52','2024-03-26 10:03:46'),(67,'101739 JUEGO DE 2 SUJETADORES CARGA MAXIMA 400 KG','CON MATRACA, TRUPER','Juego',16,7,74.35,106.25,1,5,NULL,'2024-03-08 13:51:16','2024-04-02 10:23:41'),(68,'101831 JUEGO DE 2 SUJETADORES MAX 1500KG','CON MATRACA, TRUPER ','Juego',16,7,184.7,264,1,5,NULL,'2024-03-08 13:53:37','2024-04-02 10:24:15'),(69,'10234 ARCO 12 PLG TUBULAR DE ACERO PARA SEGUETA','TRUPER','Unidad',14,7,57.2,82,1,10,NULL,'2024-03-08 14:08:43','2024-04-02 10:23:02'),(70,'10337 ESCALERA DE TIJERA TIPO II 7 PELDAÃ‘OS Y BANDEJA, TRUPER ','','Unidad',14,7,808.55,1200,1,5,NULL,'2024-03-08 14:13:55','2024-04-02 09:12:39'),(71,'10344 PALA T-2000, CUADRADA, PUÃ‘O Y, SALVADOR, TRUPER','','Unidad',14,7,50.7,72.5,1,5,NULL,'2024-03-08 14:17:28','2024-04-02 09:13:26'),(72,'10359 AZADON CENTROAMERICANO 2.0 LB SIN MANGO, TRUPER','','Unidad',14,7,57.25,82,1,5,NULL,'2024-03-08 14:21:03','2024-04-02 09:18:17'),(73,'10362 AZADON CENTROAMERICANO 2.8 LB SIN MANGO, TRUPER ','','Unidad',14,7,65,93,1,5,NULL,'2024-03-08 14:22:23','2024-04-02 09:18:35'),(74,'10548 EXTENSION DE ACERO PARA RODILLO, 2.4 M, TRUPER','','Unidad',30,7,29.51,45,1,5,NULL,'2024-03-08 14:28:36','2024-04-02 09:18:56'),(75,'10549 EXTENSION DE ACERO PARA RODILLO, 3M, TRUPER ','','Unidad',30,7,35.54,52,1,5,NULL,'2024-03-08 14:30:00','2024-04-02 09:19:12'),(76,'10746 FLEXOMETRO AUTO-LOCK CONTRA IMPACTO 3 M CINTA 16 MM, TRUPER','','Unidad',14,7,16.46,25,1,5,NULL,'2024-03-08 14:31:15','2024-04-02 09:20:07'),(77,'10749 FLEXOMETRO AUTO-LOCK CONTRA IMPACTO 8 M CINTA 25 MM, TRUPER','','Unidad',14,7,50.37,72,1,5,NULL,'2024-03-08 14:32:15','2024-04-02 09:20:25'),(78,'10759 BARRETA PARA TIERRA DURA 1 PULG X 150 CM, ESCOPLO 67 MM, TRUPER','','Unidad',14,7,155,225,1,5,NULL,'2024-03-08 14:33:35','2024-04-02 09:20:45'),(79,'10856 BARRETA DE UNA DE 3/4 PULG X 60 CM, TRUPER ','','Unidad',14,7,52,74.5,1,5,NULL,'2024-03-08 15:27:42','2024-04-02 10:36:25'),(80,'10859 BARRETA DE UNA DE 3/4 PULG X 75 CM, TRUPER','','Unidad',14,7,60,85.75,1,5,NULL,'2024-03-08 15:36:42','2024-04-02 10:35:28'),(81,'10942 TRIANGULO DE SEGURIDAD DE 44 CM DE ALTO CON ESTUCHE PLASTICO, TRUPER','','Unidad',16,7,74.5,106.5,1,5,NULL,'2024-03-08 15:45:19','2024-04-02 09:22:28'),(82,'10943 TRIANGULO DE SEGURIDAD DE 29 CM DE ALTO CON ESTUCHE PLASTICO, TRUPER ','','Unidad',16,7,60.85,87,1,5,NULL,'2024-03-08 15:47:39','2024-04-02 09:23:26'),(83,'11004 SIERRA CIRCULAR 7-1/4 PULG 1750 W, PROFESIONAL, TRUPER','','Unidad',15,7,512.75,732.5,1,5,NULL,'2024-03-08 15:50:23','2024-04-02 09:23:54'),(84,'11095 PISTOLA P/PINTAR GRAVEDAD LVMP VASO ALUMINIO, 1.4 MM, TRUPER','','Unidad',30,7,135,193,1,5,NULL,'2024-03-08 15:53:29','2024-04-02 09:24:16'),(85,'11118 BROCA HSS 1/8 PULG, TRUGOLD PARA METAL, TRUPER EXPERT','','Unidad',16,7,3.65,5.25,1,10,NULL,'2024-03-08 15:55:52','2024-04-02 09:24:40'),(86,'11120 BROCA HSS 9/64 PULG, TRUGOLD PARA METAL, TRUPER EXPERT','','Unidad',16,7,6,8.75,1,10,NULL,'2024-03-08 15:59:30','2024-04-02 09:24:59'),(87,'11122 BROCA HSS 5/32 PLG, TRUGOLD PARA METAL, TRUPER  EXPERT','','Unidad',16,7,6.25,9,1,10,NULL,'2024-03-08 16:03:13','2024-04-02 09:25:16'),(88,'11126 BROCA HSS 3/16 PLG, TRUGOLD PARA METAL, TRUPER  EXPERT','','Unidad',16,7,6.5,9.5,1,10,NULL,'2024-03-08 16:08:05','2024-04-01 18:15:53'),(89,'11134 BROCA HSS 1/4 PLG, TRUGOLD PARA METAL, TRUPER  EXPERT','','Unidad',16,7,10.75,15.5,1,10,NULL,'2024-03-08 16:09:45','2024-04-01 18:14:54'),(90,'11142 BROCA HSS 5/16 PLG, TRUGOLD PARA METAL, TRUPER  EXPERT','','Unidad',16,7,20.55,29.5,1,10,NULL,'2024-03-08 16:11:41','2024-04-01 18:21:34'),(91,'11150 BROCA HSS 3/8 PLG, TRUGOLD PARA METAL, TRUPER EXPERT','','Unidad',16,7,25,35.75,1,10,NULL,'2024-03-08 16:13:06','2024-04-01 18:19:48'),(92,'11200 BROCA PARA CONCRETO DE 3/16 X 4 PLG, TRUPER','','Unidad',16,7,6.5,9.5,1,10,NULL,'2024-03-08 16:14:40','2024-04-01 18:27:44'),(93,'11203 BROCA PARA CONCRETO DE 1/4 X 4 PLG, TRUPER','','Unidad',16,7,6.75,9.75,1,10,NULL,'2024-03-08 16:16:01','2024-04-01 18:28:28'),(94,'11206 BROCA PARA CONCRETO DE 1/4 X 6 PLG, TRUPER','','Unidad',16,7,8.6,12.5,1,10,NULL,'2024-03-08 16:22:05','2024-04-01 18:22:51'),(95,'11207 EMBUDO PLASTICO 500 ML, CUELLO FLEXIBLE CON FILTRO , TRUPER','','Unidad',16,7,12.7,18.25,1,5,NULL,'2024-03-08 16:24:49','2024-04-02 09:27:30'),(96,'11212 BROCA PARA CONCRETO DE 5/16 X 4 PLG, TRUPER','','Unidad',16,7,9.7,14,1,10,NULL,'2024-03-08 16:26:16','2024-04-01 18:32:12'),(97,'11215 BROCA PARA CONCRETO DE 5/16 X 6 PLG, TRUPER ','','Unidad',16,7,10.2,14.75,1,10,NULL,'2024-03-08 16:29:22','2024-04-01 18:33:28'),(98,'11224 BROCA CONCRETO 3/8 X 6 PLG, TRUPER','','Unidad',16,7,12.85,18.5,1,10,NULL,'2024-03-08 16:35:21','2024-03-26 10:57:10'),(99,'11230 BROCA PARA CONCRETO 1/2 X 6 PLG, TRUPER','','Unidad',16,7,21.7,31,1,10,NULL,'2024-03-08 17:00:21','2024-04-01 18:35:03'),(100,'11263 BROCA  SDS PLUS 1/4 X 4 PLG, TRUPER','','Unidad',16,7,14,20,1,10,NULL,'2024-03-08 17:11:45','2024-04-02 09:28:37'),(101,'11264 BROCA SDS PLUS 1/4 X 6 PLG, TRUPER','','Unidad',16,7,14,20,1,10,NULL,'2024-03-08 17:13:23','2024-04-02 09:28:56'),(102,'11269 BROCA SDS PLUS 5/16 X 6 PLG, TRUPER ','','Unidad',16,7,15.95,22.75,1,10,NULL,'2024-03-08 17:15:34','2024-04-02 09:29:24'),(103,'11272 BROCA SDS PLUS 3/8 X 6 PLG, TRUPER','','Unidad',16,7,16.05,23,1,10,NULL,'2024-03-08 17:17:16','2024-04-02 11:28:07'),(104,'11279 BROCA SDS PLUS 1/2 X 6 PLG, TRUPER','','Unidad',16,7,28.15,40.25,1,10,NULL,'2024-03-08 17:19:43','2024-04-02 09:30:07'),(105,'11284 BROCA SDS PLUS 5/8 X 8 PLG, TRUPER','','Unidad',16,7,46.05,66,1,10,NULL,'2024-03-08 17:21:09','2024-04-02 09:30:32'),(106,'11366 BROCA PLANA DE MANITA 3/8 PLG PARA MADERA, TRUPER','','Unidad',16,7,14,20,1,10,NULL,'2024-03-08 17:23:48','2024-04-02 09:31:04'),(107,'11372 BROCA PLANA  DE MANITA 1/2 PLG PARA MADERA, TRUPER ','','Unidad',16,7,14.7,21,1,10,NULL,'2024-03-08 17:25:08','2024-04-02 09:31:23'),(108,'11378 BROCA PLANA DE MANITA 3/4 PLG PARA MADERA, TRUPER ','','Unidad',16,7,17,24.5,1,10,NULL,'2024-03-08 17:27:04','2024-04-02 09:31:46'),(109,'11396 JUEGO DE 7 BROCAS HSS PARA METAL EN ESTUCHE, TRUPER EXPERT','','Estuche',16,7,53.5,76.5,1,5,NULL,'2024-03-08 17:29:07','2024-04-02 09:32:10'),(110,'11582 DISCO DE DIAMANTE DE 4-1/2 PLG X 2.1 MM, RIN SEGMENTADO, TRUPER','','Unidad',16,7,33,47.5,1,10,NULL,'2024-03-08 17:31:22','2024-04-02 09:32:34'),(111,'11584 DISCO TIPO 41 DE 4-1/2 PLG X 1.2 MM, CORTE FINO DE METAL, SABLE, TRUPER','','Unidad',16,7,4.65,7.5,1,10,NULL,'2024-03-08 17:33:45','2024-04-02 09:33:02'),(112,'11585 DISCO TIPO 41 DE 4-1/2 PLG X 1.6 MM CORTE FINO DE METAL, SABLE','','Unidad',16,7,5.5,8,1,10,NULL,'2024-03-08 17:35:26','2024-04-03 12:07:34'),(113,'11600 LIJA DE ESMERIL NEGRA GRANO 36 DE OXIDO DE ALUMINIO, TRUPER','','Unidad',22,7,5.5,8,1,10,NULL,'2024-03-08 17:38:28','2024-04-03 12:08:13'),(114,'11601 LIJA DE ESMERIL NEGRA GRANO 50 DE OXIDO DE ALUMINIO, TRUPER','','Unidad',22,7,4.75,7,1,10,NULL,'2024-03-08 17:40:30','2024-04-03 12:08:35'),(115,'11602 LIJA DE ESMERIL NEGRA GRANO 80 DE OXIDO DE ALUMINIO, TRUPER','','Unidad',22,7,4.5,6.5,1,10,NULL,'2024-03-08 17:42:01','2024-04-03 12:08:55'),(116,'11603 LIJA DE ESMERIL NEGRA GRANO 120 DE OXIDO DE ALUMINIO, TRUPER','','Unidad',22,7,4.4,6.5,1,10,NULL,'2024-03-09 08:05:41','2024-04-03 12:09:17'),(117,'11610 LIJA PARA MADERA PAPEL CABINET, GRANO 80, TRUPER','','Unidad',22,7,2.4,3.5,1,10,NULL,'2024-03-09 08:16:20','2024-04-03 12:09:53'),(118,'11611 LIJA PARA MADERA PAPEL CABINET, GRANO 100, TRUPER','','Unidad',22,7,2.3,3.5,1,10,NULL,'2024-03-09 08:18:23','2024-04-03 12:10:15'),(119,'11612 LIJA PARA MADERA PAPEL CABINET, GRANO 120, TRUPER','','Unidad',22,7,2.3,3.5,1,10,NULL,'2024-03-09 08:21:38','2024-04-03 12:10:42'),(120,'11613 LIJA PARA MADERA PAPEL CABINET, GRANO 150, TRUPER','','Unidad',22,7,2.3,3.5,1,10,NULL,'2024-03-09 08:22:37','2024-04-03 12:11:03'),(121,'11614 LIJA PARA MADERA PAPEL CABINET, GRANO 180, TRUPER','','Unidad',22,7,2.3,3.5,1,10,NULL,'2024-03-09 08:23:58','2024-04-03 12:11:22'),(122,'11618 LIJA DE AGUA GRANO 80 DE CARBURO DE SILICIO, TRUPER ','11618 LIJA DE AGUA GRANO 80 DE CARBURO DE SILICIO, TRUPER ','Unidad',22,7,2.75,4,1,10,NULL,'2024-03-09 08:25:08','2024-03-09 08:25:08'),(123,'11619 LIJA DE AGUA GRANO 100 DE CARBURO DE SILICIO, TRUPER','11619 LIJA DE AGUA GRANO 100 DE CARBURO DE SILICIO, TRUPER','Unidad',22,7,2.6,3.75,1,10,NULL,'2024-03-09 08:31:06','2024-03-09 08:31:06'),(124,'11620 LIJA DE AGUA GRANO 120 DE CARBURO DE SILICIO, TRUPER','11620 LIJA DE AGUA GRANO 120 DE CARBURO DE SILICIO, TRUPER','Unidad',22,7,2.55,3.75,1,10,NULL,'2024-03-09 08:32:29','2024-03-09 08:32:29'),(125,'11621 LIJA DE AGUA GRANO 150 DE CARBURO DE SILICIO, TRUPER','11621 LIJA DE AGUA GRANO 150 DE CARBURO DE SILICIO, TRUPER','Unidad',22,7,2.5,3.75,1,10,NULL,'2024-03-09 08:34:22','2024-03-09 08:34:22'),(126,'11622 LIJA DE AGUA GRANO 180 DE CARBURO DE SILICIO, TRUPER','11622 LIJA DE AGUA GRANO 180 DE CARBURO DE SILICIO, TRUPER','Unidad',22,7,2.5,3.75,1,10,NULL,'2024-03-09 08:35:29','2024-03-09 08:35:29'),(127,'11623 LIJA DE AGUA GRANO 220 DE CARBURO DE SILICIO, TRUPER','11623 LIJA DE AGUA GRANO 220 DE CARBURO DE SILICIO, TRUPER','Unidad',22,7,2.5,3.75,1,10,NULL,'2024-03-09 08:36:47','2024-03-09 08:36:47'),(128,'11624 LIJA DE AGUA GRANO 240 DE CARBURO DE SILICIO, TRUPER','11624 LIJA DE AGUA GRANO 240 DE CARBURO DE SILICIO, TRUPER','Unidad',22,7,2.5,3.75,1,10,NULL,'2024-03-09 08:37:41','2024-03-09 08:37:41'),(129,'11625 LIJA DE AGUA GRANO 280 DE CARBURO DE SILICIO, TRUPER','11625 LIJA DE AGUA GRANO 280 DE CARBURO DE SILICIO, TRUPER','Unidad',22,7,2.5,3.75,1,10,NULL,'2024-03-09 08:38:41','2024-03-09 08:38:41'),(130,'11626 LIJA DE AGUA GRANO 320 DE CARBURO DE SILICIO, TRUPER','11626 LIJA DE AGUA GRANO 320 DE CARBURO DE SILICIO, TRUPER','Unidad',22,7,2.5,3.75,1,10,NULL,'2024-03-09 08:39:33','2024-03-09 08:39:33'),(131,'11627 LIJA DE AGUA GRANO 360 DE CARBURO DE SILICIO, TRUPER','11627 LIJA DE AGUA GRANO 360 DE CARBURO DE SILICIO, TRUPER','Unidad',22,7,2.5,3.75,1,10,NULL,'2024-03-09 08:40:29','2024-03-09 08:40:29'),(132,'11628 LIJA DE AGUA GRANO 400 DE CARBURO DE SILICIO, TRUPER','11628 LIJA DE AGUA GRANO 400 DE CARBURO DE SILICIO, TRUPER','Unidad',22,7,2.5,3.75,1,10,NULL,'2024-03-09 08:43:54','2024-03-09 08:43:54'),(133,'11629 LIJA DE AGUA GRANO 500 DE CARBURO DE SILICIO, TRUPER','11629 LIJA DE AGUA GRANO 500 DE CARBURO DE SILICIO, TRUPER','Unidad',22,7,2.5,3.75,1,10,NULL,'2024-03-09 08:45:34','2024-03-09 08:45:34'),(134,'11630 LIJA DE AGUA GRANO 600 DE CARBURO DE SILICIO, TRUPER','11630 LIJA DE AGUA GRANO 600 DE CARBURO DE SILICIO, TRUPER','Unidad',22,7,2.5,3.75,1,10,NULL,'2024-03-09 08:46:39','2024-03-09 08:46:39'),(135,'11646 LIJA DE AGUA GRANO 60 DE CARBURO DE SILICIO, TRUPER','11646 LIJA DE AGUA GRANO 60 DE CARBURO DE SILICIO, TRUPER','Unidad',22,7,4.6,6.75,1,10,NULL,'2024-03-09 08:48:41','2024-03-09 08:48:41'),(136,'11740 CARRETILLA 4.5 FT3 NEUMATICA, BASTIDOR TUBULAR, TRUPER ','11740 CARRETILLA 4.5 FT3 NEUMATICA, BASTIDOR TUBULAR, TRUPER ','Unidad',14,7,390,557.25,1,5,NULL,'2024-03-09 08:51:31','2024-03-18 10:40:34'),(137,'11823 PLOMADA DE LATON (PLOMO) 24 OZ TIPO GUATEMALA, TRUPER','11823 PLOMADA DE LATON (PLOMO) 24 OZ TIPO GUATEMALA, TRUPER','Unidad',14,7,102.25,146.25,1,5,NULL,'2024-03-09 08:54:29','2024-03-18 10:36:15'),(138,'11824 PLOMADA DE LATON (PLOMO) 32 OZ TIPO GUATEMALA, TRUPER ','11824 PLOMADA DE LATON (PLOMO) 32 OZ TIPO GUATEMALA, TRUPER ','Unidad',14,7,131.5,188,1,5,NULL,'2024-03-09 09:25:59','2024-03-18 10:36:53'),(139,'11971 REVOLVEDOR DE PINTURA, 80 MM DE DIAMETRO, TRUPER ','11971 REVOLVEDOR DE PINTURA, 80 MM DE DIAMETRO, TRUPER ','Unidad',30,7,26.35,38,1,5,NULL,'2024-03-09 09:31:01','2024-03-28 10:43:21'),(140,'11973 CAVADOR MANGOS DE MADERA 48 PLG, TRUPER','11973 CAVADOR MANGOS DE MADERA 48 PLG, TRUPER','Unidad',14,7,129,184.5,1,5,NULL,'2024-03-09 09:35:58','2024-03-09 09:35:58'),(141,'11981 CAVADOR MANGOS DE ACERO 47 PLG, TRUPER EXPERT','11981 CAVADOR MANGOS DE ACERO 47 PLG, TRUPER EXPERT','Unidad',14,7,159.25,227.5,1,5,NULL,'2024-03-09 09:47:35','2024-03-09 09:47:35'),(142,'12129 PISTOLA P/PINTAR GRAVEDAD HVLP VASO PLASTICO, 1.7 MM, TRUPER','12129 PISTOLA P/PINTAR GRAVEDAD HVLP VASO PLASTICO, 1.7 MM, TRUPER','Unidad',30,7,195.6,279.5,1,5,NULL,'2024-03-09 10:02:47','2024-03-18 11:41:39'),(143,'12145 CINCEL DE CORTE FRIO DE 3/4 X 10 PLG, TRUPER','12145 CINCEL DE CORTE FRIO DE 3/4 X 10 PLG, TRUPER','Unidad',14,7,21.4,30.75,1,10,NULL,'2024-03-09 10:04:53','2024-03-18 10:48:43'),(144,'12147 ESTUCHE CON 5 PUNTAS DE CRUZ PH2 LARGO 2 PLG, TRUPER EXPERT','12147 ESTUCHE CON 5 PUNTAS DE CRUZ PH2 LARGO 2 PLG, TRUPER EXPERT','Estuche',16,7,14.5,20.75,1,5,NULL,'2024-03-09 10:10:31','2024-03-19 09:26:27'),(145,'12171 ESTUCHE CON 5 PUNTAS PLANAS DE 1/4 PLG LARGO 2 PLG, TRUPER EXPERT','12171 ESTUCHE CON 5 PUNTAS PLANAS DE 1/4 PLG LARGO 2 PLG, TRUPER EXPERT','Estuche',16,7,14.5,20.75,1,5,NULL,'2024-03-09 10:12:45','2024-03-19 09:27:00'),(146,'12397 LLANA CANTO REDONDO 14 PLG X 5 PLG CON MANGO DE MADERA, TRUPER ','12397 LLANA CANTO REDONDO 14 PLG X 5 PLG CON MANGO DE MADERA, TRUPER ','Unidad',14,7,38.65,55.5,1,5,NULL,'2024-03-09 10:16:05','2024-03-28 11:09:19'),(147,'12398 LLANA CANTO REDONDO 16 PLG X 5 PLG CON MANGO DE MADERA, TRUPER ','12398 LLANA CANTO REDONDO 16 PLG X 5 PLG CON MANGO DE MADERA, TRUPER ','Unidad',14,7,46.35,66.5,1,5,NULL,'2024-03-09 10:23:02','2024-03-28 11:32:36'),(148,'12399 LLANA CANTO REDONDO 24 PLG X 5 PLG CON MANGO DE MADERA, TRUPER ','12399 LLANA CANTO REDONDO 24 PLG X 5 PLG CON MANGO DE MADERA, TRUPER ','Unidad',14,7,77.25,110.5,1,5,NULL,'2024-03-09 10:24:34','2024-03-09 10:24:34'),(149,'12482 ESMERILADORA ANGULAR 9 PLG 2100 W, INDUSTRIAL, TRUPER ','12482 ESMERILADORA ANGULAR 9 PLG 2100 W, INDUSTRIAL, TRUPER ','Unidad',15,7,787.1,1124.5,1,5,NULL,'2024-03-09 10:27:27','2024-03-09 10:27:27'),(150,'12520 CINTA SELLA ROSCAS (TEFLON) 1/2 PLG X 7 M DE LARGO, USO GENERAL, TRUPER ','12520 CINTA SELLA ROSCAS (TEFLON) 1/2 PLG X 7 M DE LARGO, USO GENERAL, TRUPER ','Unidad',16,7,1.75,3,1,10,NULL,'2024-03-09 10:30:34','2024-03-26 16:01:02'),(151,'12521 CINTA SELLA ROSCAS (TEFLON) 3/4 PLG X 7 M DE LARGO, USO GENERAL, TRUPER ','12521 CINTA SELLA ROSCAS (TEFLON) 3/4 PLG X 7 M DE LARGO, USO GENERAL, TRUPER ','Unidad',16,7,2.25,3.75,1,10,NULL,'2024-03-09 10:34:48','2024-03-26 16:01:20'),(152,'12545 DISCO TIPO 41 DE 4-1/2 PLG X 1 MM CORTE FINO DE METAL, SABLE,TRUPER','12545 DISCO TIPO 41 DE 4-1/2 PLG X 1 MM CORTE FINO DE METAL, SABLE,TRUPER','Unidad',16,7,4.65,7,1,10,NULL,'2024-03-09 10:45:26','2024-03-28 09:13:39'),(153,'12546 DISCO TIPO 41 DE 7 PLG X 1.5 MM CORTE FINO DE METAL, SABLE, TRUPER','12546 DISCO TIPO 41 DE 7 PLG X 1.5 MM CORTE FINO DE METAL, SABLE, TRUPER','Unidad',16,7,9.65,14,1,10,NULL,'2024-03-09 10:47:45','2024-03-09 10:47:45'),(154,'12565 DISCO TIPO 27 DE 4-1/2 PLG X 6.4 MM PARA DESBASTE DE METAL, TRUPER','12565 DISCO TIPO 27 DE 4-1/2 PLG X 6.4 MM PARA DESBASTE DE METAL, TRUPER','Unidad',16,7,8.35,12.5,1,10,NULL,'2024-03-09 10:50:56','2024-03-28 09:47:14'),(155,'12567 DISCO TIPO 27 DE 7 PLG X 6.4 MM PARA DESBASTE DE METAL, TRUPER','12567 DISCO TIPO 27 DE 7 PLG X 6.4 MM PARA DESBASTE DE METAL, TRUPER','Unidad',16,7,17.85,26,1,10,NULL,'2024-03-09 10:52:35','2024-03-28 09:49:04'),(156,'12578 ROLLO DE 100 M DE CINTA DELIMITADORA PRECAUCION, TRUPER','12578 ROLLO DE 100 M DE CINTA DELIMITADORA PRECAUCION, TRUPER','Unidad',16,7,32,45.75,1,10,NULL,'2024-03-09 10:57:54','2024-03-18 10:35:32'),(157,'12589 CINTA MASKING TAPE DE 1/2 PLG X 50 M, TRUPER','12589 CINTA MASKING TAPE DE 1/2 PLG X 50 M, TRUPER','Unidad',16,7,5.4,7.75,1,10,NULL,'2024-03-09 10:59:59','2024-03-09 10:59:59'),(158,'12621 CINTA MASKING TAPE AZUL DE 3/4 PLG X 50 M PARA PINTOR, TRUPER','12621 CINTA MASKING TAPE AZUL DE 3/4 PLG X 50 M PARA PINTOR, TRUPER','Unidad',30,7,16.9,24.25,1,10,NULL,'2024-03-09 11:01:26','2024-03-18 11:42:41'),(159,'12622 CINTA MASKING TAPE AZUL DE 1 PLG X 50 M PARA PINTOR, TRUPER','12622 CINTA MASKING TAPE AZUL DE 1 PLG X 50 M PARA PINTOR, TRUPER','Unidad',30,7,19.3,27.75,1,10,NULL,'2024-03-09 11:04:21','2024-03-18 11:44:24'),(160,'12639 CINTA LARGA 30 M DE FIBRA DE VIDRIO, CARCASA PLASTICA, TRUPER','12639 CINTA LARGA 30 M DE FIBRA DE VIDRIO, CARCASA PLASTICA, TRUPER','Unidad',14,7,116.25,166.25,1,5,NULL,'2024-03-09 11:06:56','2024-03-09 11:06:56'),(161,'12640 CINTA LARGA 50 M DE FIBRA DE VIDRIO, CARCASA PLASTICA, TRUPER','12640 CINTA LARGA 50 M DE FIBRA DE VIDRIO, CARCASA PLASTICA, TRUPER','Unidad',14,7,154.8,221.25,1,5,NULL,'2024-03-09 11:08:48','2024-03-09 11:08:48'),(162,'12694 FLEXOMETRO INDUSTRIAL CONTRA IMPACTOS 5 M CINTA 19 MM, TRUPER','12694 FLEXOMETRO INDUSTRIAL CONTRA IMPACTOS 5 M CINTA 19 MM, TRUPER','Unidad',14,7,41.85,60,1,10,NULL,'2024-03-09 11:13:53','2024-03-09 11:13:53'),(163,'12873 ESMERILADORA ANGULAR 4-1/2 PLG DE 1250 W, INDUSTRIAL, TRUPER','12873 ESMERILADORA ANGULAR 4-1/2 PLG DE 1250 W, INDUSTRIAL, TRUPER','Unidad',15,7,557.5,796.5,1,5,NULL,'2024-03-09 11:16:36','2024-03-09 11:16:36'),(164,'12939 ESTUCHE CON  5 DADOS MAGNETICOS DE 1/4 PLG LARGO 2-1/2 PLG, EXPERT, TRUPER','12939 ESTUCHE CON  5 DADOS MAGNETICOS DE 1/4 PLG LARGO 2-1/2 PLG, EXPERT, TRUPER','Estuche',16,7,19.55,28,1,5,NULL,'2024-03-09 11:20:17','2024-03-19 09:27:33'),(165,'12940 ESTUCHE CON 5 DADOS MAGNETICOS DE 3/8 PLG LARGO 2-1/2 PLG, EXPERT, TRUPER','12940 ESTUCHE CON 5 DADOS MAGNETICOS DE 3/8 PLG LARGO 2-1/2 PLG, EXPERT, TRUPER','Estuche',16,7,21,30,1,5,NULL,'2024-03-09 11:22:06','2024-03-19 09:27:52'),(166,'12980 DISCO DE DIAMANTE DE 4-1/2 PLG X 2.2 MM RIN TURBO, TRUPER ','12980 DISCO DE DIAMANTE DE 4-1/2 PLG X 2.2 MM RIN TURBO, TRUPER ','Unidad',16,7,33,47.5,1,10,NULL,'2024-03-09 11:24:53','2024-03-28 10:06:41'),(167,'13005 CUCHARA PARA ALBAÃ‘IL 8 PLG FORJADA TIPO CENTROAMERICANA, TRUPER','13005 CUCHARA PARA ALBAÃ‘IL 8 PLG FORJADA TIPO CENTROAMERICANA, TRUPER','Unidad',14,7,56.9,82,1,5,NULL,'2024-03-09 11:26:47','2024-03-28 10:55:25'),(168,'13006 CUCHARA PARA ALBANIL 9 PLG FORJADA TIPO CENTROAMERICANA, TRUPER','13006 CUCHARA PARA ALBANIL 9 PLG FORJADA TIPO CENTROAMERICANA, TRUPER','Unidad',14,7,62.9,90,1,5,NULL,'2024-03-09 11:35:52','2024-04-02 10:48:10'),(169,'13008 TIROLERA GALVANIZADA, TRUPER ','13008 TIROLERA GALVANIZADA, TRUPER ','Unidad',14,7,318.85,455.5,1,5,NULL,'2024-03-09 11:38:48','2024-03-09 11:38:48'),(170,'13050 CUNA PARA CONCRETO DE 3/4 PLG, TRUPER','13050 CUNA PARA CONCRETO DE 3/4 PLG, TRUPER','Unidad',14,7,18,25.75,1,5,NULL,'2024-03-09 11:43:14','2024-04-02 10:47:51'),(171,'13053 CUNA PARA CONCRETO DE 7/8 PLG, TRUPER','13053 CUNA PARA CONCRETO DE 7/8 PLG, TRUPER','Unidad',14,7,27,38.75,1,5,NULL,'2024-03-09 11:44:51','2024-04-02 10:47:32'),(172,'13056 CUÃ‘A PARA CONCRETO DE 1 PLG, TRUPER','13056 CUÃ‘A PARA CONCRETO DE 1 PLG, TRUPER','Unidad',14,7,46,65.75,1,5,NULL,'2024-03-09 11:46:04','2024-03-09 11:46:04'),(173,'13121 CONO DE PRECAUCION DE 45 CM DE PVC CON REFLEJANTE, TRUPER','13121 CONO DE PRECAUCION DE 45 CM DE PVC CON REFLEJANTE, TRUPER','Unidad',16,7,85.25,122,1,5,NULL,'2024-03-09 11:48:53','2024-03-09 11:48:53'),(174,'13123 CONO DE PRECAUCION  DE 70 CM DE PVC CON REFLEJANTE, TRUPER','13123 CONO DE PRECAUCION  DE 70 CM DE PVC CON REFLEJANTE, TRUPER','Unidad',16,7,213.85,305.5,1,5,NULL,'2024-03-09 11:50:37','2024-03-09 11:50:37'),(175,'13468 ACEITE MULTIUSOS EN AEROSOL, 110 ML (4OZ), TRUPER','13468 ACEITE MULTIUSOS EN AEROSOL, 110 ML (4OZ), TRUPER','Unidad',16,7,10.15,14.5,1,5,NULL,'2024-03-09 12:02:01','2024-03-09 12:02:01'),(176,'13843 KIT DE RODILLO PARA PINTAR, 9 PLG (MANERAL, CHAROLA Y FELPA) TRUPER','13843 KIT DE RODILLO PARA PINTAR, 9 PLG (MANERAL, CHAROLA Y FELPA) TRUPER','Kit',30,7,27.05,38.75,1,10,NULL,'2024-03-09 12:03:45','2024-03-19 09:29:23'),(177,'13876 RODILLO PARA PINTAR 9 PLG X 5/8 PLG SUPERFICIES POCO RUGOSAS, TRUPER','13876 RODILLO PARA PINTAR 9 PLG X 5/8 PLG SUPERFICIES POCO RUGOSAS, TRUPER','Unidad',14,7,20.1,28.75,1,10,NULL,'2024-03-09 12:07:51','2024-03-11 10:14:02'),(178,'13877 RODILLO PARA PINTAR 9 PLG X 3/4 PLG SUPERFICIES RUGOSAS, TRUPER','13877 RODILLO PARA PINTAR 9 PLG X 3/4 PLG SUPERFICIES RUGOSAS, TRUPER','Unidad',30,7,20.6,29.5,1,10,NULL,'2024-03-11 10:12:24','2024-03-18 11:45:55'),(179,'13883 FELPA PARA RODILLO 9 PLG X 5/8 PLG SUPERFICIES POCO RUGOSAS, TRUPER','13883 FELPA PARA RODILLO 9 PLG X 5/8 PLG SUPERFICIES POCO RUGOSAS, TRUPER','Unidad',30,7,10.55,15.25,1,10,NULL,'2024-03-11 10:21:44','2024-03-18 11:46:26'),(180,'13884 FELPA PARA RODILLO 9 PLG X 3/4 PLG SUPERFICIES RUGOSAS, TRUPER','13884 FELPA PARA RODILLO 9 PLG X 3/4 PLG SUPERFICIES RUGOSAS, TRUPER','Unidad',30,7,11.15,16,1,10,NULL,'2024-03-11 10:31:16','2024-03-18 11:46:51'),(181,'14012 ESMERILADORA  ANGULAR 7 PLG 2200 W PROFESIONAL, TRUPER','14012 ESMERILADORA  ANGULAR 7 PLG 2200 W PROFESIONAL, TRUPER','Unidad',15,7,723.85,1034.25,1,5,NULL,'2024-03-11 10:34:20','2024-03-11 10:34:20'),(182,'14013 ESMERILADORA ANGULAR 4-1/2 PLG, 700 W, PROFESIONAL, TRUPER','14013 ESMERILADORA ANGULAR 4-1/2 PLG, 700 W, PROFESIONAL, TRUPER','Unidad',15,7,190,271.5,1,5,NULL,'2024-03-11 10:37:01','2024-03-11 10:37:01'),(183,'14034 DESARMADOR CABINET 3/16 PLG X 4 PLG MANGO COMFORT GRIP, TRUPER ','14034 DESARMADOR GABINET 3/16 PLG X 4 PLG MANGO COMFORT GRIP, TRUPER ','Unidad',14,7,10.9,15.75,1,10,NULL,'2024-03-11 10:39:57','2024-03-11 10:39:57'),(184,'14037 PISTOLA P/PINTAR BAJA PRESION, PULIDA, ENTRADA INF, TRUPER','14037 PISTOLA P/PINTAR BAJA PRESION, PULIDA, ENTRADA INF, TRUPER','Unidad',30,7,134.95,193,1,5,NULL,'2024-03-11 10:43:19','2024-03-18 11:47:23'),(185,'14076 DESARMADOR DE CRUZ 1/4 PLG X 4 PLG MANGO COMFORT GRIP, TRUPER ','14076 DESARMADOR DE CRUZ 1/4 PLG X 4 PLG MANGO COMFORT GRIP, TRUPER ','Unidad',14,7,12.5,18,1,10,NULL,'2024-03-11 10:45:23','2024-03-11 10:45:23'),(186,'14092 DESARMADOR PLANO 1/4 PLG X 4 PLG BARRA CUADRADA MANGO ACETATO,TRUPER','14092 DESARMADOR PLANO 1/4 PLG X 4 PLG BARRA CUADRADA MANGO ACETATO,TRUPER','Unidad',14,7,27.9,40,1,10,NULL,'2024-03-11 11:00:42','2024-03-11 11:00:42'),(188,'14182 CARDA COPA 3 PLG ALAMBRE ONDULADO FINO, EJE DE 5/8PLG-11, TRUPER','14182 CARDA COPA 3 PLG ALAMBRE ONDULADO FINO, EJE DE 5/8PLG-11, TRUPER','Unidad',16,7,26.45,38,1,5,NULL,'2024-03-11 11:06:45','2024-03-11 11:06:45'),(189,'14213 LENTES DE SEGURIDAD AJUSTABLE GRISES, TRUPER CLASSIC','14213 LENTES DE SEGURIDAD AJUSTABLE GRISES, TRUPER CLASSIC','Unidad',16,7,9.4,20,1,10,NULL,'2024-03-11 11:10:24','2024-03-11 11:21:10'),(190,'14216 FAJA LUMBAR CON TERCER CINTURON, TALLA M, TRUPER','14216 FAJA LUMBAR CON TERCER CINTURON, TALLA M, TRUPER','Unidad',16,7,89.45,128,1,5,NULL,'2024-03-11 11:12:02','2024-03-11 11:12:02'),(191,'14217 FAJA LUMBAR CON TERCER CINTURON, TALLA G, TRUPER','14217 FAJA LUMBAR CON TERCER CINTURON, TALLA G, TRUPER','Unidad',16,7,89.45,128,1,5,NULL,'2024-03-11 11:16:41','2024-03-11 11:16:41'),(192,'14284 LENTES DE SEGURIDAD AJUSTABLE TRANSPARENTES, TRUPER CLASSIC','14284 LENTES DE SEGURIDAD AJUSTABLE TRANSPARENTES, TRUPER CLASSIC','Unidad',16,7,9.4,20,1,10,NULL,'2024-03-11 11:17:55','2024-03-11 11:21:48'),(194,'14376 ESCUADRA 12 PLG PARA CARPINTERO CON MANGO 100% DE ALUMINIO TRUPER','14376 ESCUADRA 12 PLG PARA CARPINTERO CON MANGO 100% DE ALUMINIO TRUPER','Unidad',24,7,60.1,86,1,5,NULL,'2024-03-11 11:26:48','2024-03-18 11:48:30'),(195,'14384 ESCUADRA 16 PLG X 24 PLG DE ACERO PARA CANTERO, TRUPER','14384 ESCUADRA 16 PLG X 24 PLG DE ACERO PARA CANTERO, TRUPER','Unidad',14,7,85.25,122,1,5,NULL,'2024-03-11 11:30:09','2024-03-11 11:30:09'),(196,'14386 ESCUADRA 8 PLG X 12 PLG DE ACERO PARA CANTERO, TRUPER','14386 ESCUADRA 8 PLG X 12 PLG DE ACERO PARA CANTERO, TRUPER','Unidad',14,7,32.9,47,1,5,NULL,'2024-03-11 11:31:58','2024-03-11 11:31:58'),(197,'14449 ESPATULA FLEXIBLE 3 PLG CON MANGO DE MADERA, TRUPER','14449 ESPATULA FLEXIBLE 3 PLG CON MANGO DE MADERA, TRUPER','Unidad',14,7,14.3,20.5,1,5,NULL,'2024-03-11 11:35:59','2024-03-11 11:35:59'),(198,'14450 ESPATULA FLEXIBLE 4 PLG CON MANGO DE MADERA, TRUPER','14450 ESPATULA FLEXIBLE 4 PLG CON MANGO DE MADERA, TRUPER','Unidad',14,7,20.9,30,1,5,NULL,'2024-03-11 11:37:26','2024-03-11 11:37:26'),(199,'14577 FLEXOMETRO GRIPPER CONTRA IMPACTO 3 M CINTA DE 13 MM, TRUPER ','14577 FLEXOMETRO GRIPPER CONTRA IMPACTO 3 M CINTA DE 13 MM, TRUPER ','Unidad',14,7,14.55,21,1,5,NULL,'2024-03-11 11:38:48','2024-03-11 11:38:48'),(200,'14578 FLEXOMETRO  GRIPPER CONTRA IMPACTOS 5 M CINTA  19 MM, TRUPER','14578 FLEXOMETRO  GRIPPER CONTRA IMPACTOS 5 M CINTA  19 MM, TRUPER','Unidad',14,7,21.65,31,1,5,NULL,'2024-03-11 11:40:07','2024-03-11 11:40:07'),(201,'14582 FLEXOMETRO GRIPPER CONTRA IMPACTOS 10 M CINTA 32 MM, TRUPER','14582 FLEXOMETRO GRIPPER CONTRA IMPACTOS 10 M CINTA 32 MM, TRUPER','Unidad',14,7,74.7,106.75,1,5,NULL,'2024-03-11 11:41:43','2024-03-11 11:41:43'),(202,'14621 FORMON 1/2 PLG MANGO COMFORT GRIP, TRUPER','14621 FORMON 1/2 PLG MANGO COMFORT GRIP, TRUPER','Unidad',14,7,38,54.5,1,5,NULL,'2024-03-11 11:47:31','2024-03-11 11:47:31'),(203,'14627 FORMON 3/4 PLG MANGO COMFORT GRIP, TRUPER','14627 FORMON 3/4 PLG MANGO COMFORT GRIP, TRUPER','Unidad',14,7,38,54.5,1,5,NULL,'2024-03-11 12:07:48','2024-03-11 12:09:27'),(204,'14633 FORMON 1 PLG  MANGO COMFORT GRIP, TRUPER','14633 FORMON 1 PLG  MANGO COMFORT GRIP, TRUPER','Unidad',14,7,38,54.5,1,5,NULL,'2024-03-11 12:09:08','2024-03-11 12:09:08'),(205,'14658 ROTOMARTILLO 1/2 PLG 750 W, PROFESIONAL, TRUPER','14658 ROTOMARTILLO 1/2 PLG 750 W, PROFESIONAL, TRUPER','Unidad',15,7,240,343,1,5,NULL,'2024-03-11 12:12:47','2024-03-11 12:12:47'),(206,'14810 GATO HIDRAULICO DE BOTELLA DE 2 TON, TRUPER ','14810 GATO HIDRAULICO DE BOTELLA DE 2 TON, TRUPER ','Unidad',14,7,175.5,250.75,1,5,NULL,'2024-03-11 12:15:32','2024-03-11 12:15:32'),(207,'14812 GATO HIDRAULICO DE BOTELLA DE 4 TON, TRUPER','14812 GATO HIDRAULICO DE BOTELLA DE 4 TON, TRUPER','Unidad',14,7,200.45,286.5,1,5,NULL,'2024-03-11 12:16:55','2024-03-11 12:16:55'),(208,'14814 GATO HIDRAULICO DE BOTELLA DE 6 TON, TRUPER','14814 GATO HIDRAULICO DE BOTELLA DE 6 TON, TRUPER','Unidad',14,7,270.65,394,1,5,NULL,'2024-03-11 12:19:32','2024-03-11 12:19:32'),(209,'14944 GATO DE PATIN  2 TON DE 30 MOVIMIENTOS, TRUPER','14944 GATO DE PATIN  2 TON DE 30 MOVIMIENTOS, TRUPER','Unidad',14,7,322,460,1,5,NULL,'2024-03-11 12:28:05','2024-03-18 10:48:57'),(210,'14950 HACHA CAZADORA 1-1/4 LB, MANGO HICKORY 14 PLG, TRUPER','14950 HACHA CAZADORA 1-1/4 LB, MANGO HICKORY 14 PLG, TRUPER','Unidad',14,7,55,78.75,1,5,NULL,'2024-03-11 12:29:36','2024-03-11 12:29:36'),(211,'15078 BROCA HSS 1/8 PLG TRUBLACK PARA METAL, TRUPER','15078 BROCA HSS 1/8 PLG TRUBLACK PARA METAL, TRUPER','Unidad',16,7,2.9,4.25,1,10,NULL,'2024-03-11 12:33:24','2024-03-11 12:33:24'),(212,'15097 BROCA HSS 1/4 PLG TRUBLACK PARA METAL, TRUPER','15097 BROCA HSS 1/4 PLG TRUBLACK PARA METAL, TRUPER','Unidad',16,7,9.3,13.5,1,10,NULL,'2024-03-11 12:35:03','2024-03-11 12:35:03'),(213,'15337 BROCA HSS 3/8 PLG  TRUBLACK PARA METAL, TRUPER','15337 BROCA HSS 3/8 PLG  TRUBLACK PARA METAL, TRUPER','Unidad',16,7,23.1,33,1,10,NULL,'2024-03-11 12:36:26','2024-03-11 12:36:26'),(214,'15406 LLANA CANTO RECTO 11 PLG, 6  REMACHES, MANGO DE MADERA, TRUPER','15406 LLANA CANTO RECTO 11 PLG, 6  REMACHES, MANGO DE MADERA, TRUPER','Unidad',14,7,30.3,44,1,5,NULL,'2024-03-11 12:39:16','2024-03-28 12:28:06'),(215,'15412 LLANA CANTO RECTO 11 PLG, 6  REMACHES, MANGO DE PLASTICO, TRUPER','15412 LLANA CANTO RECTO 11 PLG, 6  REMACHES, MANGO DE PLASTICO, TRUPER','Unidad',14,7,21.7,31,1,5,NULL,'2024-03-11 12:41:29','2024-03-11 12:41:29'),(216,'15413 LLANA 11 PLG, DENTADO CUADRADO 1/4 PLG, 6 REMACHE, MANGO PLASTICO','15413 LLANA 11 PLG, DENTADO CUADRADO 1/4 PLG, 6 REMACHE, MANGO PLASTICO','Unidad',14,7,21.7,31,1,5,NULL,'2024-03-11 12:43:47','2024-03-11 12:43:47'),(217,'15679 ROTOMARTILLO 1/2 PLG 650 W, PROFESIONAL, TRUPER','15679 ROTOMARTILLO 1/2 PLG 650 W, PROFESIONAL, TRUPER','Unidad',15,7,214,305.75,1,5,NULL,'2024-03-11 13:00:47','2024-03-11 13:00:47'),(218,'15824 REVOLVEDOR DE PINTURA, 100 MM DIAMETRO, TRUPER','15824 REVOLVEDOR DE PINTURA, 100 MM DIAMETRO, TRUPER','Unidad',30,7,39.9,58,1,5,NULL,'2024-03-11 13:02:24','2024-03-28 10:44:21'),(219,'15877 BANDA DE LIJA 4 X 24 PLG P/MADERA GRANO 60, TRUPER','15877 BANDA DE LIJA 4 X 24 PLG P/MADERA GRANO 60, TRUPER','Unidad',22,7,13.65,19.5,1,5,NULL,'2024-03-11 13:06:45','2024-03-20 14:55:26'),(220,'15887 MACHETE ESTANDAR 22 PLG CACHA NARANJA REMACHADA, TRUPER','15887 MACHETE ESTANDAR 22 PLG CACHA NARANJA REMACHADA, TRUPER','Unidad',14,7,33.65,48.25,1,5,NULL,'2024-03-11 13:08:41','2024-03-11 13:08:41'),(221,'15891 MACHETE PUNTA RECTA 18 PLG, CACHA INYECTADA, TRUPER','15891 MACHETE PUNTA RECTA 18 PLG, CACHA INYECTADA, TRUPER','Unidad',14,7,39.55,56.5,1,5,NULL,'2024-03-11 13:09:57','2024-03-11 13:09:57'),(222,'15898 BANDA DE LIJA 4 X 24 PLG P/MADERA GRANO 80, TRUPER','15898 BANDA DE LIJA 4 X 24 PLG P/MADERA GRANO 80, TRUPER','Unidad',22,7,13.65,19.5,1,5,NULL,'2024-03-11 13:11:37','2024-03-20 14:55:55'),(224,'16028 ESCALERA DE EXTENSION, TIPO III, 24 PELDANOS, TRUPER','16028 ESCALERA DE EXTENSION, TIPO III, 24 PELDANOS, TRUPER','Unidad',14,7,1642.85,2347,1,5,NULL,'2024-03-11 13:14:32','2024-04-02 10:47:07'),(226,'16506 MARRO OCTAGONAL (ALMAGANA) 2 LB, MANGO DE MADERA 12 PLG, TRUPER','16506 MARRO OCTAGONAL (ALMAGANA) 2 LB, MANGO DE MADERA 12 PLG, TRUPER','Unidad',14,7,49.3,70.5,1,5,NULL,'2024-03-11 13:20:33','2024-03-21 09:43:59'),(227,'16507 MARRO OCTAGONAL (ALMAGANA) 3 LB, MANGO DE MADERA 12 PLG, TRUPER','16507 MARRO OCTAGONAL (ALMAGANA) 3 LB, MANGO DE MADERA 12 PLG, TRUPER','Unidad',14,7,58.05,83,1,5,NULL,'2024-03-11 13:22:29','2024-03-21 09:44:33'),(229,'16508 MARRO OCTAGONAL (ALMAGANA) 4 LB, MANGO DE MADERA 12 PLG, TRUPER','16508 MARRO OCTAGONAL (ALMAGANA) 4 LB, MANGO DE MADERA 12 PLG, TRUPER','Unidad',14,7,71.2,101.75,1,5,NULL,'2024-03-11 13:26:46','2024-03-21 09:45:23'),(230,'16511 MARRO OCTAGONAL (ALMAGANA) 8 LB, MANGO DE MADERA 36 PLG, TRUPER ','16511 MARRO OCTAGONAL (ALMAGANA) 8 LB, MANGO DE MADERA 36 PLG, TRUPER ','Unidad',14,7,159.65,228.25,1,5,NULL,'2024-03-11 13:28:15','2024-03-21 09:46:29'),(231,'16559 LLAVE PARA BROQUERO DE 3/8 PLG, TRUPER','16559 LLAVE PARA BROQUERO DE 3/8 PLG, TRUPER','Unidad',16,7,11.8,17,1,10,NULL,'2024-03-11 13:30:18','2024-03-11 13:30:18'),(232,'16560 LLAVE PARA BROQUERO DE 1/2 PLG, TRUPER','16560 LLAVE PARA BROQUERO DE 1/2 PLG, TRUPER','Unidad',16,7,12.05,17.25,1,10,NULL,'2024-03-11 13:31:44','2024-03-11 13:31:44'),(233,'16683 ESMERILADORA ANGULAR 4-1/2 PLG 800W, PROFESIONAL, TRUPER','16683 ESMERILADORA ANGULAR 4-1/2 PLG 800W, PROFESIONAL, TRUPER','Unidad',15,7,223.55,319.5,1,5,NULL,'2024-03-11 13:33:34','2024-03-11 13:33:34'),(236,'16701 MARTILLO TUBULAR PULIDO 16 OZ UNA CURVA, TRUPER','16701 MARTILLO TUBULAR PULIDO 16 OZ UNA CURVA, TRUPER','Unidad',14,7,39.5,56.5,1,5,NULL,'2024-03-11 13:58:27','2024-04-02 10:33:38'),(237,'16702 MARTILLO TUBULAR PULIDO 16 OZ UNA RECTA, TRUPER ','16702 MARTILLO TUBULAR PULIDO 16 OZ UNA RECTA, TRUPER ','Unidad',14,7,41.5,59.5,1,5,NULL,'2024-03-11 14:00:12','2024-04-02 10:32:43'),(239,'16711 ACEITE MULTIUSOS, 30 ML (1OZ), TRUPER','16711 ACEITE MULTIUSOS, 30 ML (1OZ), TRUPER','Unidad',16,7,9.45,13.5,1,5,NULL,'2024-03-11 14:02:29','2024-03-11 14:02:29'),(241,'16752 MARTILLO PULIDO 16 OZ UNA CURVA, MANGO MADERA, TRUPER','16752 MARTILLO PULIDO 16 OZ UNA CURVA, MANGO MADERA, TRUPER','Unidad',14,7,31.3,44.75,1,5,NULL,'2024-03-11 14:03:59','2024-04-02 10:32:17'),(242,'16754 MARTILLO PULIDO 16 OZ UNA RECTA, MANGO MADERA, TRUPER','16754 MARTILLO PULIDO 16 OZ UNA RECTA, MANGO MADERA, TRUPER','Unidad',14,7,32.1,46,1,5,NULL,'2024-03-11 14:05:09','2024-04-02 10:32:03'),(244,'16824 POLIPASTO DE CADENA DE 1 TON, TRUPER ','16824 POLIPASTO DE CADENA DE 1 TON, TRUPER ','Unidad',14,7,760,1085.75,1,5,NULL,'2024-03-11 14:06:44','2024-03-11 14:06:44'),(246,'17034 NIVEL DE 18 PLG CUERPO DE ALUMINO CON PROTECCION DE ABS','17034 NIVEL DE 18 PLG CUERPO DE ALUMINO CON PROTECCION DE ABS','Unidad',14,7,49,70,1,5,NULL,'2024-03-11 14:08:52','2024-03-18 10:39:22'),(247,'17036 NIVEL DE 24 PLG CUERPO DE ALUMINIO CON PROTECCION ABS','17036 NIVEL DE 24 PLG CUERPO DE ALUMINIO CON PROTECCION ABS','Unidad',14,7,57,82,1,5,NULL,'2024-03-11 14:09:59','2024-03-28 12:32:25'),(249,'17038 NIVEL DE 36 PLG CUERPO DE ALUMINO CON PROTECCION ABS ','17038 NIVEL DE 36 PLG CUERPO DE ALUMINO CON PROTECCION ABS ','Unidad',14,7,79,113,1,5,NULL,'2024-03-11 14:11:57','2024-03-18 10:39:48'),(250,'17380 TENAZA PARA CARPINTERO 8 PLG, TRUPER ','17380 TENAZA PARA CARPINTERO 8 PLG, TRUPER ','Unidad',24,7,44.7,64,1,10,NULL,'2024-03-11 14:13:15','2024-03-18 12:41:06'),(251,'17424 PINZA DE PRESION 10 PLG MORDAZA RECTA, TRUPER','17424 PINZA DE PRESION 10 PLG MORDAZA RECTA, TRUPER','Unidad',14,7,50.65,72.5,1,10,NULL,'2024-03-11 14:14:24','2024-03-18 10:40:04'),(252,'17519 TENAZA DE ARMADOR 8 PLG, TRUPER ','17519 TENAZA DE ARMADOR 8 PLG, TRUPER ','Unidad',15,7,30.4,43.5,1,10,NULL,'2024-03-11 14:18:44','2024-03-11 14:18:44'),(253,'17520 TENAZA DE ARMADOR 9 PLG, TRUPER ','17520 TENAZA DE ARMADOR 9 PLG, TRUPER ','Unidad',14,7,34.5,49.5,1,10,NULL,'2024-03-11 14:35:14','2024-03-11 14:35:14'),(254,'17521 TENAZA DE ARMADOR 10 PLG, TRUPER ','17521 TENAZA DE ARMADOR 10 PLG, TRUPER ','Unidad',14,7,37.5,53.75,1,10,NULL,'2024-03-11 14:36:37','2024-03-11 14:36:37'),(255,'17529 CARDA COPA 3 PLG ALAMBRE TRENZADO GRUESO, EJE 5/8PLG-11, TRUPER  ','17529 CARDA COPA 3 PLG ALAMBRE TRENZADO GRUESO, EJE 5/8PLG-11, TRUPER  ','Unidad',16,7,29.15,41.75,1,5,NULL,'2024-03-11 15:05:10','2024-03-11 15:05:10'),(256,'17531 CARDA COPA 4 PLG ALAMBRE TRENZADO GRUESO, EJE 5/8PLG-11, TRUPER ','17531 CARDA COPA 4 PLG ALAMBRE TRENZADO GRUESO, EJE 5/8PLG-11, TRUPER ','Unidad',16,7,55,78.75,1,5,NULL,'2024-03-11 15:06:38','2024-03-11 15:06:38'),(257,'17550 PISTOLA CALAFATEADORA TIPO ESQUELETO, TRUPER ','17550 PISTOLA CALAFATEADORA TIPO ESQUELETO, TRUPER ','Unidad',16,7,21.4,30.75,1,5,NULL,'2024-03-11 15:08:22','2024-03-11 15:08:22'),(258,'17558 PISTOLA CALAFATEADORA TIPO ESQUELETO, REFORZADA, TRUPER ','17558 PISTOLA CALAFATEADORA TIPO ESQUELETO, REFORZADA, TRUPER ','Unidad',16,7,48.5,69.5,1,5,NULL,'2024-03-11 15:09:58','2024-03-11 15:09:58'),(259,'17922 BOTAS JARDINERAS N. 26, TRUPER','17922 BOTAS JARDINERAS N. 26, TRUPER','Unidad',16,7,61.95,88.5,1,5,NULL,'2024-03-11 15:11:57','2024-04-02 09:43:59'),(260,'17923 BOTAS JARDINERAS N. 27, TRUPER ','17923 BOTAS JARDINERAS N. 27, TRUPER ','Unidad',16,7,61.95,88.5,1,5,NULL,'2024-03-11 15:13:11','2024-04-02 09:44:10'),(261,'17924 BOTAS JARDINERAS N. 28, TRUPER ','17924 BOTAS JARDINERAS N. 28, TRUPER ','Unidad',16,7,61.95,88.5,1,5,NULL,'2024-03-11 15:15:21','2024-04-02 09:44:25'),(262,'17942 CAJA CON 5 DISCOS DE LIJA 5 PLG GRANO 80 LIJADORA ROTO-ORBITAL ','17942 CAJA CON 5 DISCOS DE LIJA 5 PLG GRANO 80 LIJADORA ROTO-ORBITAL ','Unidad',22,7,11.3,16.25,1,5,NULL,'2024-03-11 15:16:54','2024-03-18 12:13:37'),(263,'17950 CAJA CON 5 DISCOS DE LIJA 5 PLG GRANO 120 LIJADORA ROTO-ORBITAL ','17950 CAJA CON 5 DISCOS DE LIJA 5 PLG GRANO 120 LIJADORA ROTO-ORBITAL ','Unidad',22,7,11.3,16.25,1,5,NULL,'2024-03-11 15:17:47','2024-03-18 12:14:16'),(264,'17977 ENGRAPADORA TIPO PISTOLA PARA 1/4 PLG Y 5/16 PLG, CON 200 GRAPAS ','17977 ENGRAPADORA TIPO PISTOLA PARA 1/4 PLG Y 5/16 PLG, CON 200 GRAPAS ','Unidad',16,7,68.7,98.25,1,5,NULL,'2024-03-11 15:19:14','2024-03-11 15:19:14'),(265,'18100 SEGUETA BIMETALICA DE 12 PLG, 18 DPP, TRUPER EXPERT','18100 SEGUETA BIMETALICA DE 12 PLG, 18 DPP, TRUPER EXPERT','Unidad',16,7,5.5,10,1,10,NULL,'2024-03-11 15:20:47','2024-03-27 16:41:11'),(266,'18156 ESMERILADORA ANGULAR 4-1/2 PLG 850 W, ERGO-PRO, TRUPER ','18156 ESMERILADORA ANGULAR 4-1/2 PLG 850 W, ERGO-PRO, TRUPER ','Unidad',15,7,275.8,394,1,5,NULL,'2024-03-11 15:23:43','2024-03-11 15:23:43'),(267,'18167 SERRUCHO 18 PLG DORADO, 9 DPP, TRUPER ','18167 SERRUCHO 18 PLG DORADO, 9 DPP, TRUPER ','Unidad',14,7,35,55,1,5,NULL,'2024-03-11 15:24:50','2024-03-28 10:41:40'),(268,'18168 SERRUCHO 20 PLG DORADO, 8 DPP, TRUPER ','18168 SERRUCHO 20 PLG DORADO, 8 DPP, TRUPER ','Unidad',14,7,43,65,1,5,NULL,'2024-03-11 15:25:58','2024-03-28 10:41:59'),(269,'18169 SERRUCHO 22 PLG DORADO, 7 DPP, TRUPER ','18169 SERRUCHO 22 PLG DORADO, 7 DPP, TRUPER ','Unidad',14,7,48,75,1,5,NULL,'2024-03-11 15:27:37','2024-03-28 10:38:49'),(270,'18300 DISCO SIERRA 7-1/4 PLG PARA MADERA, 24 DIENTES CENTRO 5/8 PLG','18300 DISCO SIERRA 7-1/4 PLG PARA MADERA, 24 DIENTES CENTRO 5/8 PLG','Unidad',16,7,39.4,56.5,1,5,NULL,'2024-03-11 15:30:56','2024-03-11 15:30:56'),(271,'18301 DISCO SIERRA 7-1/4 PLG PARA MADERA, 40 DIENTES CENTRO 5/8 PLG','18301 DISCO SIERRA 7-1/4 PLG PARA MADERA, 40 DIENTES CENTRO 5/8 PLG','Unidad',16,7,43,62,1,5,NULL,'2024-03-11 15:32:34','2024-03-28 09:57:47'),(272,'18460 TIJERA FORJADA PARA PODA 8 PLG PARA JARDINERIA, TRUPER ','18460 TIJERA FORJADA PARA PODA 8 PLG PARA JARDINERIA, TRUPER ','Unidad',14,7,40.8,58.5,1,5,NULL,'2024-03-11 15:35:20','2024-03-18 10:49:11'),(273,'18574 TIRALINEAS 30 M (100 FT) PLASTICO CON GIS Y NIVEL, TRUPER ','18574 TIRALINEAS 30 M (100 FT) PLASTICO CON GIS Y NIVEL, TRUPER ','Unidad',16,7,37.7,54,1,5,NULL,'2024-03-11 15:37:36','2024-03-18 10:41:20'),(274,'18646 ZAPAPICO (PIOCHA) 5 LB CON MANGO DE 36 PLG, TRUPER ','18646 ZAPAPICO (PIOCHA) 5 LB CON MANGO DE 36 PLG, TRUPER ','Unidad',14,7,98.7,141,1,5,NULL,'2024-03-11 15:41:40','2024-03-11 15:41:40'),(275,'18647 TALACHO-PICO 5 LB CON MANGO DE 36 PLG, TRUPER ','18647 TALACHO-PICO 5 LB CON MANGO DE 36 PLG, TRUPER ','Unidad',14,7,105.9,151.5,1,5,NULL,'2024-03-11 15:51:43','2024-03-11 15:51:43'),(276,'19283 SUJETADOR CON MATRACA CARGA MAXIMA 2250 KG, TRUPER ','19283 SUJETADOR CON MATRACA CARGA MAXIMA 2250 KG, TRUPER ','Unidad',16,7,142.8,204,1,5,NULL,'2024-03-11 15:52:53','2024-03-18 10:41:45'),(277,'19286 SUJETADOR CON MATRACA CARGA MAXIMA 3000 KG, TRUPER ','19286 SUJETADOR CON MATRACA CARGA MAXIMA 3000 KG, TRUPER ','Unidad',16,7,203.85,291.25,1,5,NULL,'2024-03-11 15:55:23','2024-03-18 10:42:14'),(278,'19679 LIMA TRIANGULO PESADO 6 PLG, 32 DPP CON MANGO, TRUPER ','19679 LIMA TRIANGULO PESADO 6 PLG, 32 DPP CON MANGO, TRUPER ','Unidad',16,7,7.85,11.25,1,10,NULL,'2024-03-11 15:57:11','2024-03-18 10:42:27'),(279,'19785 ESCOBA PLASTICA PARA JARDIN (RASTRILLO) FLEXIBLE, 22 DIENTES, MANGO 48 PLG ','19785 ESCOBA PLASTICA PARA JARDIN (RASTRILLO) FLEXIBLE, 22 DIENTES, MANGO 48 PLG ','Unidad',14,7,35.35,55,1,5,NULL,'2024-03-11 15:58:57','2024-03-20 14:16:24'),(280,'19791 MANGUERA 1/2 PLG SUPER REFORZADA 4 CAPAS 15 M CONEXIONES METAL ','19791 MANGUERA 1/2 PLG SUPER REFORZADA 4 CAPAS 15 M CONEXIONES METAL ','Unidad',16,7,118.45,169.25,1,5,NULL,'2024-03-11 16:00:32','2024-03-11 16:00:32'),(281,'19792 MANGUERA 1/2 PLG SUPER REFORZADA 4 CAPAS 20 M CONEXIONES METAL ','19792 MANGUERA 1/2 PLG SUPER REFORZADA 4 CAPAS 20 M CONEXIONES METAL ','Unidad',16,7,126.4,180.75,1,5,NULL,'2024-03-11 16:03:17','2024-03-11 16:03:17'),(282,'19793 MANGUERA 1/2 PLG SUPER REFORZADA 4 CAPAS 25 M CONEXIONES METAL ','19793 MANGUERA 1/2 PLG SUPER REFORZADA 4 CAPAS 25 M CONEXIONES METAL ','Unidad',16,7,149.35,213.5,1,5,NULL,'2024-03-11 16:06:10','2024-03-11 16:06:10'),(283,'19862 METRO DE MANGUERA 3/8 PLG DE NIVEL, TRUPER ','19862 METRO DE MANGUERA 3/8 PLG DE NIVEL, TRUPER ','Metro',16,7,3.05,5,1,25,NULL,'2024-03-11 16:07:52','2024-03-28 13:15:52'),(284,'19963 BARRETA PARA TIERRA DURA DE 1 PLG X 175 CM, ESCOPLO 67 MM, TRUPER ','19963 BARRETA PARA TIERRA DURA DE 1 PLG X 175 CM, ESCOPLO 67 MM, TRUPER ','Unidad',14,7,183,261.5,1,5,NULL,'2024-03-11 16:16:10','2024-03-11 16:16:10'),(285,'19993 HACHA MEDIA LABOR OJO REDONDO 4 LB SIN MANGO, TRUPER ','19993 HACHA MEDIA LABOR OJO REDONDO 4 LB SIN MANGO, TRUPER ','Unidad',14,7,76.55,109.5,1,5,NULL,'2024-03-11 16:20:22','2024-03-11 16:20:22'),(286,'19994 HACHA MEDIA LABOR OJO REDONDO 4-1/2 LB SIN MANGO, TRUPER ','19994 HACHA MEDIA LABOR OJO REDONDO 4-1/2 LB SIN MANGO, TRUPER ','Unidad',14,7,80,114.5,1,5,NULL,'2024-03-11 16:23:35','2024-03-11 16:23:35'),(287,'19995 HACHA MEDIA LABOR OJO REDONDO 5 LB SIN MANGO, TRUPER ','19995 HACHA MEDIA LABOR OJO REDONDO 5 LB SIN MANGO, TRUPER ','Unidad',14,7,94,135.75,1,5,NULL,'2024-03-11 16:25:08','2024-03-11 16:25:08'),(288,'20002 MINI ARCO 12 PLG DE PLASTICO PARA SEGUETA, PRETUL ','20002 MINI ARCO 12 PLG DE PLASTICO PARA SEGUETA, PRETUL ','Unidad',14,7,16.55,24,1,5,NULL,'2024-03-11 16:35:40','2024-03-28 10:13:00'),(289,'20024 ROLLO DE HILO PARA DESBROZADORA, 2.4 MM X 12 M, PRETUL ','20024 ROLLO DE HILO PARA DESBROZADORA, 2.4 MM X 12 M, PRETUL ','Unidad',16,7,12.55,18,1,5,NULL,'2024-03-11 16:36:47','2024-03-11 16:36:47'),(290,'20025 ROLLO DE HILO PARA DESBROZADORA, 2.7 MM X 12 M, PRETUL ','20025 ROLLO DE HILO PARA DESBROZADORA, 2.7 MM X 12 M, PRETUL ','Unidad',16,7,16,23,1,5,NULL,'2024-03-11 16:38:31','2024-03-11 16:38:31'),(291,'20030 GUANTES DE NYLON RECUBIERTOS DE POLIURETANO, M PRETUL ','20030 GUANTES DE NYLON RECUBIERTOS DE POLIURETANO, M PRETUL ','Unidad',16,7,9.65,14,1,10,NULL,'2024-03-11 16:39:50','2024-03-11 16:39:50'),(292,'20031 GUANTES DE NYLON RECUBIERTOS DE POLIURETANO, G, RETUL','20031 GUANTES DE NYLON RECUBIERTOS DE POLIURETANO, G, RETUL','Unidad',16,7,9.65,14,1,10,NULL,'2024-03-11 16:40:30','2024-03-11 16:40:30'),(293,'20180 FLOTA DE ESPONJA, 9-1/2 PLG, ESPESOR 3/4 PLG, ASPERO, PRETUL','20180 FLOTA DE ESPONJA, 9-1/2 PLG, ESPESOR 3/4 PLG, ASPERO, PRETUL','Unidad',14,7,30.3,43.5,1,5,NULL,'2024-03-11 16:41:46','2024-03-18 10:43:13'),(294,'20401 LENTES DE SEGURIDAD TRANSPARENTES, PRETUL LITE ','20401 LENTES DE SEGURIDAD TRANSPARENTES, PRETUL LITE ','Unidad',16,7,7.75,18,1,10,NULL,'2024-03-11 16:43:10','2024-03-11 16:43:10'),(295,'20402 LENTES DE SEGURIDAD GRISES, PRETUL LITE','20402 LENTES DE SEGURIDAD GRISES, PRETUL LITE','Unidad',16,7,7.75,18,1,10,NULL,'2024-03-11 16:44:15','2024-03-11 16:44:15'),(296,'20525 CINTA DE EMPAQUE (SELLADOR) 48 MM X 40 M TRANSPARENTE, PRETUL ','20525 CINTA DE EMPAQUE (SELLADOR) 48 MM X 40 M TRANSPARENTE, PRETUL ','Unidad',16,7,5.35,7.75,1,10,NULL,'2024-03-11 16:45:12','2024-03-22 14:42:13'),(297,'20528 CINTA PARA DUCTO 10 M X 48 MM, ESPESOR 0.16 MM, PRETUL','20528 CINTA PARA DUCTO 10 M X 48 MM, ESPESOR 0.16 MM, PRETUL','Unidad',16,7,9.15,13.25,1,10,NULL,'2024-03-11 16:46:42','2024-03-11 16:46:42'),(298,'20543 CUCHARA PARA ALBANIL 8 PLG TIPO CENTROAMERICANA, PRETUL ','20543 CUCHARA PARA ALBANIL 8 PLG TIPO CENTROAMERICANA, PRETUL ','Unidad',14,7,21.8,35,1,5,NULL,'2024-03-11 16:48:09','2024-04-02 10:31:20'),(299,'20544 CUCHARA PARA ALBANIL 9 PLG TIPO CENTROAMERICANA, PRETUL','20544 CUCHARA PARA ALBANIL 9 PLG TIPO CENTROAMERICANA, PRETUL','Unidad',14,7,22.35,40,1,5,NULL,'2024-03-11 16:49:16','2024-04-02 10:31:07'),(300,'20653 CEPILLO DE ALAMBRE 64 PINCELES DE ACERO AL CARBONO, PRETUL ','20653 CEPILLO DE ALAMBRE 64 PINCELES DE ACERO AL CARBONO, PRETUL ','Unidad',16,7,12,17.25,1,5,NULL,'2024-03-11 16:50:17','2024-03-11 16:50:17'),(301,'20948 CORTAPERNOS (CAIMAN) 30 PLG, PRETUL ','20948 CORTAPERNOS (CAIMAN) 30 PLG, PRETUL ','Unidad',14,7,188.8,269.75,1,5,NULL,'2024-03-11 16:52:13','2024-03-11 16:52:13'),(302,'20949 CORTAPERNOS (CAIMAN) 36 PLG, PRETUL ','20949 CORTAPERNOS (CAIMAN) 36 PLG, PRETUL ','Unidad',14,7,223.6,319.5,1,5,NULL,'2024-03-11 16:53:37','2024-03-21 14:37:36'),(303,'21000 DISCO DE DIAMANTE DE 7 PLG X 2.1 MM RIN CONTINUO, PRETUL ','21000 DISCO DE DIAMANTE DE 7 PLG X 2.1 MM RIN CONTINUO, PRETUL ','Unidad',16,7,46.5,66.5,1,5,NULL,'2024-03-11 16:55:30','2024-03-11 16:55:30'),(304,'21002 CARDA CIRCULAR 2 PLG ALAMBRE GRUESO PARA TALADRO, PRETUL','21002 CARDA CIRCULAR 2 PLG ALAMBRE GRUESO PARA TALADRO, PRETUL','Unidad',16,7,9,13,1,5,NULL,'2024-03-11 16:56:56','2024-03-11 16:56:56'),(305,'21003 CARDA CIRCULAR 3 PLG ALAMBRE GRUESO PARA TALADRO, PRETUL ','21003 CARDA CIRCULAR 3 PLG ALAMBRE GRUESO PARA TALADRO, PRETUL ','Unidad',16,7,13.8,19.75,1,5,NULL,'2024-03-11 17:17:42','2024-03-11 17:17:42'),(306,'21004 CARDA DE COPA 1-3/4 PLG ALAMBRE GRUESO PARA TALADRO, PRETUL','21004 CARDA DE COPA 1-3/4 PLG ALAMBRE GRUESO PARA TALADRO, PRETUL','Unidad',16,7,13.8,19.75,1,5,NULL,'2024-03-11 17:19:17','2024-03-11 17:19:17'),(307,'21005 CARDA DE COPA 2-3/4 PLG ALAMBRE GRUESO PARA TALADRO, PRETUL','21005 CARDA DE COPA 2-3/4 PLG ALAMBRE GRUESO PARA TALADRO, PRETUL','Unidad',16,7,17.9,25.75,1,5,NULL,'2024-03-11 17:20:43','2024-03-11 17:20:43'),(308,'21009 DISCO DE DIAMANTE DE 4-1/2 PLG X 1.8 MM RIN CONTINUO, PRETUL','21009 DISCO DE DIAMANTE DE 4-1/2 PLG X 1.8 MM RIN CONTINUO, PRETUL','Unidad',16,7,17.95,26,1,5,NULL,'2024-03-11 17:21:48','2024-03-28 10:05:03'),(309,'21052 CUCHARA PARA ALBANIL 8 PLG TIPO FILADELFIA, PRETUL ','21052 CUCHARA PARA ALBANIL 8 PLG TIPO FILADELFIA, PRETUL ','Unidad',14,7,19.05,30,1,5,NULL,'2024-03-11 17:23:02','2024-04-02 10:30:46'),(310,'21053 CUCHARA PARA ALBANIL 9 PLG TIPO FILADELFIA, PRETUL','21053 CUCHARA PARA ALBANIL 9 PLG TIPO FILADELFIA, PRETUL','Unidad',14,7,22,35,1,5,NULL,'2024-03-11 17:24:03','2024-04-02 10:30:37'),(311,'21515 ESPATULA FLEXIBLE 2 PLG CON MANGO DE PLASTICO, PRETUL','21515 ESPATULA FLEXIBLE 2 PLG CON MANGO DE PLASTICO, PRETUL','Unidad',14,7,10,14.5,1,5,NULL,'2024-03-11 17:24:58','2024-03-18 10:43:30'),(312,'21516 ESPATULA FLEXIBLE 3 PLG CON MANGO DE PLASTICO, PRETUL','21516 ESPATULA FLEXIBLE 3 PLG CON MANGO DE PLASTICO, PRETUL','Unidad',14,7,10.6,15.25,1,5,NULL,'2024-03-11 17:26:04','2024-03-18 10:43:46'),(313,'21517 ESPATULA FLEXIBLE 4 PLG CON MANGO DE PLASTICO, PRETUL','21517 ESPATULA FLEXIBLE 4 PLG CON MANGO DE PLASTICO, PRETUL','Unidad',14,7,11.2,16,1,5,NULL,'2024-03-11 17:27:03','2024-03-18 10:44:01'),(314,'21526 BROCHA USO GENERAL DE 2 PLG CON MANGO DE PLASTICO, PRETUL','21526 BROCHA USO GENERAL DE 2 PLG CON MANGO DE PLASTICO, PRETUL','Unidad',30,7,3.95,5.75,1,5,NULL,'2024-03-11 17:29:41','2024-03-18 12:17:45'),(315,'21528 BROCHA USO GENERAL DE 3 PLG CON MANGO DE PLASTICO, PRETUL ','21528 BROCHA USO GENERAL DE 3 PLG CON MANGO DE PLASTICO, PRETUL ','Unidad',30,7,6.15,9,1,5,NULL,'2024-03-11 17:30:43','2024-03-18 12:18:37'),(316,'21529 BROCHA 4 PLG MANGO PLASTICO, PRETUL ','','Unidad',30,7,7.5,10.75,1,5,NULL,'2024-03-11 17:35:20','2024-03-26 10:42:28'),(317,'21816 LLAVE AJUSTABLE (PERICO) 10 PLG CROMADA, PRETUL','21816 LLAVE AJUSTABLE (PERICO) 10 PLG CROMADA, PRETUL','Unidad',14,7,50.9,72.75,1,5,NULL,'2024-03-11 17:36:52','2024-03-11 17:36:52'),(318,'21850 JUEGO DE 8 LLAVES ALLEN STD PUNTA HEX TIPO LLAVERO, PRETUL','21850 JUEGO DE 8 LLAVES ALLEN STD PUNTA HEX TIPO LLAVERO, PRETUL','Unidad',16,7,9.05,13,1,5,NULL,'2024-03-11 17:38:42','2024-03-11 17:38:42'),(319,'21851 JUEGO DE 8 LLAVES ALLEN MM PUNTA HEX TIPO LLAVERO, PRETUL','21851 JUEGO DE 8 LLAVES ALLEN MM PUNTA HEX TIPO LLAVERO, PRETUL','Unidad',16,7,9.05,13,1,5,NULL,'2024-03-11 17:40:16','2024-03-11 17:40:16'),(320,'22011 LLAVE STILSON 10 PLG CUERPO DE HIERRO MALEABLE, PRETUL','22011 LLAVE STILSON 10 PLG CUERPO DE HIERRO MALEABLE, PRETUL','Unidad',14,7,36.05,51.5,1,5,NULL,'2024-03-11 17:41:40','2024-03-11 17:41:40'),(321,'22012 LLAVE STILSON 12 PLG CUERPO DE HIERRO MALEABLE, PRETUL','22012 LLAVE STILSON 12 PLG CUERPO DE HIERRO MALEABLE, PRETUL','Unidad',14,7,48.5,69.5,1,5,NULL,'2024-03-11 17:43:46','2024-03-11 17:43:46'),(322,'22345 DISCO TIPO 41 DE 4-1/2 PLG X 1.6 MM CORTE FINO DE METAL, PRETUL','22345 DISCO TIPO 41 DE 4-1/2 PLG X 1.6 MM CORTE FINO DE METAL, PRETUL','Unidad',16,7,3.5,6,1,10,NULL,'2024-03-11 17:46:16','2024-03-28 09:11:49'),(323,'22347 DISCO TIPO 41 DE 9 PLG X 2 MM CORTE FINO DE METAL, PRETUL ','22347 DISCO TIPO 41 DE 9 PLG X 2 MM CORTE FINO DE METAL, PRETUL ','Unidad',16,7,10.3,14.75,1,10,NULL,'2024-03-11 17:49:00','2024-03-12 10:08:04'),(324,'22348 DISCO TIPO 41 DE 4-1/2 PLG X 1 MM CORTE FINO DE METAL, PRETUL ','22348 DISCO TIPO 41 DE 4-1/2 PLG X 1 MM CORTE FINO DE METAL, PRETUL ','Unidad',16,7,3.1,5,1,10,NULL,'2024-03-12 10:11:09','2024-03-28 09:08:51'),(325,'22349 DISCO TIPO 41 DE 7 PLG X 1.5 MM CORTE FINO DE METAL, PRETUL ','22349 DISCO TIPO 41 DE 7 PLG X 1.5 MM CORTE FINO DE METAL, PRETUL ','Unidad',16,7,8.05,11.5,1,10,NULL,'2024-03-12 10:13:11','2024-03-12 10:13:11'),(326,'22396 CUTTER 18 MM PLASTCO CON ALMA METALICA, PRETUL ','22396 CUTTER 18 MM PLASTCO CON ALMA METALICA, PRETUL ','Unidad',16,7,6.35,9.25,1,10,NULL,'2024-03-12 10:14:20','2024-03-18 10:45:00'),(327,'22674 PINZA PARA ELECTRICISTA (ALICATE) 8 PLG MANGO COMFORT GRIP, PRETUL','22674 PINZA PARA ELECTRICISTA (ALICATE) 8 PLG MANGO COMFORT GRIP, PRETUL','Unidad',14,7,24.55,35.25,1,10,NULL,'2024-03-12 10:16:59','2024-03-12 10:16:59'),(328,'22801 PISTOLA CALAFATEADORA DE CREMALLERA, PRETUL ','22801 PISTOLA CALAFATEADORA DE CREMALLERA, PRETUL ','Unidad',16,7,19.05,27.25,1,5,NULL,'2024-03-12 10:19:27','2024-03-12 10:19:27'),(329,'23060 TIJERA PARA PODA 48 CM MANGOS DE MADERA, PRETUL','23060 TIJERA PARA PODA 48 CM MANGOS DE MADERA, PRETUL','Unidad',14,7,56.35,81,1,5,NULL,'2024-03-12 10:21:57','2024-03-28 10:34:21'),(330,'23070 TIROLERA GALVANIZADA, PRETUL','23070 TIROLERA GALVANIZADA, PRETUL','Unidad',14,7,234.3,334.75,1,5,NULL,'2024-03-12 10:26:29','2024-03-12 10:26:29'),(331,'23185 TIJERA 8 PLG DE ACERO INOXIDABLE PARA CASA Y OFICINA, PRETUL','23185 TIJERA 8 PLG DE ACERO INOXIDABLE PARA CASA Y OFICINA, PRETUL','Unidad',16,7,12.6,18,1,5,NULL,'2024-03-12 10:27:57','2024-03-12 10:27:57'),(332,'23186 TIJERA 7 PLG DE ACERO INOXIDABLE PARA CASA Y OFICINA, PRETUL','23186 TIJERA 7 PLG DE ACERO INOXIDABLE PARA CASA Y OFICINA, PRETUL','Unidad',16,7,9.25,13.25,1,5,NULL,'2024-03-12 10:29:52','2024-03-12 10:29:52'),(333,'24232 PINZA PORTA ELECTRODO DE 300 A, PRETUL ','24232 PINZA PORTA ELECTRODO DE 300 A, PRETUL ','Unidad',16,7,47,67.25,1,5,NULL,'2024-03-12 10:31:53','2024-03-12 10:31:53'),(334,'24233 PINZA PORTA ELECTRODO DE 500 A, PRETUL','24233 PINZA PORTA ELECTRODO DE 500 A, PRETUL','Unidad',16,7,66.5,95,1,5,NULL,'2024-03-12 10:33:40','2024-03-12 10:33:40'),(335,'24234 PINZA PARA TIERRA DE 300 A, PRETUL ','24234 PINZA PARA TIERRA DE 300 A, PRETUL ','Unidad',16,7,32.3,46.25,1,5,NULL,'2024-03-12 10:34:58','2024-03-12 10:34:58'),(336,'24235 PINZA PARA TIERRA DE 500 A PRETUL ','24235 PINZA PARA TIERRA DE 500 A PRETUL ','Unidad',16,7,47.8,68.5,1,5,NULL,'2024-03-12 10:36:57','2024-03-12 10:36:57'),(337,'25054 RASTRILLO JARDINERO, 14 DIENTES, PRETUL','25054 RASTRILLO JARDINERO, 14 DIENTES, PRETUL','Unidad',14,7,39,55.75,1,5,NULL,'2024-03-12 10:38:32','2024-03-12 10:38:32'),(338,'26050 TIJERA PARA OJALATERO 10 PLG, PRETUL','26050 TIJERA PARA OJALATERO 10 PLG, PRETUL','Unidad',14,7,55,78.75,1,5,NULL,'2024-03-12 10:39:53','2024-03-12 10:39:53'),(339,'27017 DISCO DE DIAMANTE DE 4-1/2 PLG X 1.2 MM RIN TURBO, PRETUL','27017 DISCO DE DIAMANTE DE 4-1/2 PLG X 1.2 MM RIN TURBO, PRETUL','Unidad',16,7,19.55,28,1,10,NULL,'2024-03-12 10:41:04','2024-03-12 10:41:04'),(340,'27018 DISCO DE DIAMANTE DE 7 PLG X 1.6 MM RIN TURBO, PRETUL','27018 DISCO DE DIAMANTE DE 7 PLG X 1.6 MM RIN TURBO, PRETUL','Unidad',16,7,46.5,67,1,10,NULL,'2024-03-12 10:42:06','2024-03-28 10:10:57'),(341,'27022 CONECTOR RAPIDO, TIPO M, CUERDA 1/4 NPT, HEMBRA, PRETUL ','27022 CONECTOR RAPIDO, TIPO M, CUERDA 1/4 NPT, HEMBRA, PRETUL ','Unidad',16,7,6.7,9.75,1,10,NULL,'2024-03-12 10:44:08','2024-03-18 10:45:14'),(342,'27023 CONECTOR RAPIDO, TIPO M, CUERDA 1/4 NPT, MACHO, PRETUL ','27023 CONECTOR RAPIDO, TIPO M, CUERDA 1/4 NPT, MACHO, PRETUL ','Unidad',16,7,6.7,9.75,1,10,NULL,'2024-03-12 10:45:26','2024-03-18 10:45:38'),(343,'27028 COPLE ACERO, CUERDA 1/4 NPT, HEMBRA, PRETUL','27028 COPLE ACERO, CUERDA 1/4 NPT, HEMBRA, PRETUL','Unidad',16,7,23.6,33.75,1,10,NULL,'2024-03-12 10:46:42','2024-03-12 10:46:42'),(344,'27029 COPLE ACERO, CUERDA 1/4 NPT, MACHO, PRETUL','27029 COPLE ACERO, CUERDA 1/4 NPT, MACHO, PRETUL','Unidad',16,7,23.6,33.75,1,10,NULL,'2024-03-12 10:47:35','2024-03-12 10:47:35'),(345,'27032 DISCO DE DIAMANTE DE 4-1/2 PLG X 1.2 MM RIN SEGMENTADO, PRETUL','27032 DISCO DE DIAMANTE DE 4-1/2 PLG X 1.2 MM RIN SEGMENTADO, PRETUL','Unidad',16,7,19.4,28,1,10,NULL,'2024-03-12 10:48:31','2024-03-28 10:08:19'),(346,'27033 DISCO DE DIAMANTE DE 7 PLG X 1.6 MM RIN SEGMENTADO, PRETUL','27033 DISCO DE DIAMANTE DE 7 PLG X 1.6 MM RIN SEGMENTADO, PRETUL','Unidad',16,7,46.5,66.5,1,10,NULL,'2024-03-12 10:49:26','2024-03-12 10:49:26'),(347,'27065 CARRETE CON 100 M DE HILO PARA PESCA AZUL CALIBRE 0.80 MM ','27065 CARRETE CON 100 M DE HILO PARA PESCA AZUL CALIBRE 0.80 MM ','Unidad',16,7,17.4,25,1,10,NULL,'2024-03-12 10:50:59','2024-03-12 10:50:59'),(348,'27066 CARRETE CON 100 M DE HILO PARA PESCA AZUL CALIBRE 0.90 MM ','27066 CARRETE CON 100 M DE HILO PARA PESCA AZUL CALIBRE 0.90 MM ','Unidad',16,7,18.65,26.75,1,10,NULL,'2024-03-12 10:52:00','2024-03-12 10:52:00'),(349,'27067 CARRETE CON 100 M DE HILO PARA PESCA AZUL CALBRE 1.00 MM ','27067 CARRETE CON 100 M DE HILO PARA PESCA AZUL CALBRE 1.00 MM ','Unidad',16,7,19.9,28.5,1,10,NULL,'2024-03-12 10:54:04','2024-03-12 10:54:04'),(350,'27201 PRENSA 3 PLG DE HIERRO NODULAR PARA CARPINTERIA, PRETUL','27201 PRENSA 3 PLG DE HIERRO NODULAR PARA CARPINTERIA, PRETUL','Unidad',24,7,29.1,42,1,5,NULL,'2024-03-12 10:59:13','2024-03-28 10:47:53'),(351,'27202 PRENSA 4 PLG DE HIERRO NODULAR PARA CARPINTERIA, PRETUL ','27202 PRENSA 4 PLG DE HIERRO NODULAR PARA CARPINTERIA, PRETUL ','Unidad',24,7,31.25,45,1,5,NULL,'2024-03-12 11:03:24','2024-03-28 10:49:11'),(352,'27203 PRENSA 5 PLG DE HIERRO NODULAR PARA CARPINTERIA, PRETUL ','27203 PRENSA 5 PLG DE HIERRO NODULAR PARA CARPINTERIA, PRETUL ','Unidad',24,7,50.65,72.5,1,5,NULL,'2024-03-12 11:04:58','2024-03-18 12:26:59'),(353,'29994 ESMERIL DE BANCO DE 5 PLG DE 1/6 HP, PRETUL','29994 ESMERIL DE BANCO DE 5 PLG DE 1/6 HP, PRETUL','Unidad',15,7,341.75,488.25,1,5,NULL,'2024-03-12 11:07:09','2024-03-12 11:07:09'),(354,'41250 CAJA CON 100 CHINCHES EN 10 COLORES SURTIDOS, FIERO ','41250 CAJA CON 100 CHINCHES EN 10 COLORES SURTIDOS, FIERO ','Unidad',16,7,5.05,7.25,1,10,NULL,'2024-03-12 11:08:22','2024-03-12 11:08:22'),(355,'43313 CANDADO DE HIERRO 50 MM CON CORAZA, LLAVE ANTI-GANZUA ','43313 CANDADO DE HIERRO 50 MM CON CORAZA, LLAVE ANTI-GANZUA ','Unidad',26,7,47.5,68,1,10,NULL,'2024-03-12 11:09:25','2024-03-18 10:50:14'),(356,'46103 CONTACTO DE SOBREPONER DUPLEX, 2 POLOS TIERRA, BAQUELITA ','46103 CONTACTO DE SOBREPONER DUPLEX, 2 POLOS TIERRA, BAQUELITA ','Unidad',29,7,6.4,9.25,1,10,NULL,'2024-03-12 11:12:01','2024-04-02 10:46:40'),(357,'46160 CINTA DE AISLAR DE 18 M X 19 MM, NEGRA, VOLTECK','46160 CINTA DE AISLAR DE 18 M X 19 MM, NEGRA, VOLTECK','Unidad',16,7,4.05,6.5,1,10,NULL,'2024-03-12 11:13:21','2024-03-26 11:26:40'),(358,'46201 CLAVIJA INDUSTRIAL REFORZADA POLARIZADA, VOLTECK','46201 CLAVIJA INDUSTRIAL REFORZADA POLARIZADA, VOLTECK','Unidad',29,7,4.75,7,1,10,NULL,'2024-03-12 11:16:08','2024-03-18 12:28:56'),(359,'46207 CLAVIJA INDUSTRIAL REFORZADA ATERRIZADA, 2 POLOS Y TIERRA ','46207 CLAVIJA INDUSTRIAL REFORZADA ATERRIZADA, 2 POLOS Y TIERRA ','Unidad',29,7,5.45,8,1,10,NULL,'2024-03-12 11:17:44','2024-04-02 10:46:23'),(360,'46226 LAMPARA LED ALTA POTENCIA 30 W (EQUIV. 250 W), LUZ DE DIA ','46226 LAMPARA LED ALTA POTENCIA 30 W (EQUIV. 250 W), LUZ DE DIA ','Unidad',29,7,30.65,44,1,5,NULL,'2024-03-12 11:19:19','2024-03-18 12:30:04'),(361,'46227 LAMPARA LED ALTA POTENCIA 40 W (EQUIV. 350 W), LUZ DE DIA ','46227 LAMPARA LED ALTA POTENCIA 40 W (EQUIV. 350 W), LUZ DE DIA ','Unidad',29,7,35.45,50.75,1,5,NULL,'2024-03-12 11:20:26','2024-03-18 12:30:18'),(362,'46228 LAMPARA LED ALTA POTENCIA 50 W (EQUIV. 450 W), LUZ DE DIA','46228 LAMPARA LED ALTA POTENCIA 50 W (EQUIV. 450 W), LUZ DE DIA','Unidad',29,7,45.45,65,1,5,NULL,'2024-03-12 11:22:22','2024-03-18 12:30:36'),(363,'46858 LAMPARA LED A19 9 W (EQUIV. 60 W), LUZ DE DIA, BLISTER ','46858 LAMPARA LED A19 9 W (EQUIV. 60 W), LUZ DE DIA, BLISTER ','Unidad',29,7,7.2,10.5,1,10,NULL,'2024-03-12 11:24:53','2024-03-18 12:30:52'),(364,'46860 LAMPARA LED A19 12 W (EQUIV. 75 W), LUZ DE DIA, BLISTER','46860 LAMPARA LED A19 12 W (EQUIV. 75 W), LUZ DE DIA, BLISTER','Unidad',29,7,8.85,12.75,1,10,NULL,'2024-03-12 11:26:14','2024-03-18 12:31:20'),(365,'47350 CONTACTO DE SOBREPONER DUPLEX 2 POLOS+ TIERRA, ABS, VOLTECK','47350 CONTACTO DE SOBREPONER DUPLEX 2 POLOS+ TIERRA, ABS, VOLTECK','Unidad',29,7,7.6,11,1,10,NULL,'2024-03-12 11:31:32','2024-03-18 12:32:28'),(366,'48048 EXTENSION ELECTRICA DE USO RUDO 15 M 2X16 AWG, VOLTECK ','48048 EXTENSION ELECTRICA DE USO RUDO 15 M 2X16 AWG, VOLTECK ','Unidad',29,7,108,154.5,1,5,NULL,'2024-03-12 11:32:48','2024-03-18 12:32:50'),(367,'48049 EXTENSION ELECTRICA DE USO RUDO 20 M 2X16 AWG, VOLTECK','48049 EXTENSION ELECTRICA DE USO RUDO 20 M 2X16 AWG, VOLTECK','Unidad',29,7,139.05,198.75,1,5,NULL,'2024-03-12 11:34:04','2024-03-18 12:36:36'),(368,'48050 EXTENSION ELECTRICA DE USO RUDO 25 M 2X16 AWG, VOLTECK','48050 EXTENSION ELECTRICA DE USO RUDO 25 M 2X16 AWG, VOLTECK','Unidad',29,7,168.2,240.5,1,5,NULL,'2024-03-12 11:34:59','2024-03-18 12:36:59'),(369,'48081 MULTICONECTOR POLIPROPILENO PARA TINACO, CON VALVULA, FOSET','48081 MULTICONECTOR POLIPROPILENO PARA TINACO, CON VALVULA, FOSET','Unidad',16,7,31.3,44.75,1,5,NULL,'2024-03-12 11:37:15','2024-03-18 10:47:34'),(370,'49347 FLOTADOR ELECTRICO CON CABLE DE 3 M, FOSET','49347 FLOTADOR ELECTRICO CON CABLE DE 3 M, FOSET','Unidad',16,7,74.5,106.5,1,5,NULL,'2024-03-12 11:39:11','2024-03-18 10:48:26'),(371,'11899 DISCO TIPO 41 DE 4-1/2 PLG X 1 MM CORTE FINO DE METAL, TRUPER EXPERT ','','Unidad',16,7,6.8,9.75,1,10,NULL,'2024-03-13 12:40:41','2024-04-01 18:09:33'),(372,'TLHPBE141 TORNILLO POLSER PUNTA DE BROCA 1/4 X 1 PLG ','TLHPBE141 TORNILLO POLSER PUNTA DE BROCA 1/4 X 1 PLG ','Unidad',23,11,0.28,0.65,1,1000,NULL,'2024-03-13 14:25:13','2024-03-13 14:25:13'),(373,'TLHPBE14112 TORNILLO POLSER PUNTA DE BROCA 1/4 X 1 1/2 PLG ','','Unidad',23,11,0.32,0.65,1,1000,NULL,'2024-03-13 14:26:35','2024-04-01 18:39:58'),(374,'TLHPBE142 TORNILLO POLSER PUNTA DE BROCA 1/4 X 2 PLG ','TLHPBE142 TORNILLO POLSER PUNTA DE BROCA 1/4 X 2 PLG ','Unidad',23,11,0.38,0.75,1,1000,NULL,'2024-03-13 14:27:54','2024-04-01 18:37:30'),(375,'TLHE141 TORNILLO POLSER GALVANIZADO PUNTA NORMAL 1/4 X 1 PLG','','Unidad',23,11,0.28,0.65,1,500,NULL,'2024-03-13 14:29:08','2024-04-01 18:49:40'),(376,'TLHE14112 TORNILLO POLSER GALVANIZADO PUNTA NORMAL 1/4 X 1 1/2 PLG','','Unidad',23,11,0.38,0.7,1,500,NULL,'2024-03-13 14:30:34','2024-04-01 18:48:31'),(377,'TLHE142 TORNILLO POLSER GALVANIZADO PUNTA NORMAL 1/4 X 2 PLG','','Unidad',23,11,0.4,0.75,1,500,NULL,'2024-03-13 14:31:21','2024-04-01 18:47:19'),(378,'TYPPBE61 TORNILLO PARA TABLA YESO PUNTA DE BROCA 6 X 1 PLG ','','Unidad',23,11,0.08,0.15,1,500,NULL,'2024-03-13 14:38:22','2024-04-01 18:58:47'),(379,'TYPPBE6112 TORNILLO PARA TABLA YESO PUNTA DE BROCA 6 X 1 1/2 PLG','','Unidad',23,11,0.11,0.2,1,500,NULL,'2024-03-13 14:39:43','2024-04-01 18:56:52'),(380,'TYPPBE62 TORNILLO PARA TABLA YESO PUNTA DE BROCA 6 X 2 PLG','','Unidad',23,11,0.12,0.2,1,500,NULL,'2024-03-13 14:41:06','2024-04-01 18:55:54'),(381,'TYPOE61 TORNILLO PARA TABLA YESO PUNTA NORMAL 8 X 1 PLG','TYPOE61 TORNILLO PARA TABLA YESO PUNTA NORMAL 8 X 1 PLG','Unidad',23,11,0.08,0.15,1,500,NULL,'2024-03-13 14:41:58','2024-03-13 14:41:58'),(382,'TYPOE8112 TORNILLO PARA TABLA YESO PUNTA NORMAL 8 X 1 1/2 PLG','TYPOE8112 TORNILLO PARA TABLA YESO PUNTA NORMAL 8 X 1 1/2 PLG','Unidad',23,11,0.09,0.15,1,500,NULL,'2024-03-13 14:43:24','2024-03-13 14:43:24'),(383,'TYPOE82 TORNILLO PARA TABLA YESO PUNTA NORMAL 8 X 2 PLG ','','Unidad',23,11,0.11,0.2,1,500,NULL,'2024-03-13 14:44:29','2024-04-01 19:01:50'),(384,'TYPOE8212 TORNILLO PARA TABLA YESO PUNTA NORMAL 8 X 2 1/2 PLG','','Unidad',23,11,0.14,0.2,1,500,NULL,'2024-03-13 14:45:31','2024-04-01 19:07:51'),(385,'TPLASE932 TARUGO PLASTICO VERDE 9/32 (7X35)','','Unidad',23,11,0.1,0.2,1,300,NULL,'2024-03-13 14:46:52','2024-04-01 19:00:30'),(386,'ROLN14 ROLDANA PLANA NEGRA 1/4','','Unidad',23,11,0.1,0.25,1,300,NULL,'2024-03-13 14:48:06','2024-04-01 19:20:02'),(387,'ROLN38 ROLDANA PLANA NEGRA 3/8 ','','Unidad',23,11,0.12,0.5,1,300,NULL,'2024-03-13 14:52:59','2024-04-01 19:19:50'),(388,'ROLN58 ROLDANA PLANA NEGRA 5/8','','Unidad',23,11,0.7,1.5,1,300,NULL,'2024-03-13 14:54:15','2024-04-01 19:17:59'),(389,'ROLN ROLDANA PLANA NEGRA 1/2 ','','Unidad',23,11,0.35,1,1,300,NULL,'2024-03-13 15:05:37','2024-04-01 19:18:34'),(390,'ROLN34 ROLDANA PLANA NEGRA 3/4 ','','Unidad',23,11,1,2.5,1,300,NULL,'2024-03-13 15:07:25','2024-04-02 11:31:20'),(391,'TLRCE10112 TORNILLO BUSCAROSCA GALVANIZADO 10 X 1 1/2 PLG ','','Unidad',23,11,0.22,0.5,1,300,NULL,'2024-03-13 15:16:28','2024-04-01 19:10:50'),(392,'TLRCE81 TORNILLO BUSCAROSCA GALVANIZADO 8 X 1 PLG','','Unidad',23,11,0.11,0.5,1,300,NULL,'2024-03-13 15:17:18','2024-04-01 19:11:08'),(393,'11901 DISCO TIPO 41 DE 4-1/2 PLG X 1.2 MM CORTE FINO DE METAL, TRUPER EXPERT ','','Unidad',16,7,6.8,9.75,1,10,NULL,'2024-03-13 15:34:16','2024-04-01 18:06:56'),(394,'11998 DISCO TIPO 41 DE 7 PLG X 1.5 MM CORTE FINO DE METAL, TRUPER EXPERT','11998 DISCO TIPO 41 DE 7 PLG X 1.5 MM CORTE FINO DE METAL, TRUPER EXPERT','Unidad',16,7,13.4,19.25,1,10,NULL,'2024-03-13 15:35:19','2024-03-13 15:35:19'),(395,'13004 CUCHARA PARA ALBANIL 7 PLG FORJADA TIPO CENTROAMERICANA, TRUPER ','13004 CUCHARA PARA ALBANIL 7 PLG FORJADA TIPO CENTROAMERICANA, TRUPER ','Unidad',14,7,53,75.75,1,5,NULL,'2024-03-13 15:36:37','2024-04-02 10:29:00'),(396,'14248 GUANTES DE ALGODON RECUBRIMIENTO DE LATEX, UNITALLA, TRUPER ','','Unidad',16,7,24.1,35,1,10,NULL,'2024-03-13 15:38:07','2024-04-01 19:21:15'),(397,'17176 PALA CUADRADA T-2000, MANGO LARGO 45 PLG, TRUPER ','17176 PALA CUADRADA T-2000, MANGO LARGO 45 PLG, TRUPER ','Unidad',14,7,60.2,86,1,5,NULL,'2024-03-13 15:39:58','2024-03-13 15:39:58'),(398,'19281 JUEGO DE 2 SUJETADORES CON MATRACA CARGA MAXIMA 675 KG, TRUPER','19281 JUEGO DE 2 SUJETADORES CON MATRACA CARGA MAXIMA 675 KG, TRUPER','Juego',16,7,85.4,122,1,5,NULL,'2024-03-13 17:02:58','2024-03-21 09:56:21'),(399,'19285 JUEGO DE 2 SUJETADORES CON MATRACA CARGA MAXIMA 1000 KG, TRUPER ','19285 JUEGO DE 2 SUJETADORES CON MATRACA CARGA MAXIMA 1000 KG, TRUPER','Juego',16,7,162.6,232.5,1,5,NULL,'2024-03-13 17:05:22','2024-03-21 09:57:12'),(400,'20542 CUCHARA PARA ALBANIL 7 PLG TIPO CENTROAMERICANA, PRETUL','20542 CUCHARA PARA ALBANIL 7 PLG TIPO CENTROAMERICANA, PRETUL','Unidad',14,7,20,30,1,5,NULL,'2024-03-13 17:07:24','2024-04-02 10:28:36'),(401,'22351 DISCO 4-1/2 PLG LAMINADO GRANO 60 CENTRO 7/8 PLG, PRETUL ','22351 DISCO 4-1/2 PLG LAMINADO GRANO 60 CENTRO 7/8 PLG, PRETUL ','Unidad',16,7,9.5,13.75,1,10,NULL,'2024-03-13 17:09:06','2024-03-13 17:09:06'),(402,'22352 DISCO 4-1/2 PLG LAMINADO GRANO 80 CENTRO 7/8 PLG, PRETUL','22352 DISCO 4-1/2 PLG LAMINADO GRANO 80 CENTRO 7/8 PLG, PRETUL','Unidad',16,7,9.5,13.75,1,10,NULL,'2024-03-13 17:10:02','2024-03-13 17:10:02'),(403,'22353 DISCO 7 PLG LAMINADO GRANO 40 CENTRO 7/8 PLG, PRETUL','22353 DISCO 7 PLG LAMINADO GRANO 40 CENTRO 7/8 PLG, PRETUL','Unidad',16,7,25.2,36,1,10,NULL,'2024-03-13 17:11:24','2024-03-13 17:11:24'),(404,'22354 DISCO 7 PLG LAMINADO GRANO 60 CENTRO 7/8 PLG, PRETUL','22354 DISCO 7 PLG LAMINADO GRANO 60 CENTRO 7/8 PLG, PRETUL','Unidad',16,7,25.2,36,1,10,NULL,'2024-03-13 17:12:33','2024-03-13 17:12:33'),(405,'22355 DISCO 7 PLG LAMINADO GRANO 80 CENTRO 7/8 PLG, PRETUL','22355 DISCO 7 PLG LAMINADO GRANO 80 CENTRO 7/8 PLG, PRETUL','Unidad',16,7,25.2,36,1,10,NULL,'2024-03-13 17:13:44','2024-03-13 17:13:44'),(406,'23262 GUANTES DE CARNAZA, CORTOS, PRETUL','','Unidad',16,7,37,53,1,10,NULL,'2024-03-13 17:14:56','2024-04-01 19:24:18'),(407,'24120 ESCALERA TUBULAR, PLEGABLE, 3 PELDAÃ‘OS, PRETUL','24120 ESCALERA TUBULAR, PLEGABLE, 3 PELDAÃ‘OS, PRETUL','Unidad',14,7,331.6,473.75,1,5,NULL,'2024-03-13 17:16:18','2024-03-13 17:16:18'),(408,'G8896133 CHAPEADORA HERON 52CC / 2TIEMPOS / 1.4KW','G8896133 CHAPEADORA HERON 52CC / 2TIEMPOS / 1.4KW','Unidad',15,8,950,1357.25,1,5,NULL,'2024-03-13 18:19:43','2024-03-13 18:19:43'),(409,'HKNS16001 CUCHILLA INGCO DE HOJAS DESECHABLES 18 X 100 MM SUPER SELECT MANGO F','HKNS16001 CUCHILLA INGCO DE HOJAS DESECHABLES 18 X 100 MM SUPER SELECT MANGO F','Unidad',16,8,3.5,8,1,10,NULL,'2024-03-13 18:21:22','2024-04-03 16:23:56'),(410,'HKNSB112 CUCHILLAS DE REPUESTO 18 X 100 MM 10 PZS SUPER SELECT INGCO','HKNSB112 CUCHILLAS DE REPUESTO 18 X 100 MM 10 PZS SUPER SELECT INGCO','Unidad',16,8,5,10,1,5,NULL,'2024-03-13 18:24:52','2024-04-03 16:21:12'),(411,'HRUH8216 MAZO DE HULE INGCO 16 ONZ','HRUH8216 MAZO DE HULE INGCO 16 ONZ','Unidad',14,8,26,37.5,1,5,NULL,'2024-03-13 18:25:49','2024-04-03 16:55:55'),(412,'8813056 TENAZA DE CARPINTERO EXTOL 10 PLG EP','','Unidad',24,8,17,25,1,5,NULL,'2024-03-13 18:26:42','2024-04-03 16:42:59'),(413,'5500263 CLAVO 2 1/2 PLG BOLSA, AG','','Libra',12,10,4.7,6.5,1,500,NULL,'2024-03-14 09:10:20','2024-03-26 10:38:42'),(414,'5500264 CLAVO 3 PLG BOLSA, AG','','Libra',12,10,4.7,6.5,1,500,NULL,'2024-03-14 09:11:46','2024-03-26 10:39:01'),(415,'5500265 CLAVO 4 PLG EN BOLSA, AG','','Libra',12,10,4.7,7,1,500,NULL,'2024-03-14 09:13:53','2024-03-26 10:38:19'),(416,'5500241 ALAMBRE DE AMARRE CALIBRE 16, AG','','Libra',12,10,4.75,6.5,1,500,NULL,'2024-03-14 09:15:03','2024-03-26 10:47:36'),(417,'5500254 CLAVO DE 5 PLG, AG','5500254 CLAVO DE 5 PLG, AG','Libra',12,10,4.61,7,1,500,NULL,'2024-03-14 09:16:12','2024-03-26 10:38:00'),(418,'8816008 LLAVE DE COLA CORONA 8 MM CRV P-H EXTOL PRIMIUM ','8816008 LLAVE DE COLA CORONA 8 MM CRV P-H EXTOL PRIMIUM ','Unidad',14,8,5,7.25,1,5,NULL,'2024-03-14 11:01:58','2024-03-14 11:01:58'),(419,'8816009 LLAVE DE COLA CORONA 9 MM CRV P-H EXTOL PRIMIUM ','8816009 LLAVE DE COLA CORONA 9 MM CRV P-H EXTOL PRIMIUM ','Unidad',14,8,5.25,7.5,1,5,NULL,'2024-03-14 11:06:34','2024-03-14 11:06:34'),(420,'8816010 LLAVE DE COLA CORONA 10 MM CRV P-H EXTOL PRIMIUM ','8816010 LLAVE DE COLA CORONA 10 MM CRV P-H EXTOL PRIMIUM ','Unidad',14,8,5.5,8,1,5,NULL,'2024-03-14 11:07:51','2024-03-14 11:07:51'),(421,'8816012 LLAVE DE COLA CORONA 12 MM CRV P-H EXTOL PRIMIUM ','8816012 LLAVE DE COLA CORONA 12 MM CRV P-H EXTOL PRIMIUM ','Unidad',14,8,6,8.75,1,5,NULL,'2024-03-14 11:08:58','2024-03-14 11:08:58'),(422,'8816014 LLAVE DE COLA CORONA 14 MM CRV P-H EXTOL PRIMIUM ','8816014 LLAVE DE COLA CORONA 14 MM CRV P-H EXTOL PRIMIUM ','Unidad',14,8,7,10,1,5,NULL,'2024-03-14 11:10:01','2024-03-14 11:10:01'),(423,'8816015 LLAVE DE COLA CORONA 15 MM CRV P-H EXTOL PRIMIUM ','8816015 LLAVE DE COLA CORONA 15 MM CRV P-H EXTOL PRIMIUM ','Unidad',14,8,7.25,10.5,1,5,NULL,'2024-03-14 11:11:06','2024-03-14 11:11:06'),(424,'8816016 LLAVE DE COLA CORONA 16 MM CRV P-H EXTOL PRIMIUM ','8816016 LLAVE DE COLA CORONA 16 MM CRV P-H EXTOL PRIMIUM ','Unidad',14,8,7.5,10.75,1,5,NULL,'2024-03-14 11:13:03','2024-03-14 11:13:03'),(425,'8816017 LLAVE DE COLA CORONA 17 MM CRV P-H EXTOL PRIMIUM ','8816017 LLAVE DE COLA CORONA 17 MM CRV P-H EXTOL PRIMIUM ','Unidad',14,8,8.5,12.25,1,5,NULL,'2024-03-14 11:14:32','2024-03-14 11:14:32'),(426,'8816019 LLAVE DE COLA CORONA 19 MM CRV P-H EXTOL PRIMIUM ','8816019 LLAVE DE COLA CORONA 19 MM CRV P-H EXTOL PRIMIUM ','Unidad',14,8,10,14.5,1,5,NULL,'2024-03-14 11:15:32','2024-03-14 11:15:32'),(427,'8816021 LLAVE DE COLA CORONA 21 MM CRV P-H EXTOL PRIMIUM ','8816021 LLAVE DE COLA CORONA 21 MM CRV P-H EXTOL PRIMIUM ','Unidad',14,8,11,15.75,1,5,NULL,'2024-03-14 11:16:40','2024-03-14 11:16:40'),(428,'G8890032 BARRENO DE IMPACTO EXTOL 750W EP','G8890032 BARRENO DE IMPACTO EXTOL 750W EP','Unidad',15,8,235,335.75,1,5,NULL,'2024-03-14 11:18:23','2024-03-14 11:18:23'),(429,'HSMT39519 CINTA METRICA 5 M X 19 MM SUPER SELECT D','HSMT39519 CINTA METRICA 5 M X 19 MM SUPER SELECTD','Unidad',14,8,9,14,1,10,NULL,'2024-03-14 11:21:47','2024-04-03 16:46:01'),(430,'HSMT26525 CINTA METRICA 5 M X 25 MM LINEA BASICA','HSMT26525 CINTA METRICA 5 M X 25 MM LINEA BASICA','Unidad',14,8,11.5,16.5,1,5,NULL,'2024-03-14 11:22:42','2024-03-14 11:22:42'),(431,'UHPWR14008 HIDROLAVADORA 1400W','UHPWR14008 HIDROLAVADORA 1400W','Unidad',15,8,400,571.5,1,5,NULL,'2024-03-14 11:24:12','2024-03-14 11:24:12'),(432,'5548251 HILO PARA CONSTRUCCION  0.80 MM','5548251 HILO PARA CONSTRUCCION  0.80 MM','Unidad',16,8,7,10,1,10,NULL,'2024-03-14 11:36:44','2024-03-14 11:36:44'),(433,'5548253 HILO PARA CONSTRUCCION 1.00 MM','5548253 HILO PARA CONSTRUCCION 1.00 MM','Unidad',16,8,9.35,13.5,1,10,NULL,'2024-03-14 11:38:10','2024-03-14 11:38:10'),(434,'5548254  HILO PARA CONSTRUCCION 1.20 MM','5548254  HILO PARA CONSTRUCCION 1.20 MM','Unidad',16,8,9.7,14,1,10,NULL,'2024-03-14 11:44:28','2024-03-14 11:44:28'),(435,'UCIDLI20605 BARRENO DE IMPACTO INALAMBRICO 20V, 1/2 PLG, 70NM CON DOS BATERIAS Y CARGADOR','UCIDLI20605 BARRENO DE IMPACTO INALAMBRICO 20V, 1/2 PLG, 70NM CON DOS BATERIAS Y CARGADOR','Unidad',17,8,800,1143,1,5,NULL,'2024-03-14 11:46:17','2024-03-14 11:46:17'),(436,'UID11008 BARRENO DE IMPACTO INGCO 1100W/ 2800RPM','UID11008 BARRENO DE IMPACTO INGCO 1100W/ 2800RPM','Unidad',15,8,370,528.75,1,5,NULL,'2024-03-14 11:47:24','2024-03-14 11:47:24'),(437,'UAG7118 ESMERIL ANGULAR INGCO 710W 4-1/2 PLG','UAG7118 ESMERIL ANGULAR INGCO 710W 4-1/2 PLG','Unidad',15,8,170,243,1,5,NULL,'2024-03-14 11:48:41','2024-03-14 11:48:41'),(438,'USPG5008 PISTOLA PARA PINTAR INGCO 550W','USPG5008 PISTOLA PARA PINTAR INGCO 550W','Unidad',15,8,275,393,1,5,NULL,'2024-03-14 11:49:51','2024-03-14 11:49:51'),(439,'9965 GUANTES DE CUERO PARA TRABAJO EXTOL - 10 PLG','9965 GUANTES DE CUERO PARA TRABAJO EXTOL - 10 PLG','Unidad',16,8,19.75,28.5,1,10,NULL,'2024-03-14 11:50:54','2024-03-28 10:16:42'),(440,'5106907 DISCO DE CORTE PARA METAL 7 PLG EXTOL PREMIUM','','Unidad',16,8,7.2,12,1,10,NULL,'2024-03-14 11:53:29','2024-04-03 16:54:30'),(441,'5106904 DISCO DE CORTE PARA METAL 4.5 PLG EXTOL PREMIUM ','5106904 DISCO DE CORTE PARA METAL 4.5 PLG EXTOL PREMIUM ','Unidad',16,8,2.5,5,1,10,NULL,'2024-03-14 11:55:31','2024-03-28 09:46:29'),(442,'5569439.1 BOTA INDUSTRIAL CAFE LUSTRABLE S1P/PLANTILLA ANTI-P ACERO INOX','5569439.1 BOTA INDUSTRIAL CAFE LUSTRABLE S1P/PLANTILLA ANTI-P ACERO INOX','Unidad',16,8,270,385.75,1,5,NULL,'2024-03-14 11:58:34','2024-03-14 11:58:34'),(443,'5569440 BOTA INDUSTRIAL CAFE/CAT S3/P. ANTI/P ACERO INOX/MOD NOBUCK/WATERPRO','5569440 BOTA INDUSTRIAL CAFE/CAT S3/P. ANTI/P ACERO INOX/MOD NOBUCK/WATERPRO','Unidad',16,8,215,308,1,5,NULL,'2024-03-14 12:00:05','2024-03-28 13:26:42'),(444,'8703041 DISCO DE CORTE FINO DIAMANTE TURBO 4-1/2 PLG SECO/HUMEDO EXTOL I','8703041 DISCO DE CORTE FINO DIAMANTE TURBO 4-1/2 PLG SECO/HUMEDO EXTOL I','Unidad',16,8,43,61.5,1,5,NULL,'2024-03-14 12:01:27','2024-03-14 12:01:27'),(445,'HCP08208 ALICATE PARA ELECTRICISTA 8 PLG SUPER SELECT BIMATERIAL INOXIDABLE INGCO','HCP08208 ALICATE PARA ELECTRICISTA 8 PLG SUPER SELECT BIMATERIAL INOXIDABLE INGCO','Unidad',14,8,23,34,1,5,NULL,'2024-03-14 12:02:32','2024-04-03 16:40:34'),(446,'HCP08188 ALICATE PARA ELECTRICISTA 7 PLG, SUPER SELECT BIMATERIAL INOXIDABLE INGCO','HCP08188 ALICATE PARA ELECTRICISTA 7 PLG, SUPER SELECT BIMATERIAL INOXIDABLE INGCO','Unidad',14,8,21,31,1,5,NULL,'2024-03-14 12:04:01','2024-04-03 16:41:37'),(447,'HRSP3107 CINTA CON RATCHET10 M X 50 MM 3TON','HRSP3107 CINTA CON RATCHET10 M X 50 MM 3TON','Unidad',16,8,60,95,1,5,NULL,'2024-03-14 12:05:28','2024-03-19 09:49:59'),(448,'HRSP5107 CINTA CON RATCHET 10 M X 50 MM 5TON','HRSP5107 CINTA CON RATCHET 10 M X 50 MM 5TON','Unidad',16,8,75,125,1,5,NULL,'2024-03-14 12:06:19','2024-03-19 09:50:13'),(449,'HHFS3068 SIERRA DE MANO INGCO 12 PLG SUPER SELECT','HHFS3068 SIERRA DE MANO INGCO 12 PLG SUPER SELECT','Unidad',14,8,23,34,1,5,NULL,'2024-03-14 12:10:05','2024-04-03 17:15:35'),(450,'HSBB12186 SIERRAS (SEGUETA) INGCO 12 PLG','','Unidad',16,8,5.6,8,1,10,NULL,'2024-03-14 12:12:15','2024-04-02 18:56:36'),(451,'HSCRS811002 TIJERA INGCO 8.5 PLG SUPER SELECTD','HSCRS811002 TIJERA INGCO 8.5 PLG SUPER SELECTD','Unidad',16,8,8.5,14,1,5,NULL,'2024-03-14 12:13:26','2024-04-03 16:25:44'),(452,'GRT75-1 COMPACTADORA INGCO MOTOR HONDA ','GRT75-1 COMPACTADORA INGCO MOTOR HONDA ','Unidad',15,8,9950,14214.5,1,5,NULL,'2024-03-14 12:15:07','2024-03-14 12:15:07'),(453,'GVR-1 VIBRADOR PARA CONCRETO INGCO 4000W DE 5.5HP MOTOR HONDA ','GVR-1 VIBRADOR PARA CONCRETO INGCO 4000W DE 5.5HP MOTOR HONDA ','Unidad',15,8,3850,5500,1,5,NULL,'2024-03-14 12:16:22','2024-03-14 12:16:22'),(454,'VBP1451 MANGUERA INGCO PARA VIBRADOR DE CONCRETO ','VBP1451 MANGUERA INGCO PARA VIBRADOR DE CONCRETO ','Unidad',16,8,750,1071.5,1,5,NULL,'2024-03-14 12:17:29','2024-03-14 12:17:29'),(455,'10068 BOMBA PERIFERICA 1/2 HP, ALT MAX 45M','','Unidad',15,7,278.65,369,1,5,NULL,'2024-03-14 12:26:51','2024-04-02 10:14:21'),(456,'101710 JUEGO DE 12 PUNTAS HEXAGONALES LARGO 2 PLG','TRUPER EXPERT','Juego',16,7,36.2,51.75,1,5,NULL,'2024-03-14 12:29:28','2024-04-02 10:22:24'),(457,'102428 PINZA CORTE DIAGONAL 8 PLG MANGO COMFORT GRIP, TRUPER EXPERT','','Unidad',14,7,61.5,88,1,5,NULL,'2024-03-14 12:31:40','2024-04-01 17:52:35'),(458,'15421 VOLTEADOR DE ALUMINIO, TRUPER','15421 VOLTEADOR DE ALUMINIO, TRUPER','Unidad',14,7,45,64.5,1,5,NULL,'2024-03-14 12:33:38','2024-03-14 12:33:38'),(459,'15424 RAYADOR DE ALUMINIO, TRUPER','15424 RAYADOR DE ALUMINIO, TRUPER','Unidad',14,7,70,100,1,5,NULL,'2024-03-14 12:35:08','2024-03-14 12:35:08'),(460,'17360 PINZA 8 PLG PELA CABLES AUTOMATICA, 22 A 10 AWG, TRUPER','17360 PINZA 8 PLG PELA CABLES AUTOMATICA, 22 A 10 AWG, TRUPER','Unidad',14,7,144,205.75,1,5,NULL,'2024-03-14 12:40:32','2024-03-14 12:40:32'),(461,'18565 SELLADOR TRANSLUCIDO PARA BAÃ‘OS Y COCINAS, 280 ML, TRUPER','18565 SELLADOR TRANSLUCIDO PARA BAÃ‘OS Y COCINAS, 280 ML, TRUPER','Unidad',16,7,40.3,57.75,1,10,NULL,'2024-03-14 12:43:27','2024-03-14 12:43:27'),(462,'21530 BROCHA USO GENERAL DE 5 PLG CON MANGO DE PLASTICO, PRETUL','21530 BROCHA USO GENERAL DE 5 PLG CON MANGO DE PLASTICO, PRETUL','Unidad',30,7,11.55,16.5,1,5,NULL,'2024-03-14 12:45:32','2024-03-18 12:19:26'),(463,'27160 PINZA DE CORTE DIAGONAL 8 PLG MANGO COMFORT GRIP, PRETUL','27160 PINZA DE CORTE DIAGONAL 8 PLG MANGO COMFORT GRIP, PRETUL','Unidad',14,7,23.2,33.25,1,5,NULL,'2024-03-14 13:12:57','2024-03-14 13:12:57'),(464,'24740 JUEGO DE PINCELES EN BLISTER CON 5 PIEZAS, PRETUL','24740 JUEGO DE PINCELES EN BLISTER CON 5 PIEZAS, PRETUL','BlÃ­ster ',30,7,10.2,14.75,1,5,NULL,'2024-03-14 13:14:56','2024-03-20 15:05:33'),(465,'ABRAZADERA TAIWAN 1/2 PLG','','Unidad',16,12,1.4,3,1,10,NULL,'2024-03-15 14:15:25','2024-04-02 16:02:10'),(466,'ABRAZADERA TAIWAN 5/8 PLG','ABRAZADERA TAIWAN 5/8 PLG ','Unidad',16,12,1.4,3,1,10,NULL,'2024-03-15 14:34:00','2024-03-18 10:53:59'),(467,'ABRAZADERA TAIWAN 3/4 PLG','','Unidad',16,12,1.4,3,1,10,NULL,'2024-03-15 14:38:34','2024-04-02 16:02:29'),(468,'ABRAZADERA TAIWAN 1 PLG','','Unidad',16,12,1.6,3.5,1,10,NULL,'2024-03-15 14:39:33','2024-04-02 16:01:38'),(469,'ARMELLA CERRADA FIXE CROMADA N. 10 ','ARMELLA CERRADA FIXE CROMADA N. 10 ','Unidad',23,12,0.25,1,1,50,NULL,'2024-03-15 18:42:48','2024-04-02 09:44:41'),(470,'ARMELLA CERRADA FIXE CROMADA N. 12','ARMELLA CERRADA FIXE CROMADA N. 12','Unidad',23,12,0.3,1,1,50,NULL,'2024-03-15 18:44:01','2024-04-02 09:45:01'),(471,'ARMELLA CERRADA FIXE CROMADA N. 14 ','ARMELLA CERRADA FIXE CROMADA N. 14 ','Unidad',23,12,0.4,1.5,1,50,NULL,'2024-03-15 18:45:20','2024-04-02 09:45:14'),(472,'ARMELLA CERRADA FIXE CROMADA N. 16','','Unidad',23,12,1.05,2,1,50,NULL,'2024-03-16 10:22:20','2024-04-02 10:04:28'),(473,'ARMELLA CERRADA FIXE CROMADA N. 18','','Unidad',23,12,1.35,3,1,50,NULL,'2024-03-16 10:26:12','2024-04-02 10:05:01'),(474,'ARMELLA CERRADA FIXE CROMADA N. 22','','Unidad',23,12,2.05,3.5,1,50,NULL,'2024-03-16 10:28:59','2024-04-02 10:05:31'),(475,'ARMELLA ABIERTA FIXE CROMADA N. 8','','Unidad',23,12,0.2,1,1,50,NULL,'2024-03-16 11:02:45','2024-04-02 10:00:34'),(476,'ARMELLA ABIERTA FIXE CROMADA N. 12','','Unidad',23,12,0.45,1.5,1,50,NULL,'2024-03-16 11:03:22','2024-04-02 09:58:56'),(477,'ARMELLA ABIERTA FIXE CROMADA N. 14','','Unidad',23,12,0.65,2,1,50,NULL,'2024-03-16 11:04:06','2024-04-02 09:59:34'),(478,'BALANZA DE MOSTRADOR CADENA 44 LBS. 20 KGS ','','Unidad',35,12,113.65,165,1,5,NULL,'2024-03-16 11:40:36','2024-04-03 12:03:43'),(479,'BARNIZ MARINO SEGA 1/4 GAL','','Unidad',24,12,40,60,1,5,NULL,'2024-03-16 11:44:14','2024-04-02 10:08:32'),(480,'BISAGRA PARA GABINETE CON RESORTE DORADA B/P','','Unidad',25,12,5.45,10,1,20,NULL,'2024-03-16 11:47:19','2024-04-02 10:10:49'),(481,'BISAGRA PARA GABINETE CON RESORTE COBRE ANTIGUO A/C','','Unidad',25,12,5.24,10,1,10,NULL,'2024-03-16 11:48:14','2024-04-02 10:09:58'),(482,'BISAGRA PESADA PULIDA 2 PLG X 1.2 MM.','','Unidad',25,12,1.05,2.5,1,10,NULL,'2024-03-16 11:49:34','2024-04-02 10:12:02'),(483,'BISAGRA PESADA PULIDA 3 PLG X 1.5 MM ','','Unidad',25,12,2.25,4,1,10,NULL,'2024-03-16 11:50:30','2024-04-02 17:30:38'),(484,'BISAGRA PESADA PULIDA 4 PLG X 1.8 MM. ','','Unidad',25,12,5.15,9,1,10,NULL,'2024-03-16 11:51:33','2024-04-02 16:03:17'),(485,'LIJA EN BANDA FANDELI X-88 3 X 21 PLG ART. 00238 N.60 ','','Unidad',22,12,8.25,12,1,10,NULL,'2024-03-16 11:55:35','2024-04-03 11:48:02'),(486,'LIJA EN BANDA FANDELI X-88 3 X 21 PLG ART. 07564 N.80','','Unidad',22,12,7.9,12,1,10,NULL,'2024-03-16 11:57:04','2024-04-03 11:49:08'),(487,'LIJA EN BANDA FANDELI X-88 4 X 24 PLG ART. 01564 N.60','','Unidad',22,12,12.05,17.5,1,10,NULL,'2024-03-16 11:57:58','2024-04-03 11:52:09'),(488,'LIJA EN BANDA FANDELI X-88 4 X 24 PLG ART. 07589 N.80 ','','Unidad',22,12,11.6,16.75,1,10,NULL,'2024-03-16 11:58:51','2024-04-03 11:52:45'),(489,'UCS18538 SIERRA CIRCULAR INGCO 1400W 7-1/4 PLG 4800RPM ','','Unidad',15,8,0,450,1,5,NULL,'2024-03-16 12:14:52','2024-04-03 11:59:07'),(490,'LIJA MULTIUSOS FANDELI X-86 ART. 00092 N.60','','Unidad',22,12,5.45,8.25,1,10,NULL,'2024-03-16 12:18:36','2024-04-03 11:56:37'),(491,'LIJA MULTIUSOS FANDELI J-86 ART. 00073 N. 80 ','','Unidad',22,12,4.8,7.25,1,10,NULL,'2024-03-16 12:20:04','2024-04-03 11:53:09'),(492,'LIJA MULTIUSOS FANDELI J-86 ART. 00074 N.100','','Unidad',22,12,4.35,6.5,1,10,NULL,'2024-03-16 12:21:23','2024-04-03 11:53:37'),(493,'LIJA MULTIUSOS FANDELI J-86 ART. 00075 N.120','','Unidad',22,12,4.35,6.5,1,10,NULL,'2024-03-16 12:22:06','2024-04-03 11:54:10'),(494,'LIJA MULTIUSOS FANDELI J-86 ART. 00076 N.150','','Unidad',22,12,4.35,6.5,1,10,NULL,'2024-03-16 12:23:26','2024-04-03 11:54:33'),(495,'LIJA MULTIUSOS FANDELI J-86 ART. 00077 N.180','','Unidad',22,12,4.35,6.5,1,10,NULL,'2024-03-16 12:24:18','2024-04-03 11:55:31'),(496,'LIJA MULTIUSOS FANDELI J-86 ART. 00078 N.220 ','','Unidad',22,12,4.35,6.5,1,10,NULL,'2024-03-16 12:30:03','2024-04-03 11:56:03'),(497,'BROCA SIERRA PARA MADERA MARCA CAIMAN 7/8 PLG','','Unidad',16,12,26.5,45,1,5,NULL,'2024-03-16 12:32:51','2024-04-02 17:32:11'),(498,'BROCHA MANGO PLASTICO PELO NEGRO MARCA CAIMAN 5 PLG','','Unidad',30,12,12.25,18.75,1,5,NULL,'2024-03-16 12:34:01','2024-04-02 17:33:23'),(499,'BROCHA MANGO PLASTICO PELO NEGRO CAIMAN 4 ','','Unidad',30,12,7.5,11,1,5,NULL,'2024-03-16 12:34:52','2024-04-02 17:32:42'),(500,'CADENA DE ESLABON 1/4','','Yarda',36,12,12.25,18.75,1,10,NULL,'2024-03-16 12:36:52','2024-04-03 12:04:05'),(501,'CAJA RECTANGULAR PLASTICA INDUMA 2 X 4 PLG T7501-023 - T1202-0026-T1202-0027 ','','Unidad',29,12,2,3.5,1,10,NULL,'2024-03-16 12:40:04','2024-04-02 17:35:45'),(502,'CAJA OCTAGONAL PLASTICA INDUMA T7501-003 - T1202-0031 ','','Unidad',29,12,2.25,3.75,1,10,NULL,'2024-03-16 12:40:49','2024-04-02 17:34:57'),(503,'CANDADO WHALE DORADO BLISTER 40 MM. ','','Unidad',26,12,11,17,1,5,NULL,'2024-03-16 12:43:05','2024-04-02 17:36:49'),(504,'CANDADO WHALE DORADO BLISTER 50 MM.','','Unidad',26,12,18,28,1,5,NULL,'2024-03-18 09:19:33','2024-04-02 17:37:41'),(505,'CANDADO WHALE DORADO BLISTER 30 MM.','','Unidad',26,12,9.25,15,1,5,NULL,'2024-03-18 09:20:41','2024-04-02 17:36:17'),(506,'CEDAZO ARNERO MARCA HALCON 1/4 PLG, CAL. 23 ','','Yarda',27,12,10.35,16,1,25,NULL,'2024-03-18 09:29:57','2024-04-02 17:38:12'),(507,'CEDAZO ARNERO MARCA HALCON 1/8 PLG, CAL. 27','','Yarda',27,12,18.1,25,1,25,NULL,'2024-03-18 09:31:33','2024-04-02 17:38:50'),(508,'CEDAZO MOSQUITERO METALICO MARCA HALCON 1/16 PLG COLOR GRIS','','Yarda',27,12,8.9,15,1,25,NULL,'2024-03-18 09:34:40','2024-03-26 17:08:53'),(509,'CHAPA DE BOLA CON LLAVE MARCA CADENA COLOR LATON ANTIGUO','','Unidad',26,12,51,90,1,5,NULL,'2024-03-18 09:37:02','2024-04-02 17:39:47'),(510,'CHAPA PARA GAVETA 808 DORADA HL-503','','Unidad',26,12,7.85,13,1,10,NULL,'2024-03-18 09:38:17','2024-04-02 17:40:19'),(511,'CHEQUE HORIZONTAL ASIENTO NEOPRENE MARCA GRIFER 200 WOG ( G5755 ) 1/2 PLG ','','Unidad',28,12,34,50,1,5,NULL,'2024-03-18 09:42:34','2024-04-02 17:41:05'),(512,'CHEQUE HORIZONTAL ASIENTO NEOPRENE MARCA GRIFER 200 WOG ( G5762 ) 3/4 PLG','','Unidad',28,12,47,65,1,5,NULL,'2024-03-18 09:47:04','2024-04-02 17:41:57'),(513,'CHEQUE VERTICAL CON MALLA MARCA PORTE 200 WOG DE 1/2','','Unidad',28,12,35,50,1,5,NULL,'2024-03-18 09:48:38','2024-04-02 17:43:36'),(514,'CHEQUE VERTICAL CON MALLA MARCA PORTE 200 WOG 3/4','','Unidad',28,12,53,68,1,5,NULL,'2024-03-18 09:49:53','2024-04-02 17:44:16'),(515,'CINCHO PLASTICO BLANCO 3.6 X 150 MM. 6 PLG','','Unidad',16,12,0.1,0.25,1,25,NULL,'2024-03-18 09:51:59','2024-04-03 11:44:59'),(516,'CINCHO PLASTICO BLANCO 3.6 X 200 MM. 8 PLG','','Unidad',16,12,0.1,0.25,1,25,NULL,'2024-03-18 11:20:35','2024-04-03 11:45:32'),(517,'CINCHO PLASTICO BLANCO 4.8 X 250 MM. 10 PLG','','Unidad',16,12,0.15,0.5,1,25,NULL,'2024-03-18 11:22:22','2024-04-03 11:45:57'),(518,'CINCHO PLASTICO NATURAL SHOWA 4.8 MM. X 300 MM. 12 PLG ','','Unidad',16,12,0.3,0.5,1,25,NULL,'2024-03-18 11:25:16','2024-04-03 11:46:30'),(519,'CLAVO PARA CONCRETO FIXE 2 PLG','CLAVO PARA CONCRETO FIXE 2 PLG','Unidad',12,12,0.15,0.5,1,50,NULL,'2024-03-19 09:38:58','2024-03-19 09:38:58'),(520,'CLAVO PARA CONCRETO FIXE 2 1/2 PLG ','CLAVO PARA CONCRETO FIXE 2 1/2 PLG ','Unidad',12,12,0.2,0.5,1,50,NULL,'2024-03-19 09:43:35','2024-03-19 09:43:35'),(521,'CLAVO PARA CONCRETO FIXE 3 PLG','CLAVO PARA CONCRETO FIXE 3 PLG','Unidad',12,12,0.25,0.75,1,50,NULL,'2024-03-19 09:45:26','2024-03-19 09:45:26'),(522,'CLAVO PARA CONCRETO FIXE 4 PLG','CLAVO PARA CONCRETO FIXE 4 PLG','Unidad',12,12,0.4,1,1,25,NULL,'2024-03-19 09:48:42','2024-03-19 09:48:42'),(523,'TACHUELA BUTTERFLY 3/4 PLG','TACHUELA BUTTERFLY 3/4 PLG','Caja',16,12,11,17,1,2,NULL,'2024-03-19 09:58:51','2024-03-19 09:58:51'),(524,'TACHUELA BUTTERFLY 1 PLG','TACHUELA BUTTERFLY 1 PLG','Caja',16,12,11,17,1,2,NULL,'2024-03-19 09:59:48','2024-03-19 09:59:48'),(525,'CRAYON PARA CARPINTERO GRUESO CRANE','CRAYON PARA CARPINTERO GRUESO CRANE','Unidad',16,12,1.1,3,1,20,NULL,'2024-03-19 10:04:15','2024-03-19 10:04:15'),(526,'CORTAVIDRIO TIPO SILBERSCHNITT','CORTAVIDRIO TIPO SILBERSCHNITT','Unidad',16,12,13,20,1,5,NULL,'2024-03-19 10:06:05','2024-03-19 10:06:05'),(527,'CRUZETA PARA COLOCAR AZULEJO BODMAN 2 MM','CRUZETA PARA COLOCAR AZULEJO BODMAN 2 MM','Bolsa 200 U.',16,12,5,9,1,3,NULL,'2024-03-19 10:07:54','2024-03-19 10:07:54'),(528,'CRUZETA PARA COLOCAR AZULEJO BODMAN 3 MM','CRUZETA PARA COLOCAR AZULEJO BODMAN 3 MM','Bolsa 200 U.',16,12,7,11,1,3,NULL,'2024-03-19 10:09:15','2024-03-19 10:09:15'),(529,'CRUZETA PARA COLOCAR AZULEJO BODMAN 4 MM','CRUZETA PARA COLOCAR AZULEJO BODMAN 4 MM','Bolsa 200 U.',16,12,9,14,1,3,NULL,'2024-03-19 10:12:51','2024-03-19 10:12:51'),(530,'CRUZETA PARA COLOCAR AZULEJO BODMAN 5 MM','CRUZETA PARA COLOCAR AZULEJO BODMAN 5 MM','Bolsa 200 U. ',16,12,11,15,1,3,NULL,'2024-03-19 10:14:01','2024-03-19 10:14:01'),(531,'DISCO DE LIJA SUJECION VELCRO FANDELI E088 5 PLG 8 AGUJEROS ART. 03450 N 60 ','DISCO DE LIJA SUJECION VELCRO FANDELI E088 5 PLG 8 AGUJEROS ART. 03450 N 60 ','Unidad',22,12,2.55,4.5,1,10,NULL,'2024-03-19 10:15:55','2024-04-02 09:50:29'),(532,'DISCO DE LIJA SUJECION VELCRO FANDELI E088 5 PLG 8 AGUJEROS ART. 03451 N. 80 ','DISCO DE LIJA SUJECION VELCRO FANDELI E088 5 PLG 8 AGUJEROS ART. 03451 N 80','Unidad',22,12,2.35,4.5,1,10,NULL,'2024-03-19 10:20:30','2024-04-02 09:50:48'),(533,'LLAVE DE CHORRO PVC CON ROSCA MARCA PORTE ( 610538 ) 200 PSI 1/2 PLG','LLAVE DE CHORRO PVC CON ROSCA MARCA PORTE ( 610538 ) 200 PSI 1/2 PLG','Unidad',28,12,5.5,10,1,5,NULL,'2024-03-19 10:22:37','2024-03-19 10:22:37'),(534,'LLAVE DE CHORRO PVC CON ROSCA MARCA PORTE ( 610545 ) 200 PSI 3/4 PLG','LLAVE DE CHORRO PVC CON ROSCA MARCA PORTE ( 610545 ) 200 PSI 3/4 PLG','Unidad',28,12,6,11,1,5,NULL,'2024-03-19 10:25:02','2024-03-19 10:25:02'),(535,'ESCALERA ALUMINIO 2 BANDAS DOMESTICA CON BANDEJA INCO (200 LBS) 7 PIES','ESCALERA ALUMINIO 2 BANDAS DOMESTICA CON BANDEJA INCO (200 LBS) 7 PIES','Unidad',14,12,620.2,975,1,2,NULL,'2024-03-19 10:28:43','2024-03-19 10:28:43'),(536,'ESCALERA ALUMINIO 2 BANDAS COMERCIAL CON BANDEJA INCO (225 LBS) 8 PIES','ESCALERA ALUMINIO 2 BANDAS COMERCIAL CON BANDEJA INCO (225 LBS) 8 PIES','Unidad',14,12,860.6,1300,1,2,NULL,'2024-03-19 10:29:49','2024-03-19 10:29:49'),(537,'GRAPA AISLADA (LAA) PARA ALAMBRE ELECTRICO FIXE 3/4 PLG','','Caja 100 U.',16,12,7.5,12,1,5,NULL,'2024-03-19 10:32:35','2024-04-02 10:26:26'),(538,'GRAPA AISLADA (LAA) PARA ALAMBRE ELECTRICO FIXE 1 PLG','','Caja 100 U.',16,12,8.5,13,1,5,NULL,'2024-03-19 10:33:51','2024-04-02 10:26:22'),(539,'GRAPA PLASTICA REDONDA COLOMBIANA BLANCA N. 6 MEDIANA','GRAPA PLASTICA REDONDA COLOMBIANA BLANCA N. 6 MEDIANA','Bolsa 50 U.',16,12,8.5,13,1,5,NULL,'2024-03-19 10:35:11','2024-04-02 09:42:56'),(540,'GRAPA PLASTICA REDONDA COLOMBIANA BLANCA N 9 GRANDE ','GRAPA PLASTICA REDONDA COLOMBIANA BLANCA N 9 GRANDE ','Bolsa 50 U.',16,12,8.5,13,1,3,NULL,'2024-03-19 10:43:21','2024-04-02 09:51:14'),(541,'GRAPA PLASTICA REDONDA COLOMBIANA NEGRA N 9 GRANDE','GRAPA PLASTICA REDONDA COLOMBIANA NEGRA N 9 GRANDE','Bolsa 50 U. ',16,12,8.5,13,1,3,NULL,'2024-03-19 10:48:51','2024-04-02 09:51:26'),(542,'LLAVE DE CHORRO BRONCE CAIMAN PESADO 1/2 PLG COD. G03127','LLAVE DE CHORRO BRONCE CAIMAN PESADO 1/2 PLG COD. G03127','Unidad',28,12,29.5,48,1,5,NULL,'2024-03-19 10:50:27','2024-03-22 13:08:17'),(543,'LLAVE DE BOLA ZINC MARCA GRIFER 200 WOG ( G5786 ) 1/2 PLG ','LLAVE DE BOLA ZINC MARCA GRIFER 200 WOG ( G5786 ) 1/2 PLG ','Unidad',28,12,15.5,25,1,5,NULL,'2024-03-19 10:51:45','2024-03-22 13:31:05'),(544,'LLAVE DE BOLA ZINC MARCA GRIFER 200 WOG ( G5793 ) 3/4 PLG','LLAVE DE BOLA ZINC MARCA GRIFER 200 WOG ( G5793 ) 3/4 PLG','Unidad',28,12,20.5,33,1,5,NULL,'2024-03-19 10:52:43','2024-03-22 13:31:23'),(545,'LLAVE PARA MANDRIL MARCA CADENA 1/2 PLG - 13 MM. ','LLAVE PARA MANDRIL MARCA CADENA 1/2 PLG - 13 MM. ','Unidad',16,12,6.5,10,1,5,NULL,'2024-03-19 10:53:59','2024-03-19 10:53:59'),(546,'MANGUERA PARA JARDIN DURMAN 100 PIES','MANGUERA PARA JARDIN DURMAN 100 PIES','Unidad',16,12,94.5,135,1,5,NULL,'2024-03-19 10:54:53','2024-03-19 10:54:53'),(547,'PALA HALCON CABO MADERA LARGO PUNTA CUADRADA','PALA HALCON CABO MADERA LARGO PUNTA CUADRADA','Unidad',14,12,33,55,1,5,NULL,'2024-03-19 10:57:02','2024-03-19 10:57:02'),(548,'PASADOR PORTACANDADO DE BARRA MARCA CADENA P-804 COLOR DORADO ZINCADO 4 PLG','PASADOR PORTACANDADO DE BARRA MARCA CADENA P-804 COLOR DORADO ZINCADO 4 PLG','Unidad',25,12,10.5,18,1,5,NULL,'2024-03-19 10:58:23','2024-03-19 10:59:39'),(549,'PASADOR PORTACANDADO TIPO ALEMAN PLANO MARCA CADENA COLOR DORADO ZINCADO 4 PLG C15137 ','PASADOR PORTACANDADO TIPO ALEMAN PLANO MARCA CADENA COLOR DORADO ZINCADO 4 PLG C15137','Unidad',25,12,9,14,1,5,NULL,'2024-03-19 11:00:53','2024-03-19 11:00:53'),(550,'PEGAMENTO COLA BLANCA LOMBARD','PEGAMENTO COLA BLANCA LOMBARD','GalÃ³n ',24,12,100,140,1,5,NULL,'2024-03-19 11:02:11','2024-03-19 11:02:11'),(551,'PEGAMENTO PARA PVC DURMAN BOTE 1/32 PLG','PEGAMENTO PARA PVC DURMAN BOTE 1/32 PLG','Unidad',13,12,23.5,33.5,1,5,NULL,'2024-03-19 11:05:09','2024-03-19 11:05:09'),(552,'PEGAMENTO DURMAN WET BONDING 1/32','','Unidad',13,12,27,38.75,1,5,NULL,'2024-03-19 11:05:55','2024-04-02 18:56:15'),(553,'PEGAMENTO PARA PVC DURMAN WET BONDING BOTE 1/16','PEGAMENTO PARA PVC DURMAN WET BONDING BOTE 1/16','Unidad',13,12,43.75,62.5,1,5,NULL,'2024-03-19 11:07:08','2024-03-19 11:07:08'),(554,'PEGAMENTO PARA PVC DURMAN BOTE 1/8','PEGAMENTO PARA PVC DURMAN BOTE 1/8','Unidad',13,12,63.5,91,1,5,NULL,'2024-03-19 11:08:26','2024-03-19 11:08:26'),(555,'POXIPOL CAJA ROJA 14 ML COLOR TRANSPARENTE','','Unidad ',16,12,22.5,29.75,1,5,NULL,'2024-03-19 11:24:23','2024-04-03 14:17:37'),(556,'REDUCIDOR BUSHING GALVANIZADO 3/4 X 1/2 PLG ','REDUCIDOR BUSHING GALVANIZADO 3/4 X 1/2 PLG ','Unidad',28,12,4.35,6.5,1,10,NULL,'2024-03-19 11:25:28','2024-03-19 11:25:28'),(557,'REDUCIDOR BUSHING GALVANIZADO 1 1/4 X 1/2 PLG','REDUCIDOR BUSHING GALVANIZADO 1 1/4 X 1/2 PLG','Unidad',28,12,11.9,18.5,1,10,NULL,'2024-03-19 11:26:40','2024-03-19 11:26:40'),(558,'REDUCIDOR CAMPANA GALVANIZADO 3/4 X 1/2 PLG','REDUCIDOR CAMPANA GALVANIZADO 3/4 X 1/2 PLG','Unidad',28,12,5.5,8.5,1,10,NULL,'2024-03-19 11:28:02','2024-03-19 11:28:02'),(559,'REDUCIDOR CAMPANA GALVANIZADO 1 X 3/4 PLG ','REDUCIDOR CAMPANA GALVANIZADO 1 X 3/4 PLG ','Unidad',28,12,10,15.5,1,10,NULL,'2024-03-19 11:28:56','2024-03-19 11:28:56'),(560,'REPOSADERA CON REJILLA COFLEX PC-160 ABS-GRIS CUADRADA 2 PLG','REPOSADERA CON REJILLA COFLEX PC-160 ABS-GRIS CUADRADA 2 PLG','Unidad',16,12,19.5,28,1,5,NULL,'2024-03-19 11:34:43','2024-03-19 11:34:43'),(561,'REPOSADERA CON REJILLA COFLEX PC-161 ABS-CROMADO CUADRADA 2 PLG','REPOSADERA CON REJILLA COFLEX PC-161 ABS-CROMADO CUADRADA 2 PLG','Unidad',16,12,27.5,39,1,5,NULL,'2024-03-19 11:35:30','2024-03-19 11:35:30'),(562,'REPOSADERA CON REJILLA COFLEX PC-162 ABS-ACERO INOXIDABLE CALIBRE 18 CUADRADA 2 PLG','REPOSADERA CON REJILLA COFLEX PC-162 ABS-ACERO INOXIDABLE CALIBRE 18 CUADRADA 2 PLG','Unidad',16,12,47,68,1,5,NULL,'2024-03-19 11:36:26','2024-03-19 11:36:26'),(563,'REPOSADERA CON REJILLA COFLEX PC-152 ABS-ACERO INOXIDABLE CALIBRE 18 REDONDA 2 PLG','REPOSADERA CON REJILLA COFLEX PC-152 ABS-ACERO INOXIDABLE CALIBRE 18 REDONDA 2 PLG','Unidad',16,12,37.5,54,1,5,NULL,'2024-03-19 11:37:47','2024-03-19 11:37:47'),(564,'REPOSADERA CON REJILLA COFLEX PC-151 ABS-CROMADO REDONDA 2 PLG','REPOSADERA CON REJILLA COFLEX PC-151 ABS-CROMADO REDONDA 2 PLG','Unidad',16,12,26.5,38.5,1,5,NULL,'2024-03-19 11:42:41','2024-03-19 11:42:41'),(565,'REPOSADERA CON REJILLA COFLEX PC-150 ABS-GRIS REDONDA 2 PLG','REPOSADERA CON REJILLA COFLEX PC-150 ABS-GRIS REDONDA 2 PLG','Unidad',16,12,16.5,23.5,1,5,NULL,'2024-03-19 11:43:37','2024-03-19 11:43:37'),(566,'TAPA METALICA CIEGA REDONDA INDUMA COLOR GALVANIZADO CALIBRE 24 T7201-055 - T1206-0010','TAPA METALICA CIEGA REDONDA INDUMA COLOR GALVANIZADO CALIBRE 24 T7201-055 - T1206-0010','Unidad',29,12,3.25,4.5,1,10,NULL,'2024-03-19 11:44:50','2024-03-19 11:44:50'),(567,'TEE GALVANIZADA 1/2 PLG','TEE GALVANIZADA 1/2 PLG','Unidad',28,12,6,8.5,1,5,NULL,'2024-03-19 11:46:20','2024-03-19 11:46:20'),(568,'TEE GALVANIZADA 3/4 PLG','TEE GALVANIZADA 3/4 PLG','Unidad',28,12,10.25,14.5,1,5,NULL,'2024-03-19 11:47:14','2024-03-19 11:47:14'),(569,'UNION UNIVERSAL GALVANIZADA 1/2 PLG','UNION UNIVERSAL GALVANIZADA 1/2 PLG','Unidad',28,12,23,32.5,1,5,NULL,'2024-03-19 11:47:59','2024-03-19 11:47:59'),(570,'UNION UNIVERSAL GALVANIZADA 3/4 PLG','UNION UNIVERSAL GALVANIZADA 3/4 PLG','Unidad',28,12,31.2,44.5,1,5,NULL,'2024-03-19 11:48:51','2024-03-19 11:48:51'),(571,'UGC 4060 CEMENTOS PROGRESO Q81','','Saco',18,13,74.5,81,1,50,NULL,'2024-03-19 12:28:27','2024-03-26 10:21:49'),(572,'UGC 4060 CEMENTOS PROGRESO Q80','','Saco',18,13,74.5,80,1,50,NULL,'2024-03-19 12:29:39','2024-03-26 10:22:08'),(573,'CEMENTO ESTRUCTURAL 5800 Q88.50','','Saco',18,13,85.5,88.5,1,50,NULL,'2024-03-19 12:31:18','2024-04-02 12:24:29'),(574,'CEMENTO ESTRUCTURAL 5800 PROGRESO Q88.00','','Saco',18,13,85.5,88,1,50,NULL,'2024-03-19 12:32:08','2024-04-02 12:24:05'),(575,'LA MONTANA CEMENTOS PROGRESO Q70','','Saco',18,13,66,70,1,50,NULL,'2024-03-19 12:33:09','2024-04-02 10:24:39'),(576,'LA MONTANA CEMENTOS PROGRESO Q69','','Saco',18,13,66,69,1,50,NULL,'2024-03-19 12:33:54','2024-04-02 10:24:33'),(577,'PEGAMIX ORIGINAL','','Saco',31,13,25.5,28.5,1,25,NULL,'2024-03-19 12:39:02','2024-03-26 10:31:26'),(580,'X15116 VALVULA DE BOLA ZINC 200 WOG DE 1/2','','Unidad',28,14,13.2,20.5,1,10,NULL,'2024-03-22 18:00:08','2024-04-02 13:14:15'),(581,'X15120 VALVULA DE BOLA ZINC 200 WOG DE 3/4','','Unidad',28,14,18.05,28,1,10,NULL,'2024-03-22 18:01:09','2024-04-02 13:18:17'),(582,'X16416 VALVULA DE BOLA BRONCE 125 SWP 400 WOG DE 1/2','','Unidad',28,14,24.25,37.5,1,10,NULL,'2024-03-22 18:03:10','2024-04-02 13:18:58'),(583,'X16420 VALVULA DE BOLA BRONCE 125 SWP 400 WOG DE 3/4','','Unidad',28,14,41.75,64.25,1,10,NULL,'2024-03-22 18:05:18','2024-04-02 13:19:24'),(584,'X16124 VALVULA DE BOLA CROMADA 400 WOG DE 1 ','','Unidad',28,14,66.95,103,1,10,NULL,'2024-03-22 18:11:34','2024-04-02 13:15:51'),(585,'X21416 VALVULA DE COMPUERTA BRONCE TIPO PESADO 125 SWP 200 WOG DE 1/2','','Unidad',28,14,39.8,61.25,1,10,NULL,'2024-03-22 18:13:38','2024-04-02 13:20:02'),(586,'X21420 VALVULA DE COMPUERTA BRONCE TIPO PESADO 125 SWP 200 WOG DE 3/4','','Unidad',28,14,55.3,85.25,1,10,NULL,'2024-03-22 18:18:27','2024-04-02 13:24:39'),(587,'X21424 VALVULA DE COMPUERTA BRONCE TIPO PESADO 125 SWP 200 WOG DE 1','','Unidad',28,14,76.65,118,1,10,NULL,'2024-03-22 18:20:57','2024-04-02 13:25:09'),(588,'X41024 CHEQUE VERTICAL DE BRONCE CON CEDAZO 200 WOG DE 1 PLG - 102 MM','','Unidad',28,14,55.3,85.25,1,10,NULL,'2024-03-22 18:23:32','2024-04-02 13:43:05'),(589,'X36116 CHEQUE HORIZONTAL DE BRONCE TIPO PESADO 200 WOG DE 1/2','','Unidad',28,14,30.1,46.5,1,10,NULL,'2024-03-22 18:24:36','2024-04-02 13:27:41'),(590,'X36120 CHEQUE HORIZONTAL DE BRONCE TIPO PESADO 200 WOG DE 3/4','','Unidad',28,14,38.8,59.75,1,10,NULL,'2024-03-22 18:26:24','2024-04-02 13:33:22'),(591,'X36124 CHEQUE HORIZONTAL DE BRONCE TIPO PESADO 200 WOG DE 1','','Unidad',28,14,60.15,92.75,1,10,NULL,'2024-03-22 18:35:59','2024-04-02 13:33:48'),(592,'X81620 CONTRALLAVE PARA PARED 150 PSI DE 1/2 NPT X 3/8 OD','','Unidad',28,14,20.4,31.5,1,5,NULL,'2024-03-23 10:49:16','2024-04-02 13:47:54'),(593,'X81622 CONTRALLAVE PARA PARED 150 PSI DE 1/2 NPT X 1/2 NPT','','Unidad',28,14,20.4,31.5,1,5,NULL,'2024-03-23 10:52:50','2024-04-02 15:54:35'),(594,'X81630 CONTRALLAVE PARA PISO 150 PSI DE 1/2 NPT X 3/8 OD','','Unidad',28,14,20.4,31.5,1,5,NULL,'2024-03-23 10:57:02','2024-04-02 15:55:05'),(595,'X81-632 CONTRALLAVE PARA PISO 150 PSI DE 1/2 NPT X 1/2 NPT ','','Unidad',28,14,20.4,31.5,1,5,NULL,'2024-03-23 10:57:40','2024-04-02 10:12:45'),(596,'X71116 FLOTE PARA TANQUE DE BRONCE CON PELOTA DE PVC DE 1/2','','Unidad',28,14,45.6,71,1,5,NULL,'2024-03-23 10:59:18','2024-04-02 13:46:42'),(597,'X71120 FLOTE PARA TANQUE DE BRONCE CON PELOTA DE PVC DE 3/4','','Unidad',28,14,55.3,85.25,1,5,NULL,'2024-03-23 11:01:20','2024-04-02 13:47:06'),(598,'X71124 FLOTE PARA TANQUE DE BRONCE CON PELOTA DE PVC DE 1','','Unidad',28,14,77.6,119.5,1,5,NULL,'2024-03-23 11:04:03','2024-04-02 13:47:24'),(599,'M12992 MANGUERA ABASTO ACERO INOX TUERCAS DE LATON 1/2X3/8X20 PLG','','Unidad',28,14,16.5,25.5,1,10,NULL,'2024-03-23 11:07:05','2024-04-02 12:06:17'),(600,'M12996 MANGUERA ABASTO ACERO INOX TUERCAS DE LATON 7/8X3/8X20 PLG ','','Unidad',28,14,16.5,25.5,1,10,NULL,'2024-03-23 11:08:16','2024-04-02 12:07:12'),(601,'M12998 MANGUERA ABASTO DE ACERO INOX TUERCA DE LATON 7/8X1/2X20 PLG ','','Unidad',28,14,16.5,25.5,1,10,NULL,'2024-03-23 11:09:00','2024-04-02 12:07:42'),(602,'X16816 LLAVE PARA DUCHA DE GLOBO, BRONCE DE 1/2 C/MANESILLA TIPO ACRILICA ','','Unidad',28,14,72.75,112,1,5,NULL,'2024-03-23 11:10:30','2024-04-02 13:17:34'),(603,'X61320 LLAVE P/DUCHA BRONCE MANESILLA CROMADA','GRANDE DE 1/2 ','Unidad',28,14,89.25,137.5,1,5,NULL,'2024-03-23 11:14:14','2024-04-02 13:46:16'),(604,'DESTIPOP 23110 DESAGUE P/LAVAMANOS C/SIFON FLEXIBLE BLANCO TIPO P','','Unidad',28,14,15.55,24,1,5,NULL,'2024-03-23 11:16:07','2024-04-02 11:17:14'),(605,'REPAP5 REPOSADERA DE ALUMINIO CUADRADA 5 X 5 NACIONAL','','Unidad',16,14,25.7,39.75,1,5,NULL,'2024-03-23 11:24:32','2024-04-02 12:18:31'),(606,'REPAP4 REPOSADERA DE ALUMINIO CUADRADA 4 X 4 NACIONAL','','Unidad',16,14,14.1,21.75,1,5,NULL,'2024-03-23 11:26:16','2024-04-02 12:18:01'),(607,'REPAP3 REPOSADERA DE ALUMINIO CUADRADA DE 3 X 3 NACIONAL','','Unidad',16,14,12.15,18.75,1,5,NULL,'2024-03-23 11:36:15','2024-04-02 12:15:30'),(608,'X54130 LLAVE DE CHORRO BRONCE CON ROSCA DE 1/2 PESADO ','','Unidad',28,14,33,51,1,5,NULL,'2024-03-23 11:38:52','2024-04-02 13:44:36'),(609,'X54140 LLAVE DE CHORRO BRONCE CON ROSCA DE 1/2 SUPER PESADA','','Unidad',28,14,39.8,61.25,1,5,NULL,'2024-03-23 11:40:42','2024-04-02 13:43:56'),(610,'X54150 LLAVE DE CHORRO BRONCE, CON ROSCA DE 1/2 JUMBO ','','Unidad',28,14,41.75,64.25,1,5,NULL,'2024-03-23 11:45:44','2024-04-02 13:44:16'),(611,'VALVULA DE BOLA LISA DE PVC 200 PSI MANECILLA MARIPOSA DE 1/2','','Unidad',13,14,4.5,7,1,5,NULL,'2024-03-23 11:48:25','2024-04-02 12:21:28'),(612,'VALVULA DE BOLA LISA DE PVC 200 PSI MANECILLA MARIPOSA DE 3/4','','Unidad',13,14,7.2,11.25,1,5,NULL,'2024-03-23 11:50:18','2024-04-02 13:10:32'),(613,'VALVULA DE BOLA LISA DE PVC 200 PSI MANECILLA MARIPOSA DE 1','','Unidad',13,14,11.1,17.25,1,5,NULL,'2024-03-23 11:54:15','2024-04-02 12:21:07'),(614,'VALVULA DE BOLA LISA DE PVC 200 PSI MANECILLA MARIPOSA DE 1 1/4','','Unidad',13,14,17.5,27,1,5,NULL,'2024-03-23 12:05:11','2024-04-02 12:20:43'),(615,'VALVULA DE BOLA LISA DE PVC 200 PSI MANECILLA MARIPOSA DE 1 1/2','','Unidad',13,14,23.3,36,1,5,NULL,'2024-03-23 12:06:55','2024-04-02 12:20:26'),(616,'VALVULA DE BOLA LISA DE PVC 200 PSI MENECILLA MARIPOSA DE 2','','Unidad',13,14,34.95,54,1,5,NULL,'2024-03-23 12:08:41','2024-04-02 13:11:26'),(617,'K22016 UNION REPARACION LISA DE PVC 150 PSI DE 1/2','','Unidad',13,14,10.7,16.5,1,5,NULL,'2024-03-23 12:33:32','2024-04-02 12:06:31'),(618,'K22020 UNION REPARACION LISA DE PVC 150 PSI DE 3/4','','Unidad',13,14,17.5,27,1,5,NULL,'2024-03-23 12:35:21','2024-04-02 11:20:10'),(619,'K22024 UNION REPARACION LISA DE PVC 150 PSI DE 1','','Unidad',13,14,24.25,37.5,1,5,NULL,'2024-03-23 12:36:34','2024-04-02 11:20:45'),(620,'K22028 UNION REPARACION LISA DE PVC 150 PSI DE 1 1/4','','Unidad',13,14,33.95,52.25,1,5,NULL,'2024-03-23 12:39:11','2024-04-02 11:21:05'),(621,'K22032 UNION REPARACION LISA DE PVC 150 PSI DE 1 1/2','','Unidad',13,14,44.65,68.75,1,5,NULL,'2024-03-23 12:41:19','2024-04-02 11:21:26'),(622,'TEF150 TEFLON DE 1/2 PLG X 7 MTS X 0.075 MM X 0.30 G/CM3 ALTA TENSION','','Unidad',16,14,1,2,1,10,NULL,'2024-03-23 12:45:44','2024-04-02 12:19:36'),(623,'TEF175 TEFLON DE 3/4 PLG  X 7 MTS X 0.075 MM X 0.30 G/CM3 ALTA TENSION','','Unidad',16,14,1.3,2.5,1,10,NULL,'2024-03-23 13:00:28','2024-04-02 12:19:53'),(624,'NIP4101 NIPLE DE 1/2 X CORRIDO','','Unidad',28,14,1.95,3,1,5,NULL,'2024-03-23 13:03:50','2024-04-02 12:08:05'),(625,'NIP4103 NIPLE DE 1/2 X 2','','Unidad',28,14,2.95,4.75,1,5,NULL,'2024-03-23 13:07:08','2024-04-02 12:08:31'),(626,'NIP4105 NIPLE DE 1/2 X 3','','Unidad',28,14,3.9,6,1,5,NULL,'2024-03-23 13:09:49','2024-04-02 12:08:53'),(627,'NIP4107 NIPLE DE 1/2 X 4','','Unidad',28,14,4.85,7.5,1,5,NULL,'2024-03-23 13:11:16','2024-04-02 12:09:10'),(628,'NIP4109 NIPLE DE 1/2 X 6 ','','Unidad',28,14,7.1,11,1,5,NULL,'2024-03-23 13:12:34','2024-04-02 12:09:38'),(629,'NIP4111 NIPLE DE 1/2 X 8','','Unidad',28,14,9.35,14.5,1,5,NULL,'2024-03-23 14:10:51','2024-04-02 12:09:52'),(630,'NIP4113 NIPLE DE 1/2 X 10','','Unidad',28,14,11.1,17.25,1,5,NULL,'2024-03-23 15:33:13','2024-04-02 12:10:08'),(631,'NIP4115 NIPLE DE 1/2 X 12','','Unidad',28,14,13.4,20.75,1,5,NULL,'2024-03-23 15:34:45','2024-04-02 12:10:26'),(632,'NIP4117 NIPLE DE 1/2 X 14','','Unidad',28,14,15.65,24.25,1,5,NULL,'2024-03-23 15:36:10','2024-04-02 12:10:49'),(633,'NIP4119 NIPLE DE 1/2 X 16','','Unidad',28,14,17.6,27.25,1,5,NULL,'2024-03-23 15:37:35','2024-04-02 12:11:05'),(634,'NIP4121 NIPLE DE 1/2 X 18','','Unidad',28,14,18.95,29.25,1,5,NULL,'2024-03-23 15:38:44','2024-04-02 12:11:21'),(635,'NIP4123 NIPLE DE 1/2 X 20','','Unidad',28,14,21.65,33.5,1,5,NULL,'2024-03-23 15:40:09','2024-04-02 12:11:38'),(636,'NIP4124 NIPLE DE 1/2 X 22','','Unidad',28,14,22.15,34.25,1,5,NULL,'2024-03-23 15:41:13','2024-04-02 12:11:55'),(637,'NIP4129 NIPLE DE 1/2 X 30','','Unidad',28,14,27.65,42.75,1,5,NULL,'2024-03-23 15:43:17','2024-04-02 12:12:29'),(638,'NIP4132 NIPLE DE 1/2 X 36 ','','Unidad',28,14,30.1,46.5,1,5,NULL,'2024-03-23 15:44:29','2024-04-02 12:12:49'),(639,'NIP4133 NIPLE DE 1/2 X 1.00 MTS','','Unidad',28,14,31.05,48,1,5,NULL,'2024-03-23 15:45:56','2024-04-02 12:13:08'),(640,'NIP4135 NIPLE DE 1/2 X 1.20 MTS','','Unidad',28,14,33,51,1,5,NULL,'2024-03-23 15:55:52','2024-04-02 12:13:31'),(641,'NIP4139 NIPLE DE 1/2 X 1.50 MTS','','Unidad',28,14,39.8,61.25,1,5,NULL,'2024-03-23 15:56:56','2024-04-02 12:13:51'),(642,'ACS1004Y CODO DE 1/2 X 90 GALV','','Unidad',28,14,3.35,5.25,1,10,NULL,'2024-03-23 15:59:30','2024-04-02 11:14:48'),(643,'ACS1304Y COPLA DE 1/2 GALV','','Unidad',28,14,3.05,4.75,1,10,NULL,'2024-03-23 16:01:55','2024-04-02 11:13:34'),(644,'ACS1504Y TAPON HEMBRA DE 1/2 GALV','','Unidad',28,14,2.5,4,1,10,NULL,'2024-03-23 16:03:20','2024-04-02 11:13:53'),(645,'ACS1604Y TAPON MACHO DE 1/2 GALV','','Unidad',28,14,1.75,2.75,1,10,NULL,'2024-03-23 16:05:11','2024-04-02 11:14:32'),(646,'ACS15070 TAPON HEMBRA DE 1 1/4 GALV','','Unidad',28,14,11.25,17.5,1,5,NULL,'2024-03-23 16:06:43','2024-04-02 11:14:15'),(647,'BISDC300 BISAGRA DORADA PESADA CON TORNILLO 3 X 3','','Par',25,14,6.4,9.75,1,10,NULL,'2024-03-23 16:08:51','2024-04-02 11:15:22'),(648,'FAM9449 SAPITO PARA SANITARIO ECONOFLAP AMARILLO','','Unidad',16,14,6.8,10.5,1,5,NULL,'2024-03-23 16:10:20','2024-04-02 11:18:59'),(649,'CEDAZO GALLINERO 1PLGX6PIESX1YDA ','','Yarda',27,14,10.16,15,1,50,NULL,'2024-03-23 16:16:31','2024-03-26 11:00:30'),(650,'TRATAMIENTO PARA MADERA (PENTA)','','GalÃ³n',33,15,65,80,1,5,NULL,'2024-03-26 10:41:38','2024-04-03 11:58:43'),(651,'BLOCK FFACSA SELLO NEGRO 14','','Unidad',20,16,4.9,5.2,1,1000,NULL,'2024-03-26 10:52:03','2024-03-26 10:52:03'),(652,'FLETE ZONA 5, 8, 9, 10, 11, 12','','Flete',34,17,25,25,1,1,NULL,'2024-03-26 10:55:08','2024-04-02 11:39:29'),(653,'CODO 90 DE 1/2 CPVC GERFOR','','Unidad',13,5,2.03,3.25,1,25,NULL,'2024-03-26 17:24:09','2024-03-26 17:24:35'),(654,'12488 BOLSA CON 2 CARBONES DE REPUESTO PARA ESMA-9N4, TRUPER','12488 BOLSA CON 2 CARBONES DE REPUESTO PARA ESMA-9N4, TRUPER','Unidad',16,7,96.5,138,1,5,NULL,'2024-03-27 13:27:51','2024-04-01 17:19:52'),(655,'12665 BOLSA CON 2 CARBONES DE REPUESTO PARA GENERADORES GRUPO 6, TRUPER','12665 BOLSA CON 2 CARBONES DE REPUESTO PARA GENERADORES GRUPO 6, TRUPER','Unidad',16,7,20,28.75,1,5,NULL,'2024-03-27 13:32:43','2024-04-01 17:20:32'),(656,'14674 BOLSA CON 2 CARBONES DE REPUESTO PARA PULA-7N, TRUPER','','Unidad',16,7,29.5,42.25,1,5,NULL,'2024-03-27 13:35:04','2024-04-02 09:34:24'),(657,'15029 BOLSA CON 2 CARBONES DE REPUESTO PARA SICI-7-1/4A3, TRUPER','','Unidad',16,7,10,14.5,1,5,NULL,'2024-03-27 13:39:29','2024-04-02 09:35:04'),(658,'17960 REMACHADORA PROFESIONAL 10 PLG, TRUPER ','','Unidad',14,7,75.65,108.25,1,5,NULL,'2024-03-27 13:58:29','2024-04-02 09:36:17'),(659,'22850 REMACHADORA 10 PLG, PRETUL','','Unidad',14,7,37.4,55,1,5,NULL,'2024-03-27 14:02:12','2024-04-02 09:42:30'),(660,'23041 BLISTER 2 TERMINALES PLOMO POSTE SUPERIOR P/BATERIA, PRETUL','','Unidad',16,7,17.5,25,1,5,NULL,'2024-03-27 14:08:09','2024-04-02 09:43:05'),(661,'23042 BLISTER 2 TERMINALES LATON POSTE SUPERIOR P/BATERIA, PRETUL ','','Unidad',16,7,32,45.75,1,5,NULL,'2024-03-27 14:30:02','2024-04-02 09:43:58'),(662,'28158 PINZA DE PUNTA Y CORTE 6 PLG MANGO DE VINIL, A GRANEL, PRETUL','','Unidad',14,7,16.2,23.25,1,5,NULL,'2024-03-27 14:48:07','2024-04-02 09:45:03'),(663,'28574 TIRALINEAS 15 M (50 FT) PLASTICO CON GIS, PRETUL ','','Unidad',16,7,31.95,45.75,1,5,NULL,'2024-03-27 14:56:56','2024-04-02 09:45:49'),(664,'46181 MULTICONTACTO 16 AWG DOMESTICO 4 ENTRADAS, VOLTECK','','Unidad',29,7,19.45,29,1,5,NULL,'2024-03-27 15:03:35','2024-04-02 09:46:35'),(665,'46253 BOLSA CON 2 ADAPTADORES 3 A 2 NARANJAS, VOLTECK','','Unidad',29,7,9.15,13.25,1,5,NULL,'2024-03-27 15:57:07','2024-04-02 09:47:24'),(666,'46520 PORTALAMPARA 4 PLG DE BAQUELITA, VOLTECK','','Unidad',29,7,5,7.5,1,10,NULL,'2024-03-27 17:08:07','2024-04-02 09:47:59'),(667,'46804 MULTICONTACTO TRIPLE ATERRIZADO, TIPO T REFORZADO, VOLTECK','','Unidad',29,7,13.1,18.75,1,5,NULL,'2024-03-27 17:11:01','2024-04-02 09:48:48'),(668,'46920 ABRAZADERA 1/2 PLG TIPO UNA PARA TUBO, VOLTECK','','Unidad',16,7,0.4,1,1,10,NULL,'2024-03-27 17:40:39','2024-04-02 10:21:55'),(669,'46921 ABRAZADERA 3/4 PLG TIPO UNA PARA TUBO, VOLTECK','','Unidad',16,7,0.5,1.5,1,10,NULL,'2024-03-27 17:47:43','2024-04-02 10:21:48'),(670,'46923 ABRAZADERA 1/2 PLG TIPO OMEGA PARA TUBO, VOLTECK','','Unidad',16,7,0.45,1,1,10,NULL,'2024-03-27 17:50:28','2024-04-02 09:51:16'),(671,'46924 ABRAZADERA 3/4 PLG TIPO OMEGA PARA TUBO, VOLTECK','','Unidad',16,7,0.55,1.5,1,10,NULL,'2024-03-27 18:07:41','2024-04-02 09:51:48'),(672,'47906 JUEGO DE 4 REPISAS ESQUINERAS DE VIDRIO ','','Juego',16,7,210.5,302,1,5,NULL,'2024-03-27 18:10:52','2024-03-27 18:10:52'),(673,'Varilla G40 1/4 LISA (ORIGINAL) AG','','Varilla',12,10,9.75,10.88,1,750,NULL,'2024-03-31 22:02:45','2024-04-01 10:55:33'),(674,'VARILLA 1/2 COMERCIAL 11MM AG','','Varilla',12,10,40.5,45.59,1,350,NULL,'2024-03-31 22:21:43','2024-04-01 11:05:05'),(675,'VARILLA G40 1/2 (ORIGINAL) AG','','Varilla',12,10,53.3,57.59,1,350,NULL,'2024-03-31 22:27:45','2024-04-01 10:55:43'),(676,'VARILLA 1/4 LISA COMERCIAL (7/32) AG','','Varilla',12,10,8.22,9.75,1,600,NULL,'2024-03-31 22:52:07','2024-04-01 11:02:31'),(677,'QUINTAL ALAMBRE DE AMARRE CALIBRE 16 AG','','Quintal',12,10,456,498.5,1,15,NULL,'2024-03-31 22:54:16','2024-03-31 22:54:16'),(678,'SACO MAYACEM UG 4200','','Saco',18,13,66,69,1,100,NULL,'2024-03-31 22:56:21','2024-03-31 22:56:21'),(679,'ALAMBRE DE AMARRE CALIBRE 16 AG','','1/2 QQ',12,10,230,260,1,5,NULL,'2024-03-31 23:03:54','2024-03-31 23:08:27'),(680,'VARILLA 3/8 COMERCIAL 8.5 MM AG','','Varilla',12,10,24.12,25.75,1,650,NULL,'2024-03-31 23:50:08','2024-04-01 11:03:00'),(681,'CHURRASQUERA MEDIANA','','Unidad',35,18,160,245,1,5,NULL,'2024-04-01 09:32:40','2024-04-01 09:32:40'),(682,'CHURRASQUERA PEQUENA','','Unidad',35,18,110,175,1,5,NULL,'2024-04-01 09:34:03','2024-04-02 10:06:05'),(683,'CHIMENEAS ALUMINIO 5 PLG','3 TUBOS Y UN SOMBRERO','Unidad',35,18,60,75,1,5,NULL,'2024-04-01 09:35:40','2024-04-01 09:37:13'),(684,'CODO PARA CHIMENEA 5 PLG','','Unidad',35,18,16,25,1,5,NULL,'2024-04-01 09:36:57','2024-04-01 09:37:22'),(685,'100568 COPLA 3/4','','Unidad',13,5,0.78,1.5,1,50,NULL,'2024-04-01 10:24:55','2024-04-02 10:25:23'),(686,'100569 COPLA DE 1 ','','Unidad',13,5,1.24,2.25,1,50,NULL,'2024-04-01 10:26:24','2024-04-02 10:20:18'),(687,'100517 ADAPTADOR HEMBRA 1/2X1/2','','Unidad',13,5,0.83,1.5,1,50,NULL,'2024-04-01 10:27:15','2024-04-02 10:14:33'),(688,'100519 ADAPTADOR HEMBRA 3/4X3/4','','Unidad',13,5,1.76,3,1,50,NULL,'2024-04-01 10:28:01','2024-04-02 10:14:40'),(689,'100518 ADAPTADOR HEMBRA 1X1','','Unidad',13,5,1.76,3,1,50,NULL,'2024-04-01 10:28:49','2024-04-02 10:14:48'),(690,'100520 ADAPTADOR MACHO 1/2 ','','Unidad',13,5,0.5,1,1,50,NULL,'2024-04-01 10:30:33','2024-04-01 13:07:59'),(691,'100521 ADAPTADOR MACHO 3/4 ','','Unidad',13,5,0.83,1.5,1,50,NULL,'2024-04-01 10:31:17','2024-04-01 13:08:06'),(692,'100522 ADAPTADOR MACHO DE 1','','Unidad',13,5,1.93,3,1,25,NULL,'2024-04-01 10:32:19','2024-04-01 13:08:14'),(693,'102675 CODO ROSCADO 1/2','','Unidad',13,5,1.08,2.25,1,50,NULL,'2024-04-01 10:33:00','2024-04-01 17:19:14'),(694,'200885 CODO ROSCADO 90 3/4','','Unidad',13,5,2.52,4,1,50,NULL,'2024-04-01 10:34:19','2024-04-02 09:40:45'),(695,'200886 CODO ROSCADO 90 DE 1','','Unidad',13,5,4.44,7,1,25,NULL,'2024-04-01 10:35:00','2024-04-02 09:41:28'),(696,'100549 TAPON HEMBRA CON ROSCA 1/2','','Unidad',13,5,2.3,3.75,1,50,NULL,'2024-04-01 10:35:58','2024-04-01 13:08:23'),(697,'102446 TAPON HEMBRA CON ROSCA 3/4','','Unidad',13,5,3.61,5.75,1,50,NULL,'2024-04-01 10:36:34','2024-04-01 13:09:15'),(698,'100639 TAPON HEMBRA CON ROSCA DE 1','','Unidad',13,5,4.22,6.75,1,25,NULL,'2024-04-01 10:37:08','2024-04-01 13:08:58'),(699,'200829 TAPON MACHO CON ROSCA 1/2 ','','Unidad',13,5,4.48,7,1,50,NULL,'2024-04-01 10:38:08','2024-04-02 09:39:16'),(700,'200830 TAPON MACHO CON ROSCA 3/4 ','','Unidad',13,5,4.81,7.25,1,50,NULL,'2024-04-01 10:38:53','2024-04-02 09:40:07'),(701,'200441 TAPON MACHO CON ROSCA DE 1','','Unidad',13,5,7.86,12,1,25,NULL,'2024-04-01 10:39:46','2024-04-02 09:37:39'),(702,'102585 TEE CON ROSCA 1/2 ','','Unidad',13,5,1.99,3.25,1,25,NULL,'2024-04-01 10:40:38','2024-04-01 17:19:02'),(703,'200445 TEE CON ROSCA DE 3/4 ','','Unidad',13,5,4.35,7,1,25,NULL,'2024-04-01 10:41:27','2024-04-02 09:38:08'),(704,'200446 TEE CON ROSCA DE 1','','Unidad',13,5,7.86,12,1,25,NULL,'2024-04-01 10:42:06','2024-04-02 09:38:40'),(705,'200112 REDUCIDOR BUSHING ROSCADO 3/4X1/2 ','','Unidad',13,5,2.74,4.5,1,25,NULL,'2024-04-01 10:43:19','2024-04-01 11:42:12'),(706,'102461 ADAPTADOR HEMBRA REDUCIDO 3/4X1/2 ','','Unidad',13,5,3.51,5.5,1,25,NULL,'2024-04-01 10:44:05','2024-04-01 17:18:37'),(707,'VARILLA 3/8 COMERCIAL 8 MM AG','','Varilla',12,10,21.2,23.25,1,650,NULL,'2024-04-01 10:53:19','2024-04-01 10:53:19'),(708,'BLOCK 14X19X39 S NEGRO FFACSA','','Unidad',20,16,4.9,5.15,1,1000,NULL,'2024-04-01 13:25:33','2024-04-01 13:25:33'),(709,'BLOCK 14 S VERDE FFACSA','','Unidad',20,16,5.4,5.6,1,1000,NULL,'2024-04-01 13:29:23','2024-04-01 13:29:23'),(710,'BLOCK 14 S ROJO FFACSA','','Unidad',20,16,6,6.15,1,1000,NULL,'2024-04-01 13:30:09','2024-04-01 13:30:09'),(711,'100562 TEE REDUCTORA LISA 3/4X1/2','','Unidad',13,5,2.09,3.5,1,25,NULL,'2024-04-01 15:35:42','2024-04-01 15:35:42'),(712,'100563 TEE REDUCTORA LISA 1X1/2','','Unidad',13,5,4.66,7.5,1,25,NULL,'2024-04-01 15:37:38','2024-04-01 15:37:38'),(713,'100564 TEE REDUCIDA LISA 1X3/4','','Unidad',13,5,4.66,7.5,1,25,NULL,'2024-04-01 15:38:33','2024-04-01 15:38:33'),(714,'200450 TEE REDUCIDA LISA 1 1/4X3/4','','Unidad',13,5,7.62,12,1,25,NULL,'2024-04-01 15:39:36','2024-04-01 15:39:36'),(715,'100526 REDUCIDOR BUSHING 3/4X1/2','','Unidad',13,5,0.78,1.5,1,25,NULL,'2024-04-01 15:45:56','2024-04-01 15:45:56'),(716,'100527 REDUCIDOR BUSHING 1X1/2','','Unidad',13,5,1.5,2.75,1,25,NULL,'2024-04-01 15:47:15','2024-04-01 15:47:15'),(717,'100528 REDUCIDOR BUSHING 1X3/4','','Unidad',13,5,1.5,2.75,1,25,NULL,'2024-04-01 15:48:01','2024-04-01 15:48:01'),(718,'200469 UNION DE COMPRESION 1/2 ','','Unidad',13,5,10.25,15.5,1,10,NULL,'2024-04-01 15:49:21','2024-04-01 15:49:21'),(719,'200470 UNION DE COMPRESION 3/4','','Unidad',13,5,21.41,33,1,10,NULL,'2024-04-01 15:50:15','2024-04-01 15:50:15'),(720,'200471 UNION DE COMPRESION DE 1','','Unidad',13,5,28.02,43,1,10,NULL,'2024-04-01 15:51:24','2024-04-01 15:51:24'),(721,'100575 UNION UNIVERSAL LISA 1/2','','Unidad',13,5,9.25,14.25,1,20,NULL,'2024-04-01 15:52:32','2024-04-01 15:52:32'),(722,'100590 UNION UNIVERSAL LISA 3/4','','Unidad',13,5,10.52,16.25,1,20,NULL,'2024-04-01 15:53:22','2024-04-01 15:53:22'),(723,'100600 UNION UNIUVERSAL LISA 1','','Unidad',13,5,14.7,22.75,1,20,NULL,'2024-04-01 15:54:10','2024-04-01 15:54:10'),(724,'102656 YEE DRENAJE 3 ','','Unidad',13,5,13.55,21,1,25,NULL,'2024-04-01 16:10:52','2024-04-01 16:10:52'),(725,'102575 YEE DRENAJE 4','','Unidad',13,5,24.44,37.75,1,25,NULL,'2024-04-01 16:13:54','2024-04-01 16:13:54'),(726,'102636 COPLA DUCTO NARANJA 3/4','','Unidad',13,5,0.67,1.5,1,50,NULL,'2024-04-01 16:15:06','2024-04-01 16:15:06'),(727,'100825 COPLA DUCTO GRIS 3/4 ','','Unidad',13,5,0.67,1.5,1,50,NULL,'2024-04-01 16:22:48','2024-04-01 16:22:48'),(728,'100439 CURVA DUCTO 90 GRIS 3/4','','Unidad',13,5,1.39,2.5,1,50,NULL,'2024-04-01 16:24:08','2024-04-01 16:24:08'),(729,'100789 ADAPTADOR MACHO CPVC 1/2','','Unidad',13,5,2.84,4,1,50,NULL,'2024-04-01 16:27:01','2024-04-01 16:27:01'),(730,'100809 ADAPTADOR MACHO CPVC 3/4','','Unidad',13,5,4.35,6.5,1,50,NULL,'2024-04-01 16:28:08','2024-04-01 16:28:08'),(731,'100711 CODO 90 CPVC 1/2 ','','Unidad',13,5,2.03,3.5,1,50,NULL,'2024-04-01 16:32:51','2024-04-01 16:32:51'),(732,'100811 CODO 90 CPVC 3/4','','Unidad',13,5,4.99,7.75,1,25,NULL,'2024-04-01 16:45:08','2024-04-01 16:45:08'),(733,'100832 CODO 45 CPVC 1/2','','Unidad',13,5,2.65,4.25,1,25,NULL,'2024-04-01 16:46:25','2024-04-01 16:46:25'),(734,'100790 TEE CPVC 3/4 ','','Unidad',13,5,5.57,8.75,1,25,NULL,'2024-04-01 16:47:23','2024-04-01 16:47:23'),(735,'10087 REDUCIDOR BUSHING CPVC 3/4X1/2','','Unidad',13,5,2.09,3.5,1,25,NULL,'2024-04-01 16:50:03','2024-04-01 16:50:03'),(736,'200168 REDUCIDOR BUSHIN CPVC 1/2X/3/4','','Unidad',13,5,7.8,11.25,1,25,NULL,'2024-04-01 16:52:12','2024-04-01 16:52:12'),(737,'100827 REDUCIDOR BUSHING CPVC 3/4X1/2','','Unidad',13,5,2.09,3.25,1,25,NULL,'2024-04-02 08:50:11','2024-04-02 08:50:11'),(738,'100834 CODO 45 CPVC 3/4','','Unidad',13,5,6.56,9.5,1,25,NULL,'2024-04-02 08:56:30','2024-04-02 08:56:30'),(739,'100712 COPLA CPVC 1/2','','Unidad',13,5,2.73,4,1,25,NULL,'2024-04-02 08:59:30','2024-04-02 08:59:30'),(740,'100833 COPLA CPVC 3/4','','Unidad',13,5,2.9,4,1,25,NULL,'2024-04-02 09:02:26','2024-04-02 09:02:26'),(741,'100791 TAPON HEMBRA CPVC 1/2','','Unidad',13,5,2.84,4,1,25,NULL,'2024-04-02 09:03:07','2024-04-02 09:03:07'),(742,'100895 TAPON HEMBRA CPVC 3/4','','Unidad',13,5,3.19,4.5,1,25,NULL,'2024-04-02 09:04:45','2024-04-02 09:04:45'),(743,'100709 TEE CPVC 1/2','','Unidad',13,5,3.4,5,1,25,NULL,'2024-04-02 09:05:27','2024-04-02 09:05:27'),(744,'PEGAMIX ORIGINAL Q28','','Unidad',31,13,25.5,28,1,100,NULL,'2024-04-02 09:22:01','2024-04-02 09:22:01'),(745,'CAL HIDRATADA HORCALSA ','','Saco',18,4,32,34.75,1,50,NULL,'2024-04-02 12:22:32','2024-04-02 12:22:32'),(746,'CEMENTO CEMPA 4060','','Saco',18,13,66,69,1,130,NULL,'2024-04-02 12:26:02','2024-04-02 12:26:02'),(747,'CEMENTO TOLTECA 4060','','Saco',18,13,73,77,1,200,NULL,'2024-04-02 12:27:34','2024-04-02 12:27:34'),(748,'REPELLO GRIS CEMIX','','Saco',31,13,45,48,1,50,NULL,'2024-04-02 12:28:48','2024-04-02 12:28:48'),(749,'BLANQUEADO FINO CEMIX ','','Saco',31,13,65,68.75,1,50,NULL,'2024-04-02 12:30:47','2024-04-02 12:30:47'),(750,'BLANQUEADO EXTRA LISO CEMIX','','Saco',31,13,72,75.5,1,50,NULL,'2024-04-02 12:31:50','2024-04-02 12:31:50'),(751,'MONOCAPA GRIS MIXTO LISTO 40 KG','','Saco',31,13,44.75,48.25,1,50,NULL,'2024-04-02 12:33:59','2024-04-02 12:33:59'),(752,'MONOCAPA BLANCO ANTIGUO MIXTO LISTO ','','Saco',31,13,65.5,69,1,50,NULL,'2024-04-02 12:34:59','2024-04-02 12:37:46'),(753,'MONOCAPA EXTRA LISO MIXTO LISTO ','','Saco',31,13,73,78,1,50,NULL,'2024-04-02 12:36:49','2024-04-02 12:36:49'),(754,'VARILLA 1/2 G40 LEGITIMO AG','','Varilla',12,10,53.28,57.25,1,450,NULL,'2024-04-02 13:06:08','2024-04-02 14:06:15'),(755,'VARILLA 3/8 G40 LEGITIMO AG','','Varilla',12,10,30.02,32.25,1,1300,NULL,'2024-04-02 13:08:32','2024-04-02 14:06:36'),(756,'VARILLA 5/8 G40 (LEGITIMO)  AG','','Varilla',12,10,83.19,89.65,1,160,NULL,'2024-04-02 13:50:11','2024-04-02 14:05:54'),(757,'RENTA MENSUAL DOCENA TABLA 2.5MX25CMS','','Docena ',35,17,50,85,1,25,NULL,'2024-04-02 14:13:50','2024-04-02 14:13:50'),(758,'RENTA MENSUAL DOCENA PARAL 3X3 2.50M','','Docena ',35,17,50,85,1,25,NULL,'2024-04-02 14:14:41','2024-04-02 14:14:41'),(759,'RENTA PUNTAL TELESCOPICO 2M HASTA 3.50M','','Docena ',35,17,100,140,1,15,NULL,'2024-04-02 14:16:39','2024-04-02 14:16:39'),(760,'RENTA SEMANAL ANDAMIOS 1.5MX1.5M','','Unidad',35,17,50,85,1,25,NULL,'2024-04-02 14:19:35','2024-04-02 14:19:35'),(761,'TUBO CPVC 1/2','','Unidad',13,5,58,59.75,1,50,NULL,'2024-04-02 18:49:01','2024-04-02 18:49:01'),(762,'AFLOJATODO WD40 8 OZ','','Unidad',16,12,36.56,56.5,1,5,NULL,'2024-04-03 11:00:08','2024-04-03 11:00:08'),(763,'TUBERIA PROCESO LIVIANO NEGRO CERTIFICACION A500','','Unidad',12,10,448.2,465,1,50,NULL,'2024-04-03 11:05:14','2024-04-03 11:05:14'),(764,'ALDABON (PASADOR) INDUMA NIQUEL SATIN 3 PLG','','Unidad',25,12,5.41,9,1,10,NULL,'2024-04-03 11:07:47','2024-04-03 11:07:47'),(765,'CADENA DE ESLABON 3/16 ','','Yarda',36,12,6.29,11,1,10,NULL,'2024-04-03 11:16:27','2024-04-03 12:21:30'),(766,'CADENA DE ESLABON 5/16','','Yarda',36,12,18.1,27.75,1,10,NULL,'2024-04-03 11:17:52','2024-04-03 12:22:22'),(767,'CADENA PARA PERRO ESPESOR 1.7 MM NO.20','','Unidad',36,12,8.5,13.5,1,5,NULL,'2024-04-03 11:21:59','2024-04-03 12:04:57'),(768,'BLOCK FFACSA SELLO VERDE 14','','Unidad',20,16,5.4,5.5,1,6000,NULL,'2024-04-03 11:57:36','2024-04-03 11:57:36'),(769,'CEMENTO UGC 4060 PROGRESO Q79','','Saco',18,13,74.5,79,1,100,NULL,'2024-04-03 11:59:38','2024-04-03 11:59:38'),(770,'ALAMBRE DE AMARRE CALIBRE 16 AG 25 LBS','','25 Libras',12,10,4.75,139,1,8,NULL,'2024-04-03 12:05:03','2024-04-03 12:05:57'),(771,'CADENA PARA PERRO ESPESOR 2.2 MM NO.25','','Unidad',36,12,9.75,15,1,5,NULL,'2024-04-03 12:48:36','2024-04-03 12:48:36'),(772,'CADENA PARA PERRO ESPESOR 2.9 MM NO.35','','Unidad',36,12,14.25,22.5,1,5,NULL,'2024-04-03 12:51:21','2024-04-03 12:51:21'),(773,'CADENA PARA PERRO ESPESOR 3.2 MM NO.45','','Unidad',36,12,20.5,32,1,5,NULL,'2024-04-03 12:55:03','2024-04-03 12:55:03'),(774,'CINCHO PLASTICO NATURAL SHOWA 4.8 MM X 350 MM 14 PLG','','Bolsa',16,12,8.25,15,1,5,NULL,'2024-04-03 13:01:36','2024-04-03 13:01:36'),(775,'FELPA PARA RODILLO MICROFIBRA 3/8X9 PLG ','','Unidad',30,12,14.5,23,1,5,NULL,'2024-04-03 13:04:28','2024-04-03 13:04:28'),(776,'80050 SILICONE PERMATEX 85 G TRANSPARENTE  ','','Unidad',35,12,20,30,1,5,NULL,'2024-04-03 14:04:23','2024-04-03 14:04:23'),(777,'SPR3012 PINTURA EN SPRAY CROMADO','','Unidad',30,12,16.67,26,1,5,NULL,'2024-04-03 14:08:22','2024-04-03 14:08:22'),(778,'SP0004 PINTURA EN SPRAY NEGRO MATE','','Unidad',30,12,13.33,20,1,5,NULL,'2024-04-03 14:10:51','2024-04-03 14:10:51'),(779,'SP0036 PINTURA EN SPRAY PLATEADO (ALUMINIO)','','Unidad',30,12,13.33,20,1,5,NULL,'2024-04-03 14:12:20','2024-04-03 14:12:20'),(780,'SP31 PINTURA EN SPRAY ANARANJADO','','Unidad',30,12,13.33,20,1,5,NULL,'2024-04-03 14:13:29','2024-04-03 14:13:29'),(781,'POXILINA 38 ML','','Unidad',35,12,21.25,29.75,1,5,NULL,'2024-04-03 14:16:51','2024-04-03 14:16:51'),(782,'POXIPOL CAJA AZUL 14 ML COLOR GRIS','','Unidad',35,12,23,29.75,1,5,NULL,'2024-04-03 14:20:18','2024-04-03 14:20:18'),(783,'REGLETA 6 TOMACORRIENTES VERTICAL CAIMAN ','','Unidad',29,12,31,45,1,5,NULL,'2024-04-03 14:28:18','2024-04-03 14:28:18'),(784,'RODILLO CON FELPA 4X3/4 PLG ','','Unidad',30,12,13.85,19.75,1,5,NULL,'2024-04-03 14:29:33','2024-04-03 14:29:33'),(785,'RODILLO DE 5 ALAMBRES SIN FELPA CAIMAN','','Unidad',30,12,8.25,12,1,5,NULL,'2024-04-03 14:33:28','2024-04-03 14:33:28'),(786,'TIJERA PARA PODAR TRAMONTINA ','','Unidad',14,12,28.85,44,1,5,NULL,'2024-04-03 14:35:34','2024-04-03 14:35:34');
/*!40000 ALTER TABLE `item_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `po_items`
--

DROP TABLE IF EXISTS `po_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `po_items` (
  `po_id` int(30) NOT NULL,
  `item_id` int(30) NOT NULL,
  `quantity` int(30) NOT NULL,
  `price` float NOT NULL DEFAULT 0,
  `unit` varchar(50) NOT NULL,
  `total` float NOT NULL DEFAULT 0,
  KEY `po_id` (`po_id`),
  KEY `item_id` (`item_id`),
  CONSTRAINT `po_items_ibfk_1` FOREIGN KEY (`po_id`) REFERENCES `purchase_order_list` (`id`) ON DELETE CASCADE,
  CONSTRAINT `po_items_ibfk_2` FOREIGN KEY (`item_id`) REFERENCES `item_list` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `po_items`
--

LOCK TABLES `po_items` WRITE;
/*!40000 ALTER TABLE `po_items` DISABLE KEYS */;
INSERT INTO `po_items` (`po_id`, `item_id`, `quantity`, `price`, `unit`, `total`) VALUES (15,681,1,160,'Unidad',160),(15,682,1,110,'Unidad',110),(15,683,4,60,'Unidad',240),(15,684,4,16,'Unidad',64),(16,580,12,13.2,'Unidad',158.4),(16,581,12,18.05,'Unidad',216.6),(16,582,12,24.25,'Unidad',291),(16,583,12,41.75,'Unidad',501),(16,584,12,66.95,'Unidad ',803.4),(16,585,12,39.8,'Unidad',477.6),(16,586,12,55.3,'Unidad',663.6),(16,587,12,76.65,'Unidad',919.8),(16,588,12,55.3,'Unidad',663.6),(16,589,12,30.1,'Unidad',361.2),(16,590,12,38.8,'Unidad',465.6),(16,591,12,60.15,'Unidad',721.8),(16,592,6,20.4,'Unidad',122.4),(16,593,12,20.4,'Unidad',244.8),(16,594,6,20.4,'Unidad',122.4),(16,595,12,20.4,'Unidad',244.8),(16,596,1,45.6,'Unidad',45.6),(16,597,1,55.3,'Unidad',55.3),(16,598,1,77.6,'Unidad',77.6),(16,599,10,16.5,'Unidad',165),(16,600,10,16.5,'Unidad',165),(16,601,10,16.5,'Unidad',165),(16,602,6,72.75,'Unidad',436.5),(16,603,6,89.25,'Unidad',535.5),(16,604,6,15.55,'Unidad',93.3),(16,605,12,25.7,'Unidad',308.4),(16,606,12,14.1,'Unidad',169.2),(16,607,12,12.15,'Unidad',145.8),(16,608,10,33,'Unidad',330),(16,609,10,39.8,'Unidad',398),(16,610,10,41.75,'Unidad',417.5),(16,611,12,4.5,'Unidad',54),(16,612,12,7.2,'Unidad',86.4),(16,613,12,11.1,'Unidad',133.2),(16,614,12,17.5,'Unidad',210),(16,615,6,23.3,'Unidad',139.8),(16,616,6,34.95,'Unidad',209.7),(16,617,2,10.7,'Unidad',21.4),(16,618,2,17.5,'Unidad',35),(16,619,2,24.25,'Unidad',48.5),(16,620,2,33.95,'Unidad',67.9),(16,621,2,44.65,'Unidad',89.3),(16,622,20,1,'Unidad',20),(16,623,20,1.3,'Unidad',26),(16,624,6,1.95,'Unidad',11.7),(16,625,6,2.95,'Unidad',17.7),(16,626,6,3.9,'Unidad',23.4),(16,627,6,4.85,'Unidad',29.1),(16,628,6,7.1,'Unidad',42.6),(16,629,6,9.35,'Unidad',56.1),(16,630,6,11.1,'Unidad',66.6),(16,631,6,13.4,'Unidad',80.4),(16,632,6,15.65,'Unidad',93.9),(16,633,6,17.6,'Unidad',105.6),(16,634,6,18.95,'Unidad',113.7),(16,635,6,21.65,'Unidad',129.9),(16,636,6,22.15,'Unidad',132.9),(16,637,6,27.65,'Unidad',165.9),(16,638,6,30.1,'Unidad',180.6),(16,639,6,31.05,'Unidad',186.3),(16,640,6,33,'Unidad',198),(16,641,6,39.8,'Unidad',238.8),(16,642,10,3.35,'Unidad',33.5),(16,643,10,3.05,'Unidad',30.5),(16,644,10,2.5,'Unidad',25),(16,645,10,1.75,'Unidad',17.5),(16,646,6,11.25,'Unidad',67.5),(16,647,12,6.4,'Par',76.8),(16,648,12,6.8,'Unidad',81.6),(16,649,1,10.16,'Rollo',10.16);
/*!40000 ALTER TABLE `po_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `po_sales_items`
--

DROP TABLE IF EXISTS `po_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `po_sales_items` (
  `po_id` int(30) NOT NULL,
  `item_id` int(30) NOT NULL,
  `quantity` int(30) NOT NULL,
  `price` float NOT NULL DEFAULT 0,
  `unit` varchar(50) NOT NULL,
  `total` float NOT NULL DEFAULT 0,
  KEY `po_id` (`po_id`),
  KEY `item_id` (`item_id`),
  CONSTRAINT `po_sales_items_ibfk_1` FOREIGN KEY (`po_id`) REFERENCES `sales_order_list` (`id`) ON DELETE CASCADE,
  CONSTRAINT `po_sales_items_ibfk_2` FOREIGN KEY (`item_id`) REFERENCES `item_list` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `po_sales_items`
--

LOCK TABLES `po_sales_items` WRITE;
/*!40000 ALTER TABLE `po_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `po_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchase_order_list`
--

DROP TABLE IF EXISTS `purchase_order_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_order_list` (
  `id` int(30) NOT NULL AUTO_INCREMENT,
  `po_code` varchar(50) NOT NULL,
  `supplier_id` int(30) NOT NULL,
  `amount` float NOT NULL,
  `discount_perc` float NOT NULL DEFAULT 0,
  `discount` float NOT NULL DEFAULT 0,
  `tax_perc` float NOT NULL DEFAULT 0,
  `tax` float NOT NULL DEFAULT 0,
  `remarks` text NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '0 = pending, 1 = partially received, 2 =received',
  `date_created` datetime NOT NULL DEFAULT current_timestamp(),
  `date_updated` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  CONSTRAINT `purchase_order_list_ibfk_1` FOREIGN KEY (`supplier_id`) REFERENCES `supplier_list` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchase_order_list`
--

LOCK TABLES `purchase_order_list` WRITE;
/*!40000 ALTER TABLE `purchase_order_list` DISABLE KEYS */;
INSERT INTO `purchase_order_list` (`id`, `po_code`, `supplier_id`, `amount`, `discount_perc`, `discount`, `tax_perc`, `tax`, `remarks`, `status`, `date_created`, `date_updated`) VALUES (15,'PO-0001',18,574,0,0,0,0,'',2,'2024-04-01 09:37:54','2024-04-01 09:42:34'),(16,'PO-0002',14,13842.7,0,0,0,0,'',2,'2024-04-01 11:39:40','2024-04-01 13:17:34');
/*!40000 ALTER TABLE `purchase_order_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `receiving_list`
--

DROP TABLE IF EXISTS `receiving_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `receiving_list` (
  `id` int(30) NOT NULL AUTO_INCREMENT,
  `form_id` int(30) NOT NULL,
  `from_order` tinyint(1) NOT NULL DEFAULT 1 COMMENT '1=PO ,2 = BO',
  `amount` float NOT NULL DEFAULT 0,
  `discount_perc` float NOT NULL DEFAULT 0,
  `discount` float NOT NULL DEFAULT 0,
  `tax_perc` float NOT NULL DEFAULT 0,
  `tax` float NOT NULL DEFAULT 0,
  `stock_ids` text DEFAULT NULL,
  `remarks` text DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT current_timestamp(),
  `date_updated` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `receiving_list`
--

LOCK TABLES `receiving_list` WRITE;
/*!40000 ALTER TABLE `receiving_list` DISABLE KEYS */;
INSERT INTO `receiving_list` (`id`, `form_id`, `from_order`, `amount`, `discount_perc`, `discount`, `tax_perc`, `tax`, `stock_ids`, `remarks`, `date_created`, `date_updated`) VALUES (18,15,1,574,0,0,0,0,'198,199,200,201','','2024-04-01 09:42:34','2024-04-01 09:42:34'),(19,16,1,13842.7,0,0,0,0,'222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256,257,258,259,260,261,262,263,264,265,266,267,268,269,270,271,272,273,274,275,276,277,278,279,280,281,282,283,284,285,286,287,288,289,290,291','','2024-04-01 13:17:34','2024-04-01 13:17:34');
/*!40000 ALTER TABLE `receiving_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `return_list`
--

DROP TABLE IF EXISTS `return_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `return_list` (
  `id` int(30) NOT NULL AUTO_INCREMENT,
  `return_code` varchar(50) NOT NULL,
  `supplier_id` int(30) NOT NULL,
  `amount` float NOT NULL DEFAULT 0,
  `remarks` text DEFAULT NULL,
  `stock_ids` text NOT NULL,
  `date_created` datetime NOT NULL DEFAULT current_timestamp(),
  `date_updated` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  CONSTRAINT `return_list_ibfk_1` FOREIGN KEY (`supplier_id`) REFERENCES `supplier_list` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `return_list`
--

LOCK TABLES `return_list` WRITE;
/*!40000 ALTER TABLE `return_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `return_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_back_order_list`
--

DROP TABLE IF EXISTS `sales_back_order_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_back_order_list` (
  `id` int(30) NOT NULL AUTO_INCREMENT,
  `receiving_id` int(30) NOT NULL,
  `po_id` int(30) NOT NULL,
  `bo_code` varchar(50) NOT NULL,
  `customer_id` int(30) NOT NULL,
  `amount` float NOT NULL,
  `discount_perc` float NOT NULL DEFAULT 0,
  `discount` float NOT NULL DEFAULT 0,
  `tax_perc` float NOT NULL DEFAULT 0,
  `tax` float NOT NULL DEFAULT 0,
  `remarks` text DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '0 = pending, 1 = partially received, 2 =received',
  `date_created` datetime NOT NULL DEFAULT current_timestamp(),
  `date_updated` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `po_id` (`po_id`),
  KEY `receiving_id` (`receiving_id`),
  CONSTRAINT `sales_back_order_list_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `customer_list` (`id`) ON DELETE CASCADE,
  CONSTRAINT `sales_back_order_list_ibfk_2` FOREIGN KEY (`po_id`) REFERENCES `sales_order_list` (`id`) ON DELETE CASCADE,
  CONSTRAINT `sales_back_order_list_ibfk_3` FOREIGN KEY (`receiving_id`) REFERENCES `sales_receiving_list` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_back_order_list`
--

LOCK TABLES `sales_back_order_list` WRITE;
/*!40000 ALTER TABLE `sales_back_order_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_back_order_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_list`
--

DROP TABLE IF EXISTS `sales_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_list` (
  `id` int(30) NOT NULL AUTO_INCREMENT,
  `sales_code` varchar(50) NOT NULL,
  `client` text DEFAULT NULL,
  `amount` float NOT NULL DEFAULT 0,
  `remarks` text DEFAULT NULL,
  `stock_ids` text DEFAULT NULL,
  `discount_perc` float DEFAULT NULL,
  `discount` float DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT current_timestamp(),
  `date_updated` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_list`
--

LOCK TABLES `sales_list` WRITE;
/*!40000 ALTER TABLE `sales_list` DISABLE KEYS */;
INSERT INTO `sales_list` (`id`, `sales_code`, `client`, `amount`, `remarks`, `stock_ids`, `discount_perc`, `discount`, `date_created`, `date_updated`) VALUES (7,'SALE-0001','C/F',291,'','83,84,85,86',0,0,'2024-03-26 09:44:06','2024-03-26 09:44:06'),(8,'SALE-0002','LORENZO JUAREZ',1267,'','153,154,155,156,157,158,159,160,161,162,163,164,165,166',0,0,'2024-03-26 10:47:03','2024-03-26 17:24:56'),(9,'SALE-0003','GILBERTO LOPEZ',21159.1,'','176,177,178,179,180,181,182,183,184',0,0,'2024-03-31 23:07:18','2024-03-31 23:09:42'),(10,'SALE-0004','GILBERTO LOPEZ',10922,'','193,194,195,196,197',0,0,'2024-03-31 23:14:17','2024-03-31 23:21:46'),(12,'SALE-0005','IVAN RECINOS',1575.03,'','217,218,219,220,221',0,0,'2024-04-01 11:09:28','2024-04-01 11:09:28'),(13,'SALE-0006','CARMEN CALUSHA',1252.5,'','294,295,296',0,0,'2024-04-02 11:38:58','2024-04-02 11:40:12'),(14,'SALE-0007','C/F',1080,'','297,298',0,0,'2024-04-02 11:47:28','2024-04-02 11:47:28'),(15,'SALE-0008','C/F',536.5,'','299,300,301,302,303,304,305,306',0,0,'2024-04-02 12:51:35','2024-04-02 12:51:35'),(16,'SALE-0009','RUDY RODRIGUEZ',4212.13,'','382,383,384,385,386,387,388,389,390,391,392,393,394,395,396,397,398,399,400,401,402,403,404,405,406,407',0,0,'2024-04-02 13:58:23','2024-04-02 14:27:55'),(17,'SALE-0010','RUDY RODRIGUEZ',395,'','378,379,380,381',0,0,'2024-04-02 14:20:58','2024-04-02 14:27:23'),(18,'SALE-0011','CARMEN CALUSHA',2121.76,'','447,448,449,450,451,452',0,0,'2024-04-02 15:36:21','2024-04-02 15:52:40'),(19,'SALE-0012','C/F',379.75,'','471,472,473,474,475,476,477,478,479',0,0,'2024-04-02 18:53:13','2024-04-02 18:56:48'),(20,'SALE-0013','EDGAR CATALAN',6045,'','480',0,0,'2024-04-03 11:10:25','2024-04-03 11:10:25'),(21,'SALE-0014','GILBERTO LOPEZ',15472.5,'','505,506,507,508,509,510,511',0,0,'2024-04-03 12:02:45','2024-04-03 16:34:31'),(22,'SALE-0015','C/F',2753.63,'','491,492,493,494,495,496,497,498',0,0,'2024-04-03 12:52:22','2024-04-03 12:52:22');
/*!40000 ALTER TABLE `sales_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_order_list`
--

DROP TABLE IF EXISTS `sales_order_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_order_list` (
  `id` int(30) NOT NULL AUTO_INCREMENT,
  `po_code` varchar(50) NOT NULL,
  `customer_id` int(30) NOT NULL,
  `amount` float NOT NULL,
  `discount_perc` float NOT NULL DEFAULT 0,
  `discount` float NOT NULL DEFAULT 0,
  `tax_perc` float NOT NULL DEFAULT 0,
  `tax` float NOT NULL DEFAULT 0,
  `remarks` text NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '0 = pending, 1 = partially received, 2 =received',
  `NewCashValue` float DEFAULT NULL,
  `salesuser` varchar(100) DEFAULT NULL,
  `transfer` int(11) DEFAULT NULL,
  `no_transaccion` varchar(75) DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT current_timestamp(),
  `date_updated` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `sales_order_list_ibfk_1` (`customer_id`),
  CONSTRAINT `sales_order_list_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `customer_list` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_order_list`
--

LOCK TABLES `sales_order_list` WRITE;
/*!40000 ALTER TABLE `sales_order_list` DISABLE KEYS */;
INSERT INTO `sales_order_list` (`id`, `po_code`, `customer_id`, `amount`, `discount_perc`, `discount`, `tax_perc`, `tax`, `remarks`, `status`, `NewCashValue`, `salesuser`, `transfer`, `no_transaccion`, `date_created`, `date_updated`) VALUES (32,'PO-0001',3,106.1,0,0,0,0,'',0,106.1,'antony',NULL,'','2024-03-22 14:14:25','2024-03-22 14:15:15'),(33,'PO-0002',3,105,0,0,0,0,'',0,105,'antony',NULL,'','2024-03-23 10:04:06','2024-03-26 09:25:14'),(35,'PO-0003',3,745,0,0,0,0,'',0,74.5,'mrecinos',NULL,'','2024-03-23 13:10:47','2024-03-23 13:10:47'),(36,'PO-0004',3,560,0,0,0,0,'',0,560,'antony',NULL,'','2024-03-23 18:04:32','2024-03-23 18:04:32'),(37,'PO-0005',4,305.75,0,0,0,0,'',0,305.75,'antony',NULL,'','2024-03-23 18:24:44','2024-03-23 18:24:44'),(38,'PO-0006',10,1264,0,0,0,0,'',0,1257.5,'antony',NULL,'','2024-03-26 17:30:05','2024-03-26 17:38:41'),(39,'PO-0007',3,125.5,0,0,0,0,'',0,125.5,'antony',NULL,'','2024-03-27 11:44:34','2024-03-27 11:44:34'),(40,'PO-0008',3,62.5,0,0,0,0,'',0,62.5,'antony',NULL,'','2024-03-27 16:02:46','2024-03-27 16:02:46'),(41,'PO-0009',3,270,0,0,0,0,'',0,270,'antony',NULL,'','2024-03-27 16:06:40','2024-04-01 09:45:32'),(42,'PO-0010',3,52,0,0,0,0,'',0,52,'antony',NULL,'','2024-04-02 13:59:19','2024-04-02 13:59:19'),(43,'PO-0011',3,88.5,0,0,0,0,'',0,14.75,'antony',NULL,'','2024-04-03 09:11:36','2024-04-03 09:11:36'),(44,'PO-0012',11,986.15,0,0,0,0,'',0,89.65,'antony',NULL,'','2024-04-03 13:01:38','2024-04-03 13:01:38'),(45,'PO-0013',3,380.15,0,0,0,0,'',0,380.15,'antony',NULL,'','2024-04-03 13:07:59','2024-04-03 13:22:20'),(46,'PO-0014',3,109.5,0,0,0,0,'',0,103.5,'antony',NULL,'','2024-04-03 14:52:26','2024-04-03 14:52:26'),(47,'PO-0015',3,38.75,0,0,0,0,'',0,38.75,'antony',NULL,'','2024-04-03 16:02:16','2024-04-03 16:02:16'),(48,'PO-0016',3,24.75,0,0,0,0,'',0,9.75,'antony',NULL,'','2024-04-03 16:06:46','2024-04-03 16:06:46');
/*!40000 ALTER TABLE `sales_order_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_receiving_list`
--

DROP TABLE IF EXISTS `sales_receiving_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_receiving_list` (
  `id` int(30) NOT NULL AUTO_INCREMENT,
  `form_id` int(30) NOT NULL,
  `from_order` tinyint(1) NOT NULL DEFAULT 1 COMMENT '1=PO ,2 = BO',
  `amount` float NOT NULL DEFAULT 0,
  `discount_perc` float NOT NULL DEFAULT 0,
  `discount` float NOT NULL DEFAULT 0,
  `tax_perc` float NOT NULL DEFAULT 0,
  `tax` float NOT NULL DEFAULT 0,
  `stock_ids` text DEFAULT NULL,
  `remarks` text DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT current_timestamp(),
  `date_updated` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_receiving_list`
--

LOCK TABLES `sales_receiving_list` WRITE;
/*!40000 ALTER TABLE `sales_receiving_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_receiving_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `so_items`
--

DROP TABLE IF EXISTS `so_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `so_items` (
  `so_id` int(30) NOT NULL,
  `item_id` int(30) NOT NULL,
  `quantity` int(30) NOT NULL,
  `price` float NOT NULL DEFAULT 0,
  `unit` varchar(50) NOT NULL,
  `total` float NOT NULL DEFAULT 0,
  KEY `so_id` (`so_id`),
  KEY `item_id` (`item_id`),
  CONSTRAINT `so_items_ibfk_1` FOREIGN KEY (`so_id`) REFERENCES `sales_order_list` (`id`) ON DELETE CASCADE,
  CONSTRAINT `so_items_ibfk_2` FOREIGN KEY (`item_id`) REFERENCES `item_list` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `so_items`
--

LOCK TABLES `so_items` WRITE;
/*!40000 ALTER TABLE `so_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `so_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `so_sales_items`
--

DROP TABLE IF EXISTS `so_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `so_sales_items` (
  `po_id` int(30) NOT NULL,
  `item_id` int(30) NOT NULL,
  `quantity` int(30) NOT NULL,
  `price` float NOT NULL DEFAULT 0,
  `unit` varchar(50) NOT NULL,
  `total` float NOT NULL DEFAULT 0,
  KEY `po_id` (`po_id`),
  KEY `item_id` (`item_id`),
  CONSTRAINT `so_sales_items_ibfk_1` FOREIGN KEY (`po_id`) REFERENCES `sales_order_list` (`id`) ON DELETE CASCADE,
  CONSTRAINT `so_sales_items_ibfk_2` FOREIGN KEY (`item_id`) REFERENCES `item_list` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `so_sales_items`
--

LOCK TABLES `so_sales_items` WRITE;
/*!40000 ALTER TABLE `so_sales_items` DISABLE KEYS */;
INSERT INTO `so_sales_items` (`po_id`, `item_id`, `quantity`, `price`, `unit`, `total`) VALUES (32,385,6,0.2,'Unidad',1.2),(32,381,6,0.15,'Unidad',0.9),(32,236,1,56.5,'Unidad',56.5),(32,555,1,30,'Unidad ',30),(32,296,1,7.75,'Unidad',7.75),(32,93,1,9.75,'Unidad',9.75),(35,55,10,56.5,'Unidad',565),(35,37,10,18,'Unidad',180),(36,572,7,80,'Saco',560),(37,217,1,305.75,'Unidad',305.75),(33,85,20,5.25,'Unidad',105),(38,572,6,80,'Saco',480),(38,98,1,18.5,'Unidad',18.5),(38,316,1,10.75,'Unidad',10.75),(38,499,1,11,'UNIDAD',11),(38,650,1,80,'GALON',80),(38,23,1,6.5,'LIBRA',6.5),(38,416,3,6.5,'Libra',19.5),(38,649,5,15,'Yarda',75),(38,577,7,28.5,'Saco',199.5),(38,17,7,24.5,'Unidad',171.5),(38,651,20,5.2,'Unidad',104),(38,639,1,48,'UNIDAD',48),(38,652,1,30,'Flete',30),(38,653,3,3.25,'Unidad',9.75),(39,56,1,92,'Unidad',92),(39,551,1,33.5,'Unidad',33.5),(40,553,1,62.5,'Unidad',62.5),(41,518,50,0.5,'UNIDAD',25),(41,681,1,245,'Unidad',245),(42,199,1,21,'Unidad',21),(42,200,1,31,'Unidad',31),(43,323,6,14.75,'Unidad',88.5),(44,756,11,89.65,'Varilla',986.15),(45,37,15,20.5,'Unidad',307.5),(45,40,6,1.5,'Unidad',9),(45,49,1,1.15,'Unidad',1.15),(45,553,1,62.5,'Unidad',62.5),(46,349,1,28.5,'Unidad',28.5),(46,77,1,72,'Unidad',72),(46,525,3,3,'Unidad',9),(47,552,1,38.75,'Unidad',38.75),(48,150,1,3,'Unidad',3),(48,151,1,3.75,'Unidad',3.75),(48,525,6,3,'Unidad',18);
/*!40000 ALTER TABLE `so_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stock_list`
--

DROP TABLE IF EXISTS `stock_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_list` (
  `id` int(30) NOT NULL AUTO_INCREMENT,
  `item_id` int(30) NOT NULL,
  `quantity` int(30) NOT NULL,
  `unit` varchar(250) DEFAULT NULL,
  `price` float NOT NULL DEFAULT 0,
  `total` float NOT NULL DEFAULT current_timestamp(),
  `type` tinyint(1) NOT NULL DEFAULT 1 COMMENT '1=IN , 2=OUT',
  `date_created` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  CONSTRAINT `stock_list_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item_list` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=512 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stock_list`
--

LOCK TABLES `stock_list` WRITE;
/*!40000 ALTER TABLE `stock_list` DISABLE KEYS */;
INSERT INTO `stock_list` (`id`, `item_id`, `quantity`, `unit`, `price`, `total`, `type`, `date_created`) VALUES (83,40,1,'Unidad',1,1,3,'2024-03-26 09:44:06'),(84,41,1,'Unidad',1.5,1.5,3,'2024-03-26 09:44:06'),(85,66,1,'Unidad',24.5,24.5,3,'2024-03-26 09:44:06'),(86,68,1,'Juego',264,264,3,'2024-03-26 09:44:06'),(153,572,6,'Saco',80,480,3,'2024-03-26 17:24:56'),(154,98,1,'Unidad',18.5,18.5,3,'2024-03-26 17:24:56'),(155,316,1,'Unidad',10.75,10.75,3,'2024-03-26 17:24:56'),(156,499,1,'UNIDAD',11,11,3,'2024-03-26 17:24:56'),(157,650,1,'GALON',80,80,3,'2024-03-26 17:24:56'),(158,23,1,'LIBRA',6.5,6.5,3,'2024-03-26 17:24:56'),(159,416,3,'Libra',6.5,19.5,3,'2024-03-26 17:24:56'),(160,649,5,'YARDA (91 CMS)',15,75,3,'2024-03-26 17:24:56'),(161,577,7,'Saco',28.5,199.5,3,'2024-03-26 17:24:56'),(162,17,7,'Unidad',24.5,171.5,3,'2024-03-26 17:24:56'),(163,651,20,'Unidad',5.2,104,3,'2024-03-26 17:24:56'),(164,652,1,'Flete',30,30,3,'2024-03-26 17:24:56'),(165,640,1,'UNIDAD',51,51,3,'2024-03-26 17:24:56'),(166,653,3,'Unidad',3.25,9.75,3,'2024-03-26 17:24:56'),(176,28,56,'Unidad',51.95,2909.2,3,'2024-03-31 23:09:42'),(177,675,56,'Unidad',57.59,3225.04,3,'2024-03-31 23:09:42'),(178,674,56,'Unidad',44.59,2497.04,3,'2024-03-31 23:09:42'),(179,673,60,'Unidad',10.88,652.8,3,'2024-03-31 23:09:42'),(180,676,60,'Unidad',9.25,555,3,'2024-03-31 23:09:42'),(181,651,800,'Unidad',5.2,4160,3,'2024-03-31 23:09:42'),(182,576,50,'Saco',69,3450,3,'2024-03-31 23:09:42'),(183,678,50,'Saco',69,3450,3,'2024-03-31 23:09:42'),(184,679,1,'1/2 QQ',260,260,3,'2024-03-31 23:09:42'),(193,674,56,'Unidad',44.59,2497.04,3,'2024-03-31 23:21:46'),(194,676,60,'Unidad',9.25,555,3,'2024-03-31 23:21:46'),(195,651,800,'Unidad',5.2,4160,3,'2024-03-31 23:21:46'),(196,576,50,'Saco',69,3450,3,'2024-03-31 23:21:46'),(197,679,1,'1/2 QQ',260,260,3,'2024-03-31 23:21:46'),(198,681,1,'Unidad',160,160,1,'2024-04-01 09:42:34'),(199,682,1,'Unidad',110,110,1,'2024-04-01 09:42:34'),(200,683,4,'Unidad',60,240,1,'2024-04-01 09:42:34'),(201,684,4,'Unidad',16,64,1,'2024-04-01 09:42:34'),(217,676,30,'Varilla',9.75,292.5,3,'2024-04-01 11:09:28'),(218,673,30,'Varilla',10.88,326.4,3,'2024-04-01 11:09:28'),(219,707,13,'Varilla',23.25,302.25,3,'2024-04-01 11:09:28'),(220,680,13,'Varilla',25.75,334.75,3,'2024-04-01 11:09:28'),(221,674,7,'Varilla',45.59,319.13,3,'2024-04-01 11:09:28'),(222,580,12,'Unidad',13.2,158.4,1,'2024-04-01 13:17:34'),(223,581,12,'Unidad',18.05,216.6,1,'2024-04-01 13:17:34'),(224,582,12,'Unidad',24.25,291,1,'2024-04-01 13:17:34'),(225,583,12,'Unidad',41.75,501,1,'2024-04-01 13:17:34'),(226,584,12,'Unidad ',66.95,803.4,1,'2024-04-01 13:17:34'),(227,585,12,'Unidad',39.8,477.6,1,'2024-04-01 13:17:34'),(228,586,12,'Unidad',55.3,663.6,1,'2024-04-01 13:17:34'),(229,587,12,'Unidad',76.65,919.8,1,'2024-04-01 13:17:34'),(230,588,12,'Unidad',55.3,663.6,1,'2024-04-01 13:17:34'),(231,589,12,'Unidad',30.1,361.2,1,'2024-04-01 13:17:34'),(232,590,12,'Unidad',38.8,465.6,1,'2024-04-01 13:17:34'),(233,591,12,'Unidad',60.15,721.8,1,'2024-04-01 13:17:34'),(234,592,6,'Unidad',20.4,122.4,1,'2024-04-01 13:17:34'),(235,593,12,'Unidad',20.4,244.8,1,'2024-04-01 13:17:34'),(236,594,6,'Unidad',20.4,122.4,1,'2024-04-01 13:17:34'),(237,595,12,'Unidad',20.4,244.8,1,'2024-04-01 13:17:34'),(238,596,1,'Unidad',45.6,45.6,1,'2024-04-01 13:17:34'),(239,597,1,'Unidad',55.3,55.3,1,'2024-04-01 13:17:34'),(240,598,1,'Unidad',77.6,77.6,1,'2024-04-01 13:17:34'),(241,599,10,'Unidad',16.5,165,1,'2024-04-01 13:17:34'),(242,600,10,'Unidad',16.5,165,1,'2024-04-01 13:17:34'),(243,601,10,'Unidad',16.5,165,1,'2024-04-01 13:17:34'),(244,602,6,'Unidad',72.75,436.5,1,'2024-04-01 13:17:34'),(245,603,6,'Unidad',89.25,535.5,1,'2024-04-01 13:17:34'),(246,604,6,'Unidad',15.55,93.3,1,'2024-04-01 13:17:34'),(247,605,12,'Unidad',25.7,308.4,1,'2024-04-01 13:17:34'),(248,606,12,'Unidad',14.1,169.2,1,'2024-04-01 13:17:34'),(249,607,12,'Unidad',12.15,145.8,1,'2024-04-01 13:17:34'),(250,608,10,'Unidad',33,330,1,'2024-04-01 13:17:34'),(251,609,10,'Unidad',39.8,398,1,'2024-04-01 13:17:34'),(252,610,10,'Unidad',41.75,417.5,1,'2024-04-01 13:17:34'),(253,611,12,'Unidad',4.5,54,1,'2024-04-01 13:17:34'),(254,612,12,'Unidad',7.2,86.4,1,'2024-04-01 13:17:34'),(255,613,12,'Unidad',11.1,133.2,1,'2024-04-01 13:17:34'),(256,614,12,'Unidad',17.5,210,1,'2024-04-01 13:17:34'),(257,615,6,'Unidad',23.3,139.8,1,'2024-04-01 13:17:34'),(258,616,6,'Unidad',34.95,209.7,1,'2024-04-01 13:17:34'),(259,617,2,'Unidad',10.7,21.4,1,'2024-04-01 13:17:34'),(260,618,2,'Unidad',17.5,35,1,'2024-04-01 13:17:34'),(261,619,2,'Unidad',24.25,48.5,1,'2024-04-01 13:17:34'),(262,620,2,'Unidad',33.95,67.9,1,'2024-04-01 13:17:34'),(263,621,2,'Unidad',44.65,89.3,1,'2024-04-01 13:17:34'),(264,622,20,'Unidad',1,20,1,'2024-04-01 13:17:34'),(265,623,20,'Unidad',1.3,26,1,'2024-04-01 13:17:34'),(266,624,6,'Unidad',1.95,11.7,1,'2024-04-01 13:17:34'),(267,625,6,'Unidad',2.95,17.7,1,'2024-04-01 13:17:34'),(268,626,6,'Unidad',3.9,23.4,1,'2024-04-01 13:17:34'),(269,627,6,'Unidad',4.85,29.1,1,'2024-04-01 13:17:34'),(270,628,6,'Unidad',7.1,42.6,1,'2024-04-01 13:17:34'),(271,629,6,'Unidad',9.35,56.1,1,'2024-04-01 13:17:34'),(272,630,6,'Unidad',11.1,66.6,1,'2024-04-01 13:17:34'),(273,631,6,'Unidad',13.4,80.4,1,'2024-04-01 13:17:34'),(274,632,6,'Unidad',15.65,93.9,1,'2024-04-01 13:17:34'),(275,633,6,'Unidad',17.6,105.6,1,'2024-04-01 13:17:34'),(276,634,6,'Unidad',18.95,113.7,1,'2024-04-01 13:17:34'),(277,635,6,'Unidad',21.65,129.9,1,'2024-04-01 13:17:34'),(278,636,6,'Unidad',22.15,132.9,1,'2024-04-01 13:17:34'),(279,637,6,'Unidad',27.65,165.9,1,'2024-04-01 13:17:34'),(280,638,6,'Unidad',30.1,180.6,1,'2024-04-01 13:17:34'),(281,639,6,'Unidad',31.05,186.3,1,'2024-04-01 13:17:34'),(282,640,6,'Unidad',33,198,1,'2024-04-01 13:17:34'),(283,641,6,'Unidad',39.8,238.8,1,'2024-04-01 13:17:34'),(284,642,10,'Unidad',3.35,33.5,1,'2024-04-01 13:17:34'),(285,643,10,'Unidad',3.05,30.5,1,'2024-04-01 13:17:34'),(286,644,10,'Unidad',2.5,25,1,'2024-04-01 13:17:34'),(287,645,10,'Unidad',1.75,17.5,1,'2024-04-01 13:17:34'),(288,646,6,'Unidad',11.25,67.5,1,'2024-04-01 13:17:34'),(289,647,12,'Par',6.4,76.8,1,'2024-04-01 13:17:34'),(290,648,12,'Unidad',6.8,81.6,1,'2024-04-01 13:17:34'),(291,649,1,'Rollo',10.16,10.16,1,'2024-04-01 13:17:34'),(294,572,10,'Saco',80,800,3,'2024-04-02 11:40:12'),(295,577,15,'Saco',28.5,427.5,3,'2024-04-02 11:40:12'),(296,652,1,'Flete',25,25,3,'2024-04-02 11:40:12'),(297,651,100,'Unidad',5.2,520,3,'2024-04-02 11:47:28'),(298,709,100,'Unidad',5.6,560,3,'2024-04-02 11:47:28'),(299,750,1,'Saco',75.5,75.5,3,'2024-04-02 12:51:35'),(300,749,1,'Saco',68.75,68.75,3,'2024-04-02 12:51:35'),(301,748,1,'Saco',48,48,3,'2024-04-02 12:51:35'),(302,752,1,'Saco',69,69,3,'2024-04-02 12:51:35'),(303,753,1,'Saco',78,78,3,'2024-04-02 12:51:35'),(304,751,1,'Saco',48.25,48.25,3,'2024-04-02 12:51:35'),(305,572,1,'Saco',80,80,3,'2024-04-02 12:51:35'),(306,576,1,'Saco',69,69,3,'2024-04-02 12:51:35'),(378,758,1,'Docena ',85,85,3,'2024-04-02 14:27:23'),(379,757,1,'Docena ',85,85,3,'2024-04-02 14:27:23'),(380,759,1,'Docena ',140,140,3,'2024-04-02 14:27:23'),(381,760,1,'Unidad',85,85,3,'2024-04-02 14:27:23'),(382,572,1,'Saco',80,80,3,'2024-04-02 14:27:55'),(383,576,1,'Saco',69,69,3,'2024-04-02 14:27:55'),(384,574,1,'Saco',88,88,3,'2024-04-02 14:27:55'),(385,746,1,'Saco',69,69,3,'2024-04-02 14:27:55'),(386,747,1,'Saco',77,77,3,'2024-04-02 14:27:55'),(387,752,1,'Saco',69,69,3,'2024-04-02 14:27:55'),(388,753,1,'Saco',78,78,3,'2024-04-02 14:27:55'),(389,751,1,'Saco',48.25,48.25,3,'2024-04-02 14:27:55'),(390,744,1,'Unidad',28,28,3,'2024-04-02 14:27:55'),(391,750,1,'Saco',75.5,75.5,3,'2024-04-02 14:27:55'),(392,749,1,'Saco',68.75,68.75,3,'2024-04-02 14:27:55'),(393,748,1,'Saco',48,48,3,'2024-04-02 14:27:55'),(394,754,7,'Varilla',57.25,400.75,3,'2024-04-02 14:27:55'),(395,674,7,'Varilla',45.59,319.13,3,'2024-04-02 14:27:55'),(396,707,13,'Varilla',23.25,302.25,3,'2024-04-02 14:27:55'),(397,680,13,'Varilla',25.75,334.75,3,'2024-04-02 14:27:55'),(398,755,13,'Varilla',32.25,419.25,3,'2024-04-02 14:27:55'),(399,676,30,'Varilla',9.75,292.5,3,'2024-04-02 14:27:55'),(400,673,30,'Varilla',10.88,326.4,3,'2024-04-02 14:27:55'),(401,756,4,'Varilla',89.65,358.6,3,'2024-04-02 14:27:55'),(402,677,1,'Quintal',498.5,498.5,3,'2024-04-02 14:27:55'),(403,54,1,'Unidad',38.5,38.5,3,'2024-04-02 14:27:55'),(404,55,1,'Unidad',56.5,56.5,3,'2024-04-02 14:27:55'),(405,37,1,'Unidad',20.5,20.5,3,'2024-04-02 14:27:55'),(406,38,1,'Unidad',23,23,3,'2024-04-02 14:27:55'),(407,39,1,'Unidad',23,23,3,'2024-04-02 14:27:55'),(447,572,5,'Saco',80,400,3,'2024-04-02 15:52:40'),(448,416,20,'Libra',6.5,130,3,'2024-04-02 15:52:40'),(449,18,30,'Varilla',10.8,324,3,'2024-04-02 15:52:40'),(450,652,1,'Flete',25,25,3,'2024-04-02 15:52:40'),(451,674,14,'Varilla',45.59,638.26,3,'2024-04-02 15:52:40'),(452,707,26,'Varilla',23.25,604.5,3,'2024-04-02 15:52:40'),(471,37,2,'Unidad',20.5,41,3,'2024-04-02 18:56:48'),(472,761,2,'Unidad',59.75,119.5,3,'2024-04-02 18:56:48'),(473,55,1,'Unidad',56.5,56.5,3,'2024-04-02 18:56:48'),(474,40,6,'Unidad',1.5,9,3,'2024-04-02 18:56:48'),(475,731,6,'Unidad',3.5,21,3,'2024-04-02 18:56:48'),(476,59,4,'Unidad',13,52,3,'2024-04-02 18:56:48'),(477,61,2,'Unidad',17,34,3,'2024-04-02 18:56:48'),(478,450,1,'Unidad',8,8,3,'2024-04-02 18:56:48'),(479,552,1,'Unidad',38.75,38.75,3,'2024-04-02 18:56:48'),(480,763,13,'Unidad',465,6045,3,'2024-04-03 11:10:25'),(491,673,30,'Varilla',10.88,326.4,3,'2024-04-03 12:52:22'),(492,676,30,'Varilla',9.75,292.5,3,'2024-04-03 12:52:22'),(493,707,13,'Varilla',23.25,302.25,3,'2024-04-03 12:52:22'),(494,680,13,'Varilla',25.75,334.75,3,'2024-04-03 12:52:22'),(495,755,13,'Varilla',32.25,419.25,3,'2024-04-03 12:52:22'),(496,674,7,'Varilla',45.59,319.13,3,'2024-04-03 12:52:22'),(497,754,7,'Varilla',57.25,400.75,3,'2024-04-03 12:52:22'),(498,756,4,'Varilla',89.65,358.6,3,'2024-04-03 12:52:22'),(505,769,80,'Saco',79,6320,3,'2024-04-03 16:34:31'),(506,754,52,'Varilla',57.25,2977,3,'2024-04-03 16:34:31'),(507,707,39,'Varilla',23.25,906.75,3,'2024-04-03 16:34:31'),(508,673,60,'Varilla',10.88,652.8,3,'2024-04-03 16:34:31'),(509,770,1,'25 Libras',139,139,3,'2024-04-03 16:34:31'),(510,54,2,'Unidad',38.5,77,3,'2024-04-03 16:34:31'),(511,768,800,'Unidad',5.5,4400,3,'2024-04-03 16:34:31');
/*!40000 ALTER TABLE `stock_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `supplier_list`
--

DROP TABLE IF EXISTS `supplier_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `supplier_list` (
  `id` int(30) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `address` text NOT NULL,
  `cperson` text NOT NULL,
  `contact` text NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `date_created` datetime NOT NULL DEFAULT current_timestamp(),
  `date_updated` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `supplier_list`
--

LOCK TABLES `supplier_list` WRITE;
/*!40000 ALTER TABLE `supplier_list` DISABLE KEYS */;
INSERT INTO `supplier_list` (`id`, `name`, `address`, `cperson`, `contact`, `status`, `date_created`, `date_updated`) VALUES (1,'CENTRO CAL','5A. AV. CALLE 4 ZONA 11 GUATEMALA','ELVIRA MONT','35478985',1,'2021-11-02 09:36:19','2024-03-18 11:27:55'),(2,'HIERROS GENUINO C.A.','GUATEMALA','SANTOS RAMIREZ','22458796',1,'2021-11-02 09:36:54','2023-11-24 08:01:05'),(4,'CEMENTOS PROGRESO','Guatemala Centro America','JULIO PIVARAL','42454647',1,'2023-11-24 07:56:28','2024-03-18 11:27:43'),(5,'GERFOR','Santa LucÃ­a Milpas Altas, SacatepÃ©quez','JORGE RODRIGUEZ','50186574',1,'2024-02-10 08:27:33','2024-03-18 11:28:19'),(6,'MULTI LIDERES EN ACERO','SALCAJA, QUETZALTENANGO','ISMAEL VICENTE','31156583',1,'2024-03-06 12:08:06','2024-03-06 12:21:50'),(7,'HERRAMIENTAS PODEROSAS TRUPER','Guatemala','LEONEL CAMAS','59669577',1,'2024-03-08 13:39:37','2024-03-18 11:28:55'),(8,'HERON','Guatemala','RUBESLY','31279706',1,'2024-03-08 13:40:18','2024-03-18 11:28:33'),(9,'ROTOPLAS','Guatemala','Katerine Batz','56956388',1,'2024-03-08 13:40:58','2024-03-08 13:40:58'),(10,'ACEROS DE GUATEMALA','TOJOCAZ HUEHUETENANGO','BERLIN','31188654',1,'2024-03-11 09:58:54','2024-03-11 09:58:54'),(11,'INTERTORNILLOS S.A.','COLONIA TOLEDO, ZONA 7 GUATEMALA','BLANCA BARRERA ','59273729',1,'2024-03-13 14:22:18','2024-03-13 14:22:18'),(12,'DISTRIBUIDORA EL PACIFICO S.A. ','2DA. AVENIDA 1RA. CALLE 01-74 ZONA 9, CIUDAD DE GUATEMALA, GUATEMALA','JUAN MIRANDA  ','30880547',1,'2024-03-15 14:10:23','2024-03-15 14:10:23'),(13,'FERRETERIA DANIELITO ','CANTON LA HAMACA OCUBILA, KM 268, HUEHUETENANGO','---','36895994 - 57350375',1,'2024-03-19 12:22:00','2024-03-19 12:22:00'),(14,'KUVAL','27 CALLE FINAL 37-50 ZONA 5, COMERCIAL LA JOYA, BODEGA 11, GUATEMALA.','ROBIN SILVA ','30039437',1,'2024-03-22 13:22:06','2024-03-22 13:22:06'),(15,'CONSTRUFACIL','CHIMUSINIQUE','','',1,'2024-03-26 10:40:21','2024-03-26 10:40:21'),(16,'FFACSA','','','',1,'2024-03-26 10:50:38','2024-03-26 10:50:38'),(17,'ANTONY','','57668445','',1,'2024-03-26 10:53:16','2024-03-26 10:53:16'),(18,'INDEPENDIENTE','','','',1,'2024-04-01 09:31:57','2024-04-01 09:31:57');
/*!40000 ALTER TABLE `supplier_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_info`
--

DROP TABLE IF EXISTS `system_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system_info` (
  `id` int(30) NOT NULL AUTO_INCREMENT,
  `meta_field` text NOT NULL,
  `meta_value` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_info`
--

LOCK TABLES `system_info` WRITE;
/*!40000 ALTER TABLE `system_info` DISABLE KEYS */;
INSERT INTO `system_info` (`id`, `meta_field`, `meta_value`) VALUES (1,'name','FERRECON-Pos'),(6,'short_name','FERRECON'),(11,'logo','uploads/logo-1705408214.png'),(13,'user_avatar','uploads/user_avatar.jpg'),(14,'cover','uploads/cover-1635816671.png'),(15,'content','Array');
/*!40000 ALTER TABLE `system_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_meta` (
  `user_id` int(30) NOT NULL,
  `meta_field` text NOT NULL,
  `meta_value` text NOT NULL,
  `date_created` datetime NOT NULL DEFAULT current_timestamp(),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `firstname` varchar(250) NOT NULL,
  `middlename` text DEFAULT NULL,
  `lastname` varchar(250) NOT NULL,
  `username` text NOT NULL,
  `password` text NOT NULL,
  `avatar` text DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `date_added` datetime NOT NULL DEFAULT current_timestamp(),
  `date_updated` datetime DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` (`id`, `firstname`, `middlename`, `lastname`, `username`, `password`, `avatar`, `last_login`, `type`, `date_added`, `date_updated`) VALUES (1,'Adminstrator',NULL,'Admin','admin','943c3348b5a0e678b8532696af5acb62','uploads/avatar-1.png?v=1635556826',NULL,1,'2021-01-20 14:02:37','2024-01-11 08:06:15'),(11,'Antony',NULL,'HernÃ¡ndez','antony','7216c762aee54ad191669b05bb5499c0','uploads/avatar-11.png?v=1635920566',NULL,1,'2021-11-03 14:22:46','2024-03-06 11:48:53'),(12,'Dayra Candy',NULL,'HernÃ¡ndez','dayrahernandez','8e3dcce8b1a1fa3c55480f76a17f2ad0',NULL,NULL,2,'2024-02-10 08:21:59',NULL),(13,'Lorenzo ',NULL,'Juarez','ljuarez','06ead0ee0a596d759c0081e7bb7b091a',NULL,NULL,1,'2024-02-10 08:23:15',NULL),(14,'Maynor',NULL,'Recinos','mrecinos','bd9691c5a77c7b6fc1666de6670b9eae',NULL,NULL,2,'2024-02-10 10:42:51',NULL),(15,'Angela',NULL,'De Leon','deleon','11330d1b99483f670e424cbd0504bb09',NULL,NULL,2,'2024-02-10 10:44:05',NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping events for database 'ferrecon_posinv'
--

--
-- Dumping routines for database 'ferrecon_posinv'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-04-07  2:20:30
